/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import org.jhotdraw.color.NamedColorSpace;

public class HSBColorSpace
extends ColorSpace
implements NamedColorSpace {
    private static HSBColorSpace instance;

    public static HSBColorSpace getInstance() {
        if (instance == null) {
            instance = new HSBColorSpace();
        }
        return instance;
    }

    public HSBColorSpace() {
        super(7, 3);
    }

    @Override
    public float[] toRGB(float[] c) {
        int rgb = Color.HSBtoRGB(c[0], c[1], c[2]);
        return new float[]{(float)((rgb & 0xFF0000) >> 16) / 255.0f, (float)((rgb & 0xFF00) >> 8) / 255.0f, (float)(rgb & 0xFF) / 255.0f};
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        return Color.RGBtoHSB((int)(rgbvalue[0] * 255.0f), (int)(rgbvalue[1] * 255.0f), (int)(rgbvalue[2] * 255.0f), new float[3]);
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        float[] rgb = this.toRGB(colorvalue);
        return ColorSpace.getInstance(1000).toCIEXYZ(rgb);
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        float[] sRGB = ColorSpace.getInstance(1000).fromCIEXYZ(colorvalue);
        return this.fromRGB(sRGB);
    }

    @Override
    public String getName(int idx) {
        switch (idx) {
            case 0: {
                return "Hue";
            }
            case 1: {
                return "Saturation";
            }
            case 2: {
                return "Brightness";
            }
        }
        throw new IllegalArgumentException("index must be between 0 and 2:" + idx);
    }

    @Override
    public float getMaxValue(int component) {
        return 1.0f;
    }

    @Override
    public float getMinValue(int component) {
        return 0.0f;
    }

    public boolean equals(Object o) {
        return o instanceof HSBColorSpace;
    }

    public int hashCode() {
        return this.getClass().getSimpleName().hashCode();
    }

    @Override
    public String getName() {
        return "HSB";
    }
}

