/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.gui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import org.jhotdraw.gui.AttributeEditor;
import org.jhotdraw.gui.JLifeFormattedTextField;
import org.jhotdraw.util.ResourceBundleUtil;

public class JAttributeTextField<T>
extends JLifeFormattedTextField
implements AttributeEditor<T> {
    private boolean isMultipleValues;

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isFocusOwner() && this.isMultipleValues) {
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.gui.Labels");
            Color c = this.getForeground();
            this.setForeground(new Color(0, true));
            super.paintComponent(g);
            Insets insets = this.getInsets();
            Insets margin = this.getMargin();
            FontMetrics fm = g.getFontMetrics(this.getFont());
            g.setFont(this.getFont().deriveFont(2));
            this.setForeground(c);
            g.setColor(c);
            g.drawString(labels.getString("attribute.differentValues.text"), insets.left + margin.left, insets.top + margin.top + fm.getAscent());
        } else {
            super.paintComponent(g);
        }
    }

    private void initComponents() {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public T getAttributeValue() {
        return (T)this.getValue();
    }

    @Override
    public void setMultipleValues(boolean newValue) {
        this.isMultipleValues = newValue;
        this.repaint();
    }

    @Override
    public boolean isMultipleValues() {
        return this.isMultipleValues;
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isFocusOwner();
    }

    @Override
    public void setAttributeValue(T newValue) {
        this.setValue(newValue);
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
        if (propertyName == "value") {
            super.firePropertyChange("attributeValue", oldValue, newValue);
        }
    }
}

