/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.layouter;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.layouter.AbstractLayouter;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Insets2D;

public class HorizontalLayouter
extends AbstractLayouter {
    @Override
    public Rectangle2D.Double calculateLayout(CompositeFigure compositeFigure, Point2D.Double anchor, Point2D.Double lead) {
        Insets2D.Double layoutInsets = compositeFigure.get(AttributeKeys.LAYOUT_INSETS);
        Rectangle2D.Double layoutBounds = new Rectangle2D.Double(anchor.x, anchor.y, 0.0, 0.0);
        for (Figure child : compositeFigure.getChildren()) {
            if (!child.isVisible()) continue;
            Dimension2DDouble preferredSize = child.getPreferredSize();
            Insets2D.Double ins = this.getInsets(child);
            layoutBounds.height = Math.max(layoutBounds.height, preferredSize.height + ins.top + ins.bottom);
            layoutBounds.width += preferredSize.width + ins.left + ins.right;
        }
        layoutBounds.width += layoutInsets.left + layoutInsets.right;
        layoutBounds.height += layoutInsets.top + layoutInsets.bottom;
        return layoutBounds;
    }

    @Override
    public Rectangle2D.Double layout(CompositeFigure compositeFigure, Point2D.Double anchor, Point2D.Double lead) {
        Insets2D.Double layoutInsets = compositeFigure.get(AttributeKeys.LAYOUT_INSETS);
        AttributeKeys.Alignment compositeAlignment = compositeFigure.get(AttributeKeys.COMPOSITE_ALIGNMENT);
        Rectangle2D.Double layoutBounds = this.calculateLayout(compositeFigure, anchor, lead);
        double x = layoutBounds.x + layoutInsets.left;
        for (Figure child : compositeFigure.getChildren()) {
            if (!child.isVisible()) continue;
            Insets2D.Double insets = this.getInsets(child);
            double width = child.getPreferredSize().width;
            double height = child.getPreferredSize().height;
            switch (compositeAlignment) {
                case LEADING: {
                    child.setBounds(new Point2D.Double(x + insets.left, layoutBounds.y + layoutInsets.top + insets.top), new Point2D.Double(x + insets.left + width, layoutBounds.y + layoutInsets.top + insets.top + height));
                    break;
                }
                case TRAILING: {
                    child.setBounds(new Point2D.Double(x + insets.left, layoutBounds.y + layoutBounds.height - layoutInsets.bottom - insets.bottom - height), new Point2D.Double(x + insets.left + width, layoutBounds.y + layoutBounds.height - layoutInsets.bottom - insets.bottom));
                    break;
                }
                case CENTER: {
                    child.setBounds(new Point2D.Double(x + insets.left, layoutBounds.y + layoutInsets.top + (layoutBounds.height - height) / 2.0), new Point2D.Double(x + insets.left + width, layoutBounds.y + layoutInsets.top + (layoutBounds.height + height) / 2.0));
                    break;
                }
                default: {
                    child.setBounds(new Point2D.Double(x + insets.left, layoutBounds.y + layoutInsets.top + insets.top), new Point2D.Double(x + insets.left + width, layoutBounds.y + layoutBounds.height - layoutInsets.bottom - insets.bottom));
                }
            }
            x += width + insets.left + insets.right;
        }
        return layoutBounds;
    }
}

