/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.lut;

import net.imglib2.Dimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealViews;
import net.imglib2.realtransform.ScaleAndTranslation;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.RealComposite;

public abstract class AbstractLUTGrid
implements InvertibleRealTransform {
    protected final int numSourceDimensions;
    protected final int numTargetDimensions;
    protected final int lutMaxIndex;
    protected final int nNonTransformedCoordinates;
    protected final Dimensions dimensions;
    protected final RandomAccessibleInterval<DoubleType> lutArray;
    protected final RealRandomAccessible<RealComposite<DoubleType>> coefficients;
    protected final InterpolatorFactory<RealComposite<DoubleType>, RandomAccessible<RealComposite<DoubleType>>> interpolatorFactory = new NLinearInterpolatorFactory();
    protected RealRandomAccess<RealComposite<DoubleType>> access;
    protected RealComposite<DoubleType> currentLut;
    protected double[] scale;
    protected double[] shift;

    public AbstractLUTGrid(int numSourceDimensions, int numTargetDimensions, RandomAccessibleInterval<DoubleType> lutArray) {
        this(numSourceDimensions, numTargetDimensions, lutArray, new double[]{1.0}, new double[]{0.0});
    }

    public AbstractLUTGrid(int numSourceDimensions, int numTargetDimensions, RandomAccessibleInterval<DoubleType> lutArray, double[] scale, double[] shift) {
        this.numSourceDimensions = numSourceDimensions;
        this.numTargetDimensions = numTargetDimensions;
        this.lutArray = lutArray;
        CompositeIntervalView collapsedSource = Views.collapseReal(lutArray);
        this.dimensions = new FinalInterval((Interval)collapsedSource);
        this.nNonTransformedCoordinates = this.dimensions.numDimensions();
        this.lutMaxIndex = (int)this.lutArray.dimension(this.nNonTransformedCoordinates) - 1;
        this.scale = new double[this.nNonTransformedCoordinates];
        this.shift = new double[this.nNonTransformedCoordinates];
        this.copyAndFillIfNecessary(scale, this.scale);
        this.copyAndFillIfNecessary(shift, this.shift);
        ScaleAndTranslation scaleAndShift = new ScaleAndTranslation(this.scale, this.shift);
        ExtendedRandomAccessibleInterval extendedCollapsedSource = Views.extendBorder((RandomAccessibleInterval)collapsedSource);
        this.coefficients = RealViews.transform((RealRandomAccessible)Views.interpolate((EuclideanSpace)extendedCollapsedSource, this.interpolatorFactory), (InvertibleRealTransform)scaleAndShift);
        this.access = this.coefficients.realRandomAccess();
        this.currentLut = (RealComposite)this.access.get();
    }

    public int numSourceDimensions() {
        return this.numSourceDimensions;
    }

    public int numTargetDimensions() {
        return this.numTargetDimensions;
    }

    protected double apply(double lutCoordinate) {
        this.currentLut = (RealComposite)this.access.get();
        int zFloor = (int)lutCoordinate;
        double floorVal = ((DoubleType)this.currentLut.get((long)zFloor)).get();
        double nextVal = ((DoubleType)this.currentLut.get((long)(zFloor + 1))).get();
        double dz = lutCoordinate - (double)zFloor;
        return (nextVal - floorVal) * dz + floorVal;
    }

    protected double applyChecked(double lutCoordinate) {
        if (lutCoordinate < 0.0) {
            return -1.7976931348623157E308;
        }
        if (lutCoordinate > (double)this.lutMaxIndex) {
            return Double.MAX_VALUE;
        }
        if (lutCoordinate == (double)this.lutMaxIndex) {
            return ((DoubleType)((RealComposite)this.access.get()).get((long)this.lutMaxIndex)).get();
        }
        return this.apply(lutCoordinate);
    }

    protected int findFloorIndex(double realLutCoordinate) {
        this.currentLut = (RealComposite)this.access.get();
        int min = 0;
        int max = this.lutMaxIndex;
        int i = max >> 1;
        do {
            if (((DoubleType)this.currentLut.get((long)i)).get() > realLutCoordinate) {
                max = i;
                continue;
            }
            min = i;
        } while ((i = max + min >> 1) != min);
        return i;
    }

    public double applyInverse(double realLutCoordinate) {
        int i = this.findFloorIndex(realLutCoordinate);
        this.currentLut = (RealComposite)this.access.get();
        double realZ1 = ((DoubleType)this.currentLut.get((long)i)).get();
        double realZ2 = ((DoubleType)this.currentLut.get((long)(i + 1))).get();
        return (realLutCoordinate - realZ1) / (realZ2 - realZ1) + (double)i;
    }

    public double applyInverseChecked(double realLutCoordinate) {
        this.currentLut = (RealComposite)this.access.get();
        if (realLutCoordinate < ((DoubleType)this.currentLut.get(0L)).get()) {
            return -1.7976931348623157E308;
        }
        if (realLutCoordinate > ((DoubleType)this.currentLut.get((long)this.lutMaxIndex)).get()) {
            return Double.MAX_VALUE;
        }
        return this.applyInverse(realLutCoordinate);
    }

    public double minTransformedCoordinate(double[] gridCoordinates) {
        this.updateCoordinates(gridCoordinates);
        return ((DoubleType)((RealComposite)this.access.get()).get(0L)).get();
    }

    public double maxTransformedCoordinate(double[] gridCoordinates) {
        this.updateCoordinates(gridCoordinates);
        return ((DoubleType)((RealComposite)this.access.get()).get((long)this.lutMaxIndex)).get();
    }

    protected void updateCoordinates(double[] gridCoordinates) {
        for (int d = 0; d < this.nNonTransformedCoordinates; ++d) {
            this.access.setPosition(gridCoordinates[d], d);
        }
    }

    protected void updateCoordinates(float[] gridCoordinates) {
        for (int d = 0; d < this.nNonTransformedCoordinates; ++d) {
            this.access.setPosition(gridCoordinates[d], d);
        }
    }

    protected void updateCoordinates(RealLocalizable gridCoordinates) {
        for (int d = 0; d < this.nNonTransformedCoordinates; ++d) {
            this.access.setPosition(gridCoordinates.getDoublePosition(d), d);
        }
    }

    protected void copyAndFillIfNecessary(double[] source, double[] target) {
        int i;
        int range = Math.min(source.length, target.length);
        for (i = 0; i < range; ++i) {
            target[i] = source[i];
        }
        for (i = range; i < target.length; ++i) {
            target[i] = source[source.length - 1];
        }
    }
}

