/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata;

import com.google.gson.JsonElement;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.Scale;
import net.imglib2.realtransform.Scale2D;
import net.imglib2.realtransform.Scale3D;
import net.imglib2.realtransform.ScaleAndTranslation;
import net.imglib2.realtransform.ScaleAndTranslationGet;
import net.imglib2.realtransform.Translation;
import net.imglib2.realtransform.Translation2D;
import net.imglib2.realtransform.Translation3D;
import org.apache.commons.lang3.ArrayUtils;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.NgffSingleScaleAxesMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.coordinateTransformations.CoordinateTransformation;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.coordinateTransformations.ScaleCoordinateTransformation;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.coordinateTransformations.TranslationCoordinateTransformation;

public class MetadataUtils {
    public static final String DOWN_SAMPLE = "Sample";
    public static final String DOWN_AVERAGE = "Average";

    public static double[] mul(double[] a, double[] b) {
        double[] out = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            out[i] = a[i] * b[i];
        }
        return out;
    }

    public static double[] mul(double[] a, long[] b) {
        double[] out = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            out[i] = a[i] * (double)b[i];
        }
        return out;
    }

    public static double[][] scalesAndTranslations(double[] baseScale, double[] downsamplingFactors, int numLevels) {
        int numDimensions = baseScale.length;
        double[][] out = new double[numLevels][numDimensions];
        for (int i = 0; i < numLevels; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                out[i][d] = i == 0 ? baseScale[d] : out[i - 1][d] * downsamplingFactors[d];
            }
        }
        return out;
    }

    public static long[] downsamplingFactors(long factor, long[] dimensions, String[] types) {
        int nd = dimensions.length;
        long[] factors = new long[nd];
        for (int i = 0; i < nd; ++i) {
            factors[i] = dimensions[i] > factor && !types[i].equals("channel") ? factor : 1L;
        }
        return factors;
    }

    public static long[] updateDownsamplingFactors(long factor, long[] baseFactors, long[] dimensions, String[] types) {
        int nd = dimensions.length;
        long[] factors = new long[nd];
        for (int i = 0; i < nd; ++i) {
            factors[i] = dimensions[i] > factor && !types[i].equals("channel") ? factor * baseFactors[i] : baseFactors[i];
        }
        return factors;
    }

    public static CoordinateTransformation<?>[] buildScaleTranslationTransformList(double[] scale, double[] translation) {
        int nTforms = 0;
        if (scale != null) {
            ++nTforms;
        }
        if (translation != null) {
            ++nTforms;
        }
        CoordinateTransformation[] coordinateTransformations = new CoordinateTransformation[nTforms];
        int i = 0;
        if (scale != null) {
            coordinateTransformations[i++] = new ScaleCoordinateTransformation(scale);
        }
        if (translation != null) {
            coordinateTransformations[i++] = new TranslationCoordinateTransformation(translation);
        }
        return coordinateTransformations;
    }

    public static ScaleAndTranslation scaleTranslationFromCoordinateTransformations(CoordinateTransformation<?>[] cts) {
        if (cts == null || cts.length == 0) {
            return null;
        }
        ScaleAndTranslation out = MetadataUtils.coordinateTransformToScaleAndTranslation(cts[0]);
        for (int i = 1; i < cts.length; ++i) {
            out.preConcatenate((ScaleAndTranslationGet)MetadataUtils.coordinateTransformToScaleAndTranslation(cts[i]));
        }
        return out;
    }

    public static ScaleAndTranslation coordinateTransformToScaleAndTranslation(CoordinateTransformation<?> ct) {
        if (ct.getType().equals("scale")) {
            double[] s = ((ScaleCoordinateTransformation)ct).getScale();
            return new ScaleAndTranslation(s, new double[s.length]);
        }
        if (ct.getType().equals("translation")) {
            double[] t = ((TranslationCoordinateTransformation)ct).getTranslation();
            double[] s = new double[t.length];
            Arrays.fill(s, 1.0);
            return new ScaleAndTranslation(s, t);
        }
        return null;
    }

    public static N5SingleScaleMetadata setDatasetAttributes(N5SingleScaleMetadata baseMetadata, N5DatasetMetadata datasetMetadata) {
        if (baseMetadata.getPath().equals(datasetMetadata.getPath())) {
            return new N5SingleScaleMetadata(baseMetadata.getPath(), baseMetadata.spatialTransform3d(), baseMetadata.getDownsamplingFactors(), baseMetadata.getPixelResolution(), baseMetadata.getOffset(), baseMetadata.unit(), datasetMetadata.getAttributes());
        }
        return null;
    }

    public static N5SingleScaleMetadata[] updateChildrenDatasetAttributes(N5SingleScaleMetadata[] baseMetadata, N5DatasetMetadata[] datasetMetadata) {
        HashMap bases = new HashMap();
        Arrays.stream(baseMetadata).forEach(x -> bases.put(x.getPath(), x));
        return (N5SingleScaleMetadata[])Arrays.stream(datasetMetadata).map(x -> {
            N5SingleScaleMetadata b = (N5SingleScaleMetadata)bases.get(x.getPath());
            if (b == null) {
                return null;
            }
            return MetadataUtils.setDatasetAttributes(b, x);
        }).filter(x -> x != null).toArray();
    }

    public static void updateChildrenMetadata(N5TreeNode parent, N5Metadata[] childrenMetadata, boolean relative) {
        HashMap children = new HashMap();
        Arrays.stream(childrenMetadata).forEach(x -> {
            String absolutePath = relative ? MetadataUtils.normalizeGroupPath(parent.getPath() + "/" + x.getPath()) : x.getPath();
            children.put(absolutePath, x);
        });
        parent.childrenList().forEach(c -> {
            N5Metadata m = (N5Metadata)children.get(MetadataUtils.normalizeGroupPath(c.getPath()));
            if (m != null) {
                c.setMetadata(m);
            }
        });
    }

    public static String canonicalPath(N5TreeNode parent, String child) {
        return MetadataUtils.canonicalPath(parent.getPath(), child);
    }

    public static String canonicalPath(String parent, String child) {
        try {
            N5URI url = new N5URI("?/" + parent + "/" + child);
            return url.normalizeGroupPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static String normalizeGroupPath(String path) {
        try {
            return new N5URI("?" + path).normalizeGroupPath();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return path;
        }
    }

    public static String relativePath(String parent, String child) {
        try {
            String purl = new N5URI("?" + parent).normalizeGroupPath();
            String curl = new N5URI("?" + child).normalizeGroupPath();
            return new N5URI("?" + curl.replaceFirst("^" + purl, "")).normalizeGroupPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            return child;
        }
    }

    public static double[] pow(double[] x, int d) {
        double[] y = new double[x.length];
        Arrays.fill(y, 1.0);
        for (int i = 0; i < d; ++i) {
            for (int j = 0; j < x.length; ++j) {
                int n = j;
                y[n] = y[n] * x[j];
            }
        }
        return y;
    }

    public static String getStringNullable(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return element.getAsString();
    }

    public static AffineGet scaleTranslationTransforms(double[] scale, double[] translation) {
        if (translation != null) {
            if (scale != null) {
                return new ScaleAndTranslation(scale, translation);
            }
            if (translation.length == 2) {
                return new Translation2D(translation);
            }
            if (translation.length == 3) {
                return new Translation3D(translation);
            }
            return new Translation(translation);
        }
        if (scale != null) {
            if (scale.length == 2) {
                return new Scale2D(scale);
            }
            if (scale.length == 3) {
                return new Scale3D(scale);
            }
            return new Scale(scale);
        }
        return null;
    }

    public static <M extends N5DatasetMetadata> M metadataForThisScale(String newPath, M baseMetadata, String downsampleMethod, double[] baseResolution, double[] absoluteDownsamplingFactors, double[] absoluteScale, double[] absoluteTranslation) {
        if (baseMetadata == null) {
            return null;
        }
        if (baseMetadata.getClass().equals(N5SingleScaleMetadata.class)) {
            return (M)MetadataUtils.buildN5VMetadata(newPath, (N5SingleScaleMetadata)baseMetadata, downsampleMethod, baseResolution, absoluteDownsamplingFactors);
        }
        if (baseMetadata instanceof N5CosemMetadata) {
            return (M)MetadataUtils.buildCosemMetadata(newPath, (N5CosemMetadata)baseMetadata, absoluteScale, absoluteTranslation);
        }
        if (baseMetadata instanceof NgffSingleScaleAxesMetadata) {
            return (M)MetadataUtils.buildNgffMetadata(newPath, (NgffSingleScaleAxesMetadata)baseMetadata, absoluteScale, absoluteTranslation);
        }
        return baseMetadata;
    }

    public static N5SingleScaleMetadata buildN5VMetadata(String path, N5SingleScaleMetadata baseMetadata, String downsampleMethod, double[] baseResolution, double[] downsamplingFactors) {
        int nd = baseResolution.length > 3 ? 3 : baseResolution.length;
        double[] resolution = new double[nd];
        double[] factors = new double[nd];
        if (downsampleMethod.equals(DOWN_AVERAGE)) {
            System.arraycopy(baseResolution, 0, resolution, 0, nd);
            System.arraycopy(downsamplingFactors, 0, factors, 0, nd);
        } else {
            for (int i = 0; i < nd; ++i) {
                resolution[i] = baseResolution[i] * downsamplingFactors[i];
            }
            Arrays.fill(factors, 1.0);
        }
        AffineTransform3D transform = new AffineTransform3D();
        for (int i = 0; i < nd; ++i) {
            transform.set(resolution[i], i, i);
        }
        return new N5SingleScaleMetadata(path, transform, factors, resolution, baseMetadata.getOffset(), baseMetadata.unit(), baseMetadata.getAttributes(), baseMetadata.minIntensity(), baseMetadata.maxIntensity(), baseMetadata.isLabelMultiset());
    }

    public static N5CosemMetadata buildCosemMetadata(String path, N5CosemMetadata baseMetadata, double[] absoluteResolution, double[] absoluteTranslation) {
        double[] resolution = new double[absoluteResolution.length];
        System.arraycopy(absoluteResolution, 0, resolution, 0, absoluteResolution.length);
        double[] translation = new double[absoluteTranslation.length];
        System.arraycopy(absoluteTranslation, 0, translation, 0, absoluteTranslation.length);
        return new N5CosemMetadata(path, new N5CosemMetadata.CosemTransform(baseMetadata.getCosemTransform().axes, resolution, translation, baseMetadata.getCosemTransform().units), baseMetadata.getAttributes());
    }

    public static NgffSingleScaleAxesMetadata buildNgffMetadata(String path, NgffSingleScaleAxesMetadata baseMetadata, double[] absoluteResolution, double[] absoluteTranslation) {
        double[] resolution = new double[absoluteResolution.length];
        System.arraycopy(absoluteResolution, 0, resolution, 0, absoluteResolution.length);
        double[] translation = new double[absoluteTranslation.length];
        System.arraycopy(absoluteTranslation, 0, translation, 0, absoluteTranslation.length);
        return new NgffSingleScaleAxesMetadata(path, resolution, translation, baseMetadata.getAxes(), baseMetadata.getAttributes());
    }

    public static <M extends N5Metadata> M permuteSpatialMetadata(M metadata, int[] axisPermutation) {
        if (metadata == null) {
            return null;
        }
        if (metadata.getClass().equals(N5SingleScaleMetadata.class)) {
            return (M)MetadataUtils.permuteN5vMetadata((N5SingleScaleMetadata)metadata, axisPermutation);
        }
        if (metadata instanceof N5CosemMetadata) {
            return (M)MetadataUtils.permuteCosemMetadata((N5CosemMetadata)metadata, axisPermutation);
        }
        if (metadata instanceof NgffSingleScaleAxesMetadata) {
            return (M)MetadataUtils.permuteNgffMetadata((NgffSingleScaleAxesMetadata)metadata, axisPermutation);
        }
        return metadata;
    }

    public static NgffSingleScaleAxesMetadata permuteNgffMetadata(NgffSingleScaleAxesMetadata metadata, int[] axisPermutation) {
        Axis[] axes = metadata.getAxes();
        Axis[] axesPermuted = new Axis[axes.length];
        for (int i = 0; i < axes.length; ++i) {
            axesPermuted[i] = axes[i];
        }
        AxisUtils.permute(axesPermuted, axesPermuted, axisPermutation);
        return new NgffSingleScaleAxesMetadata(metadata.getPath(), AxisUtils.permute(metadata.getScale(), axisPermutation), AxisUtils.permute(metadata.getTranslation(), axisPermutation), axesPermuted, metadata.getAttributes());
    }

    public static N5CosemMetadata permuteCosemMetadata(N5CosemMetadata metadata, int[] axisPermutation) {
        double[] oldScales = ArrayUtils.clone((double[])metadata.getCosemTransform().scale);
        ArrayUtils.reverse((double[])oldScales);
        double[] newScales = AxisUtils.permute(oldScales, axisPermutation);
        ArrayUtils.reverse((double[])newScales);
        double[] oldTranslation = ArrayUtils.clone((double[])metadata.getCosemTransform().translate);
        ArrayUtils.reverse((double[])oldTranslation);
        double[] newTranslation = AxisUtils.permute(oldTranslation, axisPermutation);
        ArrayUtils.reverse((double[])newTranslation);
        Object[] newAxes = (String[])ArrayUtils.clone((Object[])metadata.getCosemTransform().axes);
        ArrayUtils.reverse((Object[])newAxes);
        AxisUtils.permute(newAxes, newAxes, axisPermutation);
        ArrayUtils.reverse((Object[])newAxes);
        Object[] newUnits = (String[])ArrayUtils.clone((Object[])metadata.getCosemTransform().units);
        ArrayUtils.reverse((Object[])newUnits);
        AxisUtils.permute(newUnits, newUnits, axisPermutation);
        ArrayUtils.reverse((Object[])newUnits);
        return new N5CosemMetadata(metadata.getPath(), new N5CosemMetadata.CosemTransform((String[])newAxes, newScales, newTranslation, (String[])newUnits), metadata.getAttributes());
    }

    public static N5SingleScaleMetadata permuteN5vMetadata(N5SingleScaleMetadata metadata, int[] axisPermutation) {
        double[] newScales = AxisUtils.permute(metadata.getPixelResolution(), axisPermutation);
        double[] newOffset = AxisUtils.permute(metadata.getOffset(), axisPermutation);
        double[] newFactors = AxisUtils.permute(metadata.getDownsamplingFactors(), axisPermutation);
        AffineTransform3D offsetTform = new AffineTransform3D();
        offsetTform.translate(newOffset);
        AffineTransform3D transform = N5SingleScaleMetadataParser.buildTransform(newFactors, newScales, Optional.of(offsetTform));
        return new N5SingleScaleMetadata(metadata.getPath(), transform, newFactors, newScales, newOffset, metadata.unit(), metadata.getAttributes());
    }
}

