/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata;

import java.util.HashMap;
import java.util.Optional;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.MultiscaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SpatialDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialMultiscaleMetadata;

public class N5CosemMultiScaleMetadata
extends SpatialMultiscaleMetadata<N5CosemMetadata> {
    public N5CosemMultiScaleMetadata(String basePath, N5CosemMetadata[] childMetadata) {
        super(basePath, (N5SpatialDatasetMetadata[])childMetadata);
    }

    public static class CosemMultiScaleParser
    implements N5MetadataParser<N5CosemMultiScaleMetadata> {
        @Override
        public Optional<N5CosemMultiScaleMetadata> parseMetadata(N5Reader n5, N5TreeNode node) {
            HashMap<String, N5TreeNode> scaleLevelNodes = new HashMap<String, N5TreeNode>();
            for (N5TreeNode childNode : node.childrenList()) {
                if (!MultiscaleMetadata.scaleLevelPredicate.test(childNode.getNodeName()) || !childNode.isDataset() || !(childNode.getMetadata() instanceof N5CosemMetadata)) continue;
                scaleLevelNodes.put(childNode.getNodeName(), childNode);
            }
            if (scaleLevelNodes.isEmpty()) {
                return Optional.empty();
            }
            N5DatasetMetadata[] childMetadata = (N5CosemMetadata[])scaleLevelNodes.values().stream().map(N5TreeNode::getMetadata).toArray(N5CosemMetadata[]::new);
            if (!MultiscaleMetadata.sortScaleMetadata((N5DatasetMetadata[])childMetadata)) {
                return Optional.empty();
            }
            return Optional.of(new N5CosemMultiScaleMetadata(node.getPath(), (N5CosemMetadata[])childMetadata));
        }
    }
}

