/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.transforms;

import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.ScaleAndTranslation;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.AbstractLinearSpatialTransform;

public class ScaleOffsetSpatialTransform
extends AbstractLinearSpatialTransform<double[][]> {
    public double[] scale;
    public double[] offset;
    public transient AffineGet transform;

    public ScaleOffsetSpatialTransform(double[] scale, double[] offset) {
        super("scale_offset");
        this.scale = scale;
        this.offset = offset;
        this.buildTransform(scale, offset);
    }

    public ScaleOffsetSpatialTransform(N5Reader n5, String path) {
        super("scale_offset", path);
        double[][] p = this.getParameters(n5);
        this.buildTransform(p);
    }

    public ScaleOffsetSpatialTransform(String path) {
        super("scale_offset", path);
        this.scale = null;
        this.offset = null;
    }

    public AffineGet buildTransform(double[] scale, double[] offset) {
        this.transform = new ScaleAndTranslation(scale, offset);
        return this.transform;
    }

    @Override
    public AffineGet buildTransform(double[][] parameters) {
        this.scale = parameters[0];
        this.offset = parameters[1];
        this.transform = new ScaleAndTranslation(this.scale, this.offset);
        return this.transform;
    }

    @Override
    public AffineGet getTransform() {
        if (this.scale != null && this.offset != null && this.transform == null) {
            this.transform = new ScaleAndTranslation(this.scale, this.offset);
        }
        return this.transform;
    }

    @Override
    public double[][] getParameters(N5Reader n5) {
        return ScaleOffsetSpatialTransform.getDoubleArray2(n5, this.getParameterPath());
    }
}

