/*
 * Decompiled with CFR 0.152.
 */
package selection;

import fiji.tool.AbstractTrackingTool;
import fiji.tool.ToolToggleListener;
import fiji.tool.ToolWithOptions;
import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import mpicbg.models.Point;
import net.imglib2.util.Util;
import selection.DoneButtonListener;
import selection.ExtendedPointMatch;
import selection.ListListener;
import selection.LoadListener;
import selection.RemoveItemListener;
import selection.SaveListener;

public class Select_Points
extends AbstractTrackingTool
implements ToolToggleListener,
ToolWithOptions {
    Frame frame;
    float standardWidth;
    float hightlightWidth;
    float selectWidth;
    Color standard;
    Color highlight;
    Color select;
    final ImagePlus imp1;
    final ImagePlus imp2;
    int activeIndex;
    final List list1;
    final List list2;
    Point p1;
    Point p2;
    double radius1;
    double radius2;
    final ArrayList<ExtendedPointMatch> matches;

    public Select_Points(ImagePlus imp1, ImagePlus imp2) {
        this.clearToolsIfNecessary = true;
        this.standardWidth = 1.0f;
        this.hightlightWidth = 2.0f;
        this.selectWidth = 1.0f;
        this.standard = Color.GREEN;
        this.highlight = Color.MAGENTA;
        this.select = Color.RED;
        this.activeIndex = -1;
        this.list1 = new List(20);
        this.list2 = new List(20);
        this.p1 = null;
        this.p2 = null;
        this.radius1 = 0.0;
        this.radius2 = 0.0;
        this.matches = new ArrayList();
        this.imp1 = imp1;
        this.imp2 = imp2;
        this.initDisplay();
    }

    public void initDisplay() {
        this.frame = new Frame("Selected Landmarks");
        this.frame.setSize(1000, 600);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        String title1 = this.imp1.getTitle().substring(0, Math.min(30, this.imp1.getTitle().length()));
        String title2 = this.imp2.getTitle().substring(0, Math.min(30, this.imp2.getTitle().length()));
        Button button = new Button("Done");
        Button remove = new Button("Remove");
        Button save = new Button("Save");
        Button load = new Button("Load");
        Label text1 = new Label(title1, 1);
        Label text2 = new Label(title2, 1);
        this.frame.setLayout(layout);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        this.frame.add((Component)text1, c);
        ++c.gridx;
        this.frame.add((Component)text2, c);
        --c.gridx;
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        this.frame.add((Component)this.list1, c);
        ++c.gridx;
        this.frame.add((Component)this.list2, c);
        --c.gridx;
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        this.frame.add((Component)remove, c);
        ++c.gridy;
        this.frame.add((Component)load, c);
        ++c.gridx;
        this.frame.add((Component)save, c);
        --c.gridx;
        ++c.gridy;
        c.insets = new Insets(20, 0, 0, 0);
        this.frame.add((Component)button, c);
        button.addActionListener(new DoneButtonListener(this, this.frame));
        remove.addActionListener(new RemoveItemListener(this, this.list1, this.list2, this.matches));
        save.addActionListener(new SaveListener(this.frame, this.matches));
        load.addActionListener(new LoadListener(this.frame, this.list1, this.list2, this.matches));
        this.list1.addItemListener(new ListListener(this, this.list1, this.list2));
        this.list2.addItemListener(new ListListener(this, this.list2, this.list1));
        this.frame.setVisible(true);
    }

    protected void drawCurrentSelection1() {
        Overlay o1 = new Overlay();
        int currentSlice1 = this.imp1.getCurrentSlice();
        int i = 0;
        for (ExtendedPointMatch pm : this.matches) {
            Point p1 = pm.getP1();
            double radius1 = pm.radius1L;
            double distance1 = Math.abs(p1.getL()[2] - (double)currentSlice1) * (this.imp1.getCalibration().getZ(1.0) / this.imp1.getCalibration().getX(1.0));
            if (distance1 <= radius1) {
                double newRadius = Math.sqrt(radius1 * radius1 - distance1 * distance1);
                OvalRoi or = new OvalRoi((double)Math.round(p1.getL()[0] - newRadius), (double)Math.round(p1.getL()[1] - newRadius), (double)Math.round(newRadius * 2.0), (double)Math.round(newRadius * 2.0));
                if (i == this.activeIndex) {
                    or.setStrokeColor(this.highlight);
                    or.setStrokeWidth(this.hightlightWidth);
                } else {
                    or.setStrokeColor(this.standard);
                    or.setStrokeWidth(this.standardWidth);
                }
                o1.add((Roi)or);
            }
            ++i;
        }
        this.imp1.setOverlay(o1);
        this.imp1.updateAndDraw();
    }

    protected void drawCurrentSelection2() {
        Overlay o2 = new Overlay();
        int currentSlice2 = this.imp2.getCurrentSlice();
        int i = 0;
        for (ExtendedPointMatch pm : this.matches) {
            Point p2 = pm.getP2();
            double radius2 = pm.radius2L;
            double distance2 = Math.abs(p2.getL()[2] - (double)currentSlice2) * (this.imp2.getCalibration().getZ(1.0) / this.imp2.getCalibration().getX(1.0));
            if (distance2 <= radius2) {
                double newRadius = (float)Math.sqrt(radius2 * radius2 - distance2 * distance2);
                OvalRoi or = new OvalRoi((double)Math.round(p2.getL()[0] - newRadius), (double)Math.round(p2.getL()[1] - newRadius), (double)Math.round(newRadius * 2.0), (double)Math.round(newRadius * 2.0));
                if (i == this.activeIndex) {
                    or.setStrokeColor(this.highlight);
                    or.setStrokeWidth(this.hightlightWidth);
                } else {
                    or.setStrokeColor(this.standard);
                    or.setStrokeWidth(this.standardWidth);
                }
                o2.add((Roi)or);
            }
            ++i;
        }
        this.imp2.setOverlay(o2);
        this.imp2.updateAndDraw();
    }

    public void drawCurrentSelection() {
        this.drawCurrentSelection1();
        this.drawCurrentSelection2();
    }

    protected void addCorrespondence(ExtendedPointMatch pm) {
        this.matches.add(pm);
        this.list1.add(Select_Points.getStringForPoint(pm.getP1(), pm.radius1W));
        this.list2.add(Select_Points.getStringForPoint(pm.getP2(), pm.radius2W));
        this.drawCurrentSelection();
    }

    public Roi optimizeRoi(Roi roi, ImageProcessor ip) {
        return roi;
    }

    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        ImagePlus imp = this.getImagePlus(e);
        if (imp != this.imp1 && imp != this.imp2) {
            e.consume();
            return;
        }
        int x = this.getOffscreenX(e);
        int y = this.getOffscreenY(e);
        int z = imp.getCurrentSlice();
        double xR = imp.getCalibration().getX((double)x);
        double yR = imp.getCalibration().getY((double)y);
        double zR = imp.getCalibration().getZ((double)(z - 1));
        if (imp == this.imp1) {
            if (this.p1 == null) {
                this.p1 = new Point(new double[]{x, y, z}, new double[]{xR, yR, zR});
                this.addCross(imp, x, y);
            } else if (this.radius1 == 0.0) {
                this.radius1 = Point.distance((Point)this.p1, (Point)new Point(new double[]{xR, yR, zR}));
                if (this.radius1 == 0.0) {
                    this.radius1 = 0.45f * (float)imp.getCalibration().getX(1.0);
                }
                this.removeColoredOverlays(imp, 2, this.select);
                this.addCircle(imp, (int)Math.round(this.p1.getL()[0]), (int)Math.round(this.p1.getL()[1]), this.radius1 / imp.getCalibration().getX(1.0));
            }
        } else if (this.p2 == null) {
            this.p2 = new Point(new double[]{x, y, z}, new double[]{xR, yR, zR});
            this.addCross(imp, x, y);
        } else if (this.radius2 == 0.0) {
            this.radius2 = Point.distance((Point)this.p2, (Point)new Point(new double[]{xR, yR, zR}));
            if (this.radius2 == 0.0) {
                this.radius2 = 0.45 * imp.getCalibration().getX(1.0);
            }
            this.removeColoredOverlays(imp, 2, this.select);
            this.addCircle(imp, (int)Math.round(this.p2.getL()[0]), (int)Math.round(this.p2.getL()[1]), this.radius2 / imp.getCalibration().getX(1.0));
        }
        if (this.p1 != null && this.p2 != null && this.radius1 > 0.0 && this.radius2 > 0.0) {
            this.removeColoredOverlays(this.imp1, 1, this.select);
            this.removeColoredOverlays(this.imp2, 1, this.select);
            this.addCorrespondence(new ExtendedPointMatch(this.p1.clone(), this.p2.clone(), (float)this.radius1 / (float)imp.getCalibration().getX(1.0), this.radius1, (float)this.radius2 / (float)imp.getCalibration().getX(1.0), this.radius2));
            this.p2 = null;
            this.p1 = null;
            this.radius2 = 0.0;
            this.radius1 = 0.0;
        }
        e.consume();
    }

    protected void removeColoredOverlays(ImagePlus imp, int num, Color color) {
        Overlay o = imp.getOverlay();
        if (o == null) {
            return;
        }
        for (int i = o.size() - 1; i >= 0 && num > 0; --i) {
            if (!o.get(i).getStrokeColor().equals(color)) continue;
            o.remove(i);
            --num;
        }
        imp.updateAndDraw();
    }

    protected void addCircle(ImagePlus imp, int centerX, int centerY, double radius) {
        Overlay o = imp.getOverlay();
        if (o == null) {
            o = new Overlay();
            imp.setOverlay(o);
        }
        OvalRoi or = new OvalRoi((double)Math.round((double)centerX - radius), (double)Math.round((double)centerY - radius), (double)Math.round(radius * 2.0), (double)Math.round(radius * 2.0));
        or.setStrokeColor(this.select);
        or.setStrokeWidth(this.selectWidth);
        o.add((Roi)or);
        imp.updateAndDraw();
    }

    protected void addCross(ImagePlus imp, int x, int y) {
        Overlay o = imp.getOverlay();
        if (o == null) {
            o = new Overlay();
            imp.setOverlay(o);
        }
        Line line1 = new Line(x - 3, y, x + 3, y);
        Line line2 = new Line(x, y - 3, x, y + 3);
        line1.setStrokeColor(this.select);
        line2.setStrokeColor(this.select);
        line1.setStrokeWidth(this.selectWidth);
        line2.setStrokeWidth(this.selectWidth);
        o.add((Roi)line1);
        o.add((Roi)line2);
        imp.updateAndDraw();
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        e.consume();
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        e.consume();
    }

    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        e.consume();
    }

    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        e.consume();
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        e.consume();
    }

    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        e.consume();
    }

    public void sliceChanged(ImagePlus image) {
        super.sliceChanged(image);
        if (image == this.imp1) {
            this.drawCurrentSelection1();
            this.p1 = null;
            this.radius1 = 0.0;
        } else {
            this.drawCurrentSelection2();
            this.p2 = null;
            this.radius2 = 0.0;
        }
    }

    public void showOptionDialog() {
    }

    public void toolToggled(boolean enabled) {
        this.p2 = null;
        this.p1 = null;
        this.radius2 = 0.0;
        this.radius1 = 0.0;
        if (enabled) {
            this.frame.setVisible(true);
            this.drawCurrentSelection();
        } else {
            this.frame.setVisible(false);
            this.imp1.setOverlay(new Overlay());
            this.imp2.setOverlay(new Overlay());
        }
    }

    public static String getStringForPoint(Point p, double r) {
        return Util.printCoordinates((double[])p.getW()) + " [" + Math.round(p.getL()[0]) + ", " + Math.round(p.getL()[1]) + ", " + Math.round(p.getL()[2]) + "], r = " + r;
    }
}

