/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.tracking;

import fiji.plugin.trackmate.tracking.jaqaman.JaqamanLinker;
import fiji.plugin.trackmate.tracking.jaqaman.costfunction.CostFunction;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.CostMatrixCreator;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.JaqamanLinkingCostMatrixCreator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.filamentdetector.model.Filament;
import sc.fiji.filamentdetector.model.TrackedFilaments;
import sc.fiji.filamentdetector.tracking.AbstractFilamentsTracker;
import sc.fiji.filamentdetector.tracking.FilamentsTracker;
import sc.fiji.filamentdetector.tracking.lap.BoundingBoxOverlapCostFunction;
import sc.fiji.filamentdetector.tracking.lap.JaqamanFilamentSegmentCostMatrixCreator;

@Plugin(type=FilamentsTracker.class, priority=100.0)
public class BBoxLAPFilamentsTracker
extends AbstractFilamentsTracker {
    private static String NAME = "BoundingBox LAP Tracker";
    @Parameter
    private LogService log;
    @Parameter
    private Context context;
    private double costThreshold = 1.1;
    private double maxFrameGap = 15.0;
    private boolean interpolateFilaments = true;

    public BBoxLAPFilamentsTracker() {
        this.setName(NAME);
    }

    @Override
    public void track() {
        SimpleWeightedGraph<Filament, DefaultWeightedEdge> graph = this.trackFrameToFrame();
        graph = this.trackGapMergeSplit(graph);
        this.setTrackedFilaments(new TrackedFilaments(this.context));
        this.getTrackedFilaments().buildTracks(graph);
        if (this.isInterpolateFilaments()) {
            this.interpolateFilaments();
        }
    }

    private SimpleWeightedGraph<Filament, DefaultWeightedEdge> trackFrameToFrame() {
        Map<Integer, List<Filament>> sortedFilaments = this.getFilaments().stream().collect(Collectors.groupingBy(Filament::getFrame));
        List frames = sortedFilaments.keySet().stream().sorted().collect(Collectors.toList());
        BoundingBoxOverlapCostFunction costFunction = new BoundingBoxOverlapCostFunction();
        double alternativeCostFactor = 1.1;
        double percentile = 1.0;
        SimpleWeightedGraph graph = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        for (int i = 0; i < frames.size() - 1; ++i) {
            List<Filament> targets;
            int frameSource = (Integer)frames.get(i);
            int frameTarget = (Integer)frames.get(i + 1);
            List<Filament> sources = sortedFilaments.get(frameSource);
            JaqamanLinkingCostMatrixCreator creator = new JaqamanLinkingCostMatrixCreator(sources, targets = sortedFilaments.get(frameTarget), (CostFunction)costFunction, this.getCostThreshold(), alternativeCostFactor, percentile);
            JaqamanLinker linker = new JaqamanLinker((CostMatrixCreator)creator);
            if (!linker.checkInput() || !linker.process()) {
                this.log.error((Object)("At frame " + frameSource + " to " + frameTarget + ": " + linker.getErrorMessage()));
            }
            Map costs = linker.getAssignmentCosts();
            Map assignment = linker.getResult();
            for (Filament source : assignment.keySet()) {
                double cost = (Double)costs.get(source);
                Filament target = (Filament)assignment.get(source);
                graph.addVertex((Object)source);
                graph.addVertex((Object)target);
                DefaultWeightedEdge edge = (DefaultWeightedEdge)graph.addEdge((Object)source, (Object)target);
                graph.setEdgeWeight((Object)edge, cost);
            }
        }
        return graph;
    }

    private SimpleWeightedGraph<Filament, DefaultWeightedEdge> trackGapMergeSplit(SimpleWeightedGraph<Filament, DefaultWeightedEdge> graph) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("ALLOW_GAP_CLOSING", true);
        settings.put("GAP_CLOSING_FEATURE_PENALTIES", new HashMap());
        settings.put("GAP_CLOSING_MAX_DISTANCE", 1000.0);
        settings.put("MAX_FRAME_GAP", (int)this.getMaxFrameGap());
        settings.put("ALLOW_TRACK_SPLITTING", false);
        settings.put("SPLITTING_FEATURE_PENALTIES", new HashMap());
        settings.put("SPLITTING_MAX_DISTANCE", 15.0);
        settings.put("ALLOW_TRACK_MERGING", false);
        settings.put("MERGING_FEATURE_PENALTIES", new HashMap());
        settings.put("MERGING_MAX_DISTANCE", 15.0);
        settings.put("ALTERNATIVE_LINKING_COST_FACTOR", 2000.0);
        settings.put("CUTOFF_PERCENTILE", 1.0);
        JaqamanFilamentSegmentCostMatrixCreator costMatrixCreator = new JaqamanFilamentSegmentCostMatrixCreator((Graph<Filament, DefaultWeightedEdge>)graph, (Map<String, Object>)settings);
        JaqamanLinker linker = new JaqamanLinker((CostMatrixCreator)costMatrixCreator);
        if (!linker.checkInput() || !linker.process()) {
            this.log.error((Object)linker.getErrorMessage());
        }
        Map assignment = linker.getResult();
        Map costs = linker.getAssignmentCosts();
        for (Filament source : assignment.keySet()) {
            Filament target = (Filament)assignment.get(source);
            DefaultWeightedEdge edge = (DefaultWeightedEdge)graph.addEdge((Object)source, (Object)target);
            double cost = (Double)costs.get(source);
            graph.setEdgeWeight((Object)edge, cost);
        }
        return graph;
    }

    public void interpolateFilaments() {
    }

    public double getCostThreshold() {
        return this.costThreshold;
    }

    public void setCostThreshold(double costThreshold) {
        this.costThreshold = costThreshold;
    }

    public double getMaxFrameGap() {
        return this.maxFrameGap;
    }

    public void setMaxFrameGap(double maxFrameGap) {
        this.maxFrameGap = maxFrameGap;
    }

    public boolean isInterpolateFilaments() {
        return this.interpolateFilaments;
    }

    public void setInterpolateFilaments(boolean interpolateFilaments) {
        this.interpolateFilaments = interpolateFilaments;
    }

    @Override
    public String toString() {
        String out = "";
        out = out + "Tracker Name : " + this.getName() + "\n";
        out = out + "Cost Threshold = " + this.costThreshold + "\n";
        out = out + "Maximum Frame Gap = " + this.maxFrameGap + "\n";
        out = out + "Interpolate filaments = " + this.interpolateFilaments + "\n";
        return out;
    }
}

