/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.source.PlateauSphericalMaskRealRandomAccessible;
import bigwarp.transforms.BigWarpTransform;
import bigwarp.transforms.MaskedSimRotTransformSolver;
import bigwarp.transforms.TpsTransformSolver;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineInterpolator;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.MaskedSimilarityTransform;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.LinAlgHelpers;
import org.janelia.utility.geom.GeomUtils;

public class RotationTransformInterpolator2D
implements AffineInterpolator {
    private final double thtDiff;
    private final AffineTransform2D tform = new AffineTransform2D();
    private final double[] c;
    private final double[] pDiff;

    public RotationTransformInterpolator2D(AffineTransform2D transform, double[] c) {
        AffineTransform2D transformEnd = new AffineTransform2D();
        transformEnd.set(transform);
        transformEnd.translate(new double[]{-c[0], -c[1]});
        this.thtDiff = GeomUtils.scalesAngle(transformEnd)[2];
        this.c = new double[2];
        System.arraycopy(c, 0, this.c, 0, 2);
        this.pDiff = new double[2];
        double[] tmp = new double[2];
        AffineTransform2D t1 = this.get(1.0);
        t1.apply(c, tmp);
        transform.apply(c, this.pDiff);
        LinAlgHelpers.subtract((double[])this.pDiff, (double[])tmp, (double[])this.pDiff);
    }

    public AffineTransform2D get(double t) {
        this.tform.set(new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0});
        double thtCurrent = t * this.thtDiff;
        this.tform.rotate(thtCurrent);
        double[] pCurrent = new double[2];
        double[] pTgt = new double[2];
        this.tform.apply(this.c, pCurrent);
        LinAlgHelpers.scale((double[])this.pDiff, (double)t, (double[])pTgt);
        LinAlgHelpers.add((double[])pTgt, (double[])this.c, (double[])pTgt);
        LinAlgHelpers.subtract((double[])pTgt, (double[])pCurrent, (double[])pTgt);
        this.tform.translate(pTgt);
        return this.tform;
    }

    public static void main(String[] args) throws IOException {
        RotationTransformInterpolator2D.testReal2d();
    }

    public static void testReal2d() throws IOException {
        LandmarkTableModel ltm = LandmarkTableModel.loadFromCsv(new File("/home/john/tmp/boats-bigrotation.csv"), false);
        RealPoint c = new RealPoint(new double[]{0.0, 0.0});
        PlateauSphericalMaskRealRandomAccessible lambda = new PlateauSphericalMaskRealRandomAccessible(c);
        lambda.setFalloffShape(PlateauSphericalMaskRealRandomAccessible.FalloffShape.COSINE);
        lambda.setSquaredRadius(28111.13100490283);
        lambda.setSquaredSigma(24251.31739665425);
        lambda.setCenter(new double[]{380.26234219457774, 284.5915704375881});
        RealPoint p = new RealPoint(new double[]{0.0, 0.0});
        RealPoint q = new RealPoint(new double[]{0.0, 0.0});
        TpsTransformSolver baseSolver = new TpsTransformSolver();
        MaskedSimRotTransformSolver<DoubleType> solver = new MaskedSimRotTransformSolver<DoubleType>(2, baseSolver, lambda, c.positionAsDoubleArray(), MaskedSimilarityTransform.Interpolators.ROTATION);
        WrappedIterativeInvertibleRealTransform<?> xfm = solver.solve(ltm);
        int idx = 0;
        int nd = ltm.getNumdims();
        RealPoint x = new RealPoint(nd);
        RealPoint y = new RealPoint(nd);
        x.setPosition(Arrays.stream(ltm.getFixedPoint(idx)).mapToDouble(Double::doubleValue).toArray());
        xfm.apply((RealLocalizable)x, (RealPositionable)y);
        System.out.println("est pt : " + y);
        double[] ytrue = Arrays.stream(ltm.getMovingPoint(idx)).mapToDouble(Double::doubleValue).toArray();
        System.out.println("tru pt :" + new RealPoint(ytrue));
    }

    public static <T extends RealType<T>> void transformLandmarkPoint(LandmarkTableModel ltm, int idx, BigWarpTransform bwTform, RealRandomAccessible<T> lambda) {
        int nd = ltm.getNumdims();
        RealPoint x = new RealPoint(nd);
        RealPoint y = new RealPoint(nd);
        x.setPosition(Arrays.stream(ltm.getFixedPoint(idx)).mapToDouble(Double::doubleValue).toArray());
        if (lambda != null) {
            System.out.println("l(x): " + lambda.getAt((RealLocalizable)x));
        }
        InvertibleRealTransform xfm = bwTform.getTransformation(false);
        xfm.apply((RealLocalizable)x, (RealPositionable)y);
        System.out.println(y);
        double[] ytrue = Arrays.stream(ltm.getMovingPoint(idx)).mapToDouble(Double::doubleValue).toArray();
        System.out.println("true pt :" + Arrays.toString(ytrue));
    }

    public static void test90deg() {
        LandmarkTableModel ltm = new LandmarkTableModel(2);
        ltm.add(new double[]{0.0, 0.0}, new double[]{0.0, 0.0});
        ltm.add(new double[]{-1.0, 0.0}, new double[]{0.0, 1.0});
        ltm.add(new double[]{0.0, 1.0}, new double[]{1.0, 0.0});
        ltm.add(new double[]{1.0, 0.0}, new double[]{0.0, -1.0});
        ltm.add(new double[]{0.0, -1.0}, new double[]{-1.0, 0.0});
        RealPoint c = new RealPoint(new double[]{0.0, 0.0});
        PlateauSphericalMaskRealRandomAccessible lambda = new PlateauSphericalMaskRealRandomAccessible(c);
        lambda.setFalloffShape(PlateauSphericalMaskRealRandomAccessible.FalloffShape.COSINE);
        lambda.setRadius(1.0);
        lambda.setSigma(1.0);
        RealPoint p = new RealPoint(new double[]{0.0, 0.0});
        RealPoint q = new RealPoint(new double[]{0.0, 0.0});
        TpsTransformSolver baseSolver = new TpsTransformSolver();
        MaskedSimRotTransformSolver<DoubleType> solver = new MaskedSimRotTransformSolver<DoubleType>(2, baseSolver, lambda, c.positionAsDoubleArray(), MaskedSimilarityTransform.Interpolators.ROTATION);
        WrappedIterativeInvertibleRealTransform<?> xfm = solver.solve(ltm);
        xfm.apply((RealLocalizable)p, (RealPositionable)q);
        System.out.println(p + " > " + q);
        System.out.println("");
        p.setPosition(2.0, 0);
        xfm.apply((RealLocalizable)p, (RealPositionable)q);
        System.out.println(p + " > " + q);
        System.out.println("");
        p.setPosition(1.0, 0);
        xfm.apply((RealLocalizable)p, (RealPositionable)q);
        System.out.println(p + " > " + q);
    }
}

