/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.algorithms;

import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.TwinCursor;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import sc.fiji.coloc.algorithms.Algorithm;
import sc.fiji.coloc.algorithms.AutoThresholdRegression;
import sc.fiji.coloc.algorithms.MissingPreconditionException;
import sc.fiji.coloc.gadgets.DataContainer;
import sc.fiji.coloc.gadgets.ThresholdMode;
import sc.fiji.coloc.results.ResultHandler;

public class MandersColocalization<T extends RealType<T>>
extends Algorithm<T> {
    private double mandersM1;
    private double mandersM2;
    private double mandersThresholdedM1;
    private double mandersThresholdedM2;
    private long numberOfPixelsAboveBothThresholds;
    private double fractionOfPixelsAboveBothThresholds;
    private double fractionOfColocCh1Pixels;
    private double fractionOfColocCh2Pixels;
    private double fractionOfColocCh1Intensity;
    private double fractionOfColocCh2Intensity;
    private double fractionOfColocCh1IntensityAboveCh1Thresh;
    private double fractionOfColocCh2IntensityAboveCh2Thresh;

    public MandersColocalization() {
        super("Manders correlation");
    }

    @Override
    public void execute(DataContainer<T> container) throws MissingPreconditionException {
        RandomAccessibleInterval<T> img1 = container.getSourceImage1();
        RandomAccessibleInterval<T> img2 = container.getSourceImage2();
        RandomAccessibleInterval<BitType> mask = container.getMask();
        TwinCursor cursor = new TwinCursor(img1.randomAccess(), img2.randomAccess(), (Cursor<BitType>)Views.iterable(mask).localizingCursor());
        MandersResults results = this.calculateMandersCorrelation(cursor, (RealType)((RealType)img1.randomAccess().get()).createVariable());
        this.mandersM1 = results.m1;
        this.mandersM2 = results.m2;
        AutoThresholdRegression<T> autoThreshold = container.getAutoThreshold();
        if (autoThreshold != null) {
            cursor.reset();
            results = this.calculateMandersCorrelation(cursor, autoThreshold.getCh1MaxThreshold(), autoThreshold.getCh2MaxThreshold(), ThresholdMode.Above);
            this.mandersThresholdedM1 = results.m1;
            this.mandersThresholdedM2 = results.m2;
        }
    }

    public MandersResults calculateMandersCorrelation(TwinCursor<T> cursor, T type) {
        return this.calculateMandersCorrelation(cursor, type, type, ThresholdMode.None);
    }

    public MandersResults calculateMandersCorrelation(TwinCursor<T> cursor, T thresholdCh1, T thresholdCh2, ThresholdMode tMode) {
        SplitCoeffAccumulator mandersAccum;
        final RealType zero = (RealType)thresholdCh1.createVariable();
        zero.setZero();
        if (tMode == ThresholdMode.None) {
            mandersAccum = new SplitCoeffAccumulator(cursor){

                @Override
                final boolean acceptMandersCh1(T type1, T type2) {
                    return type2.compareTo((Object)zero) > 0;
                }

                @Override
                final boolean acceptMandersCh2(T type1, T type2) {
                    return type1.compareTo((Object)zero) > 0;
                }
            };
        } else if (tMode == ThresholdMode.Below) {
            mandersAccum = new SplitCoeffAccumulator(cursor, (RealType)thresholdCh2, (RealType)thresholdCh1){
                final /* synthetic */ RealType val$thresholdCh2;
                final /* synthetic */ RealType val$thresholdCh1;
                {
                    this.val$thresholdCh2 = realType2;
                    this.val$thresholdCh1 = realType3;
                    super(cursor);
                }

                @Override
                final boolean acceptMandersCh1(T type1, T type2) {
                    return type2.compareTo((Object)zero) > 0 && type2.compareTo((Object)this.val$thresholdCh2) <= 0;
                }

                @Override
                final boolean acceptMandersCh2(T type1, T type2) {
                    return type1.compareTo((Object)zero) > 0 && type1.compareTo((Object)this.val$thresholdCh1) <= 0;
                }
            };
        } else if (tMode == ThresholdMode.Above) {
            mandersAccum = new SplitCoeffAccumulator(cursor, (RealType)thresholdCh2, (RealType)thresholdCh1){
                final /* synthetic */ RealType val$thresholdCh2;
                final /* synthetic */ RealType val$thresholdCh1;
                {
                    this.val$thresholdCh2 = realType2;
                    this.val$thresholdCh1 = realType3;
                    super(cursor);
                }

                @Override
                final boolean acceptMandersCh1(T type1, T type2) {
                    return type2.compareTo((Object)zero) > 0 && type2.compareTo((Object)this.val$thresholdCh2) >= 0;
                }

                @Override
                final boolean acceptMandersCh2(T type1, T type2) {
                    return type1.compareTo((Object)zero) > 0 && type1.compareTo((Object)this.val$thresholdCh1) >= 0;
                }
            };
        } else {
            throw new UnsupportedOperationException();
        }
        MandersResults results = new MandersResults();
        results.m1 = mandersAccum.mandersSumCh1 / mandersAccum.sumCh1;
        results.m2 = mandersAccum.mandersSumCh2 / mandersAccum.sumCh2;
        return results;
    }

    @Override
    public void processResults(ResultHandler<T> handler) {
        super.processResults(handler);
        handler.handleValue("Manders' M1 (Above zero intensity of Ch2)", this.mandersM1);
        handler.handleValue("Manders' M2 (Above zero intensity of Ch1)", this.mandersM2);
        handler.handleValue("Manders' tM1 (Above autothreshold of Ch2)", this.mandersThresholdedM1);
        handler.handleValue("Manders' tM2 (Above autothreshold of Ch1)", this.mandersThresholdedM2);
    }

    protected abstract class SplitCoeffAccumulator {
        double sumCh1;
        double sumCh2;
        double mandersSumCh1;
        double mandersSumCh2;

        public SplitCoeffAccumulator(TwinCursor<T> cursor) {
            while (cursor.hasNext()) {
                cursor.fwd();
                RealType type1 = (RealType)cursor.getFirst();
                RealType type2 = (RealType)cursor.getSecond();
                double ch1 = type1.getRealDouble();
                double ch2 = type2.getRealDouble();
                if (this.acceptMandersCh1(type1, type2)) {
                    this.mandersSumCh1 += ch1;
                }
                if (this.acceptMandersCh2(type1, type2)) {
                    this.mandersSumCh2 += ch2;
                }
                this.sumCh1 += ch1;
                this.sumCh2 += ch2;
            }
        }

        abstract boolean acceptMandersCh1(T var1, T var2);

        abstract boolean acceptMandersCh2(T var1, T var2);
    }

    public static class MandersResults {
        public double m1;
        public double m2;
    }
}

