/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display.graphics;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import mpicbg.util.Util;

public class MultiplyARGBComposite
implements Composite {
    private static MultiplyARGBComposite instance = new MultiplyARGBComposite();
    private final float alpha;

    public static MultiplyARGBComposite getInstance(float alpha) {
        if (alpha == 1.0f) {
            return instance;
        }
        return new MultiplyARGBComposite(alpha);
    }

    private MultiplyARGBComposite() {
        this.alpha = 1.0f;
    }

    private MultiplyARGBComposite(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        final Composer c = srcColorModel.getNumColorComponents() > 1 ? (srcColorModel.hasAlpha() ? new ARGB2ARGB() : new RGB2ARGB()) : new Gray2ARGB();
        return new CompositeContext(){
            private Composer composer;
            {
                this.composer = c;
            }

            @Override
            public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
                int[] srcPixel = new int[4];
                int[] dstInPixel = new int[4];
                for (int x = 0; x < dstOut.getWidth(); ++x) {
                    for (int y = 0; y < dstOut.getHeight(); ++y) {
                        src.getPixel(x, y, srcPixel);
                        dstIn.getPixel(x, y, dstInPixel);
                        this.composer.compose(srcPixel, dstInPixel, MultiplyARGBComposite.this.alpha);
                        dstOut.setPixel(x, y, dstInPixel);
                    }
                }
            }

            @Override
            public void dispose() {
            }
        };
    }

    private static final class Gray2ARGB
    implements Composer {
        private Gray2ARGB() {
        }

        @Override
        public final void compose(int[] src, int[] dst, float alpha) {
            float dstAlpha = 1.0f - alpha;
            dst[0] = Math.max(0, Math.min(255, Util.round((float)(alpha * (float)src[0] * (float)dst[0] / 255.0f + (float)dst[0] * dstAlpha))));
            dst[1] = Math.max(0, Math.min(255, Util.round((float)(alpha * (float)src[0] * (float)dst[1] / 255.0f + (float)dst[1] * dstAlpha))));
            dst[2] = Math.max(0, Math.min(255, Util.round((float)(alpha * (float)src[0] * (float)dst[2] / 255.0f + (float)dst[2] * dstAlpha))));
            dst[3] = 255;
        }
    }

    private static final class RGB2ARGB
    implements Composer {
        private RGB2ARGB() {
        }

        @Override
        public final void compose(int[] src, int[] dst, float alpha) {
            float dstAlpha = 1.0f - alpha;
            dst[0] = Math.max(0, Math.min(255, Util.round((float)(alpha * (float)src[0] * (float)dst[0] / 255.0f + (float)dst[0] * dstAlpha))));
            dst[1] = Math.max(0, Math.min(255, Util.round((float)(alpha * (float)src[1] * (float)dst[1] / 255.0f + (float)dst[1] * dstAlpha))));
            dst[2] = Math.max(0, Math.min(255, Util.round((float)(alpha * (float)src[2] * (float)dst[2] / 255.0f + (float)dst[2] * dstAlpha))));
            dst[3] = 255;
        }
    }

    private static final class ARGB2ARGB
    implements Composer {
        private ARGB2ARGB() {
        }

        @Override
        public final void compose(int[] src, int[] dst, float alpha) {
            float srcAlpha = (float)src[3] / 255.0f * alpha;
            float dstAlpha = 1.0f - srcAlpha;
            dst[0] = Math.max(0, Math.min(255, Util.round((float)(srcAlpha * (float)src[0] * (float)dst[0] / 255.0f + (float)dst[0] * dstAlpha))));
            dst[1] = Math.max(0, Math.min(255, Util.round((float)(srcAlpha * (float)src[1] * (float)dst[1] / 255.0f + (float)dst[1] * dstAlpha))));
            dst[2] = Math.max(0, Math.min(255, Util.round((float)(srcAlpha * (float)src[2] * (float)dst[2] / 255.0f + (float)dst[2] * dstAlpha))));
            dst[3] = 255;
        }
    }

    private static interface Composer {
        public void compose(int[] var1, int[] var2, float var3);
    }
}

