/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging.filters;

import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ini.trakem2.imaging.filters.IFilter;
import java.util.Map;

public class Normalize
implements IFilter {
    protected double targetMean = 0.0;
    protected double targetStdDev = 0.0;

    public Normalize() {
    }

    public Normalize(double targetMean, double targetStdDev) {
        this.targetMean = targetMean;
        this.targetStdDev = targetStdDev;
    }

    public Normalize(Map<String, String> params) {
        try {
            this.targetMean = Double.parseDouble(params.get("mean"));
            this.targetStdDev = Integer.parseInt(params.get("stddev"));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Cannot create RankFilter!", nfe);
        }
    }

    @Override
    public ImageProcessor process(ImageProcessor ip) {
        if (ip instanceof ColorProcessor) {
            FloatProcessor r = this.normalize(ip.toFloat(0, null));
            FloatProcessor g = this.normalize(ip.toFloat(1, null));
            FloatProcessor b = this.normalize(ip.toFloat(2, null));
            int[] p = new int[ip.getWidth() * ip.getHeight()];
            ColorProcessor cp = new ColorProcessor(ip.getWidth(), ip.getHeight(), p);
            float[] rp = (float[])r.getPixels();
            float[] gp = (float[])g.getPixels();
            float[] bp = (float[])b.getPixels();
            for (int i = 0; i < p.length; ++i) {
                p[i] = (int)rp[i] << 16 | (int)gp[i] << 8 | (int)bp[i];
            }
            return cp;
        }
        FloatProcessor fp = this.normalize((FloatProcessor)ip.convertToFloat());
        if (ip instanceof FloatProcessor) {
            return fp;
        }
        int len = ip.getWidth() * ip.getHeight();
        for (int i = 0; i < len; ++i) {
            ip.setf(i, (float)fp.get(i));
        }
        return ip;
    }

    private FloatProcessor normalize(FloatProcessor fp) {
        double s = 0.0;
        int len = fp.getWidth() * fp.getHeight();
        float[] p = (float[])fp.getPixels();
        for (int i = 0; i < len; ++i) {
            s += (double)p[i];
        }
        double mean = s / (double)len;
        s = 0.0;
        for (int i = 0; i < len; ++i) {
            s += Math.pow((double)p[i] - mean, 2.0);
        }
        double K = this.targetStdDev / Math.sqrt(s / (double)(len - 1));
        for (int i = 0; i < len; ++i) {
            p[i] = (float)(((double)p[i] - mean) * K + this.targetMean);
        }
        return fp;
    }

    @Override
    public String toXML(String indent) {
        return indent + "<t2_filter class=\"" + this.getClass().getName() + "\" mean=\"" + this.targetMean + "\" stddev=\"" + this.targetStdDev + "\" />\n";
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            Normalize nr = (Normalize)o;
            return this.targetMean == nr.targetMean && this.targetStdDev == nr.targetStdDev;
        }
        return false;
    }
}

