/*
 * Decompiled with CFR 0.152.
 */
package lenscorrection;

import ij.IJ;
import ij.gui.GenericDialog;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Selection;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import lenscorrection.Distortion_Correction;
import lenscorrection.NonLinearTransform;
import mpicbg.ij.SIFT;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.models.Affine2D;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.Tile;
import mpicbg.trakem2.align.AbstractAffineTile2D;
import mpicbg.trakem2.align.Align;
import mpicbg.trakem2.align.RegularizedAffineLayerAlignment;
import mpicbg.trakem2.transform.CoordinateTransform;

public final class DistortionCorrectionTask {
    public static final CorrectDistortionFromSelectionParam correctDistortionFromSelectionParam = new CorrectDistortionFromSelectionParam();

    protected static final void setCoordinateTransform(List<Patch> patches, CoordinateTransform transform, int numThreads) {
        AtomicInteger ai = new AtomicInteger(0);
        ArrayList<SetCoordinateTransformThread> threads = new ArrayList<SetCoordinateTransformThread>();
        for (int i = 0; i < numThreads; ++i) {
            SetCoordinateTransformThread setCoordinateTransformThread = new SetCoordinateTransformThread(patches, transform, ai);
            threads.add(setCoordinateTransformThread);
            setCoordinateTransformThread.start();
        }
        try {
            for (Thread thread : threads) {
                thread.join();
            }
        }
        catch (InterruptedException e) {
            Utils.log("Setting CoordinateTransform failed.\n" + e.getMessage() + "\n" + e.getStackTrace());
        }
    }

    protected static final void appendCoordinateTransform(List<Patch> patches, CoordinateTransform transform, int numThreads) {
        AtomicInteger ai = new AtomicInteger(0);
        ArrayList<AppendCoordinateTransformThread> threads = new ArrayList<AppendCoordinateTransformThread>();
        for (int i = 0; i < numThreads; ++i) {
            AppendCoordinateTransformThread appendCoordinateTransformThread = new AppendCoordinateTransformThread(patches, transform, ai);
            threads.add(appendCoordinateTransformThread);
            appendCoordinateTransformThread.start();
        }
        try {
            for (Thread thread : threads) {
                thread.join();
            }
        }
        catch (InterruptedException e) {
            Utils.log("Appending CoordinateTransform failed.\n" + e.getMessage() + "\n" + e.getStackTrace());
        }
    }

    public static final Bureaucrat correctDistortionFromSelectionTask(final Selection selection) {
        Worker worker = new Worker("Distortion Correction", false, true){

            @Override
            public void run() {
                this.startedWorking();
                try {
                    DistortionCorrectionTask.correctDistortionFromSelection(selection);
                    Display.repaint(selection.getLayer());
                }
                catch (Throwable e) {
                    IJError.print(e);
                }
                finally {
                    this.finishedWorking();
                }
            }

            @Override
            public void cleanup() {
                if (!selection.isEmpty()) {
                    selection.getLayer().getParent().undoOneStep();
                }
            }
        };
        return Bureaucrat.createAndStart(worker, selection.getProject());
    }

    public static final void run(CorrectDistortionFromSelectionParam p, List<Patch> patches, Displayable active, Layer layer, Worker worker) {
        Object w;
        Align.ParamOptimize ap = new Align.ParamOptimize();
        ap.sift.set(p.sift);
        ap.desiredModelIndex = p.desiredModelIndex;
        ap.expectedModelIndex = p.expectedModelIndex;
        ap.maxEpsilon = p.maxEpsilon;
        ap.minInlierRatio = p.minInlierRatio;
        ap.rod = p.rod;
        ap.identityTolerance = p.identityTolerance;
        ap.lambda = p.lambdaRegularize;
        ap.maxIterations = p.maxIterationsOptimize;
        ap.maxPlateauwidth = p.maxPlateauwidthOptimize;
        ap.minNumInliers = p.minNumInliers;
        ap.regularize = p.regularize;
        ap.regularizerModelIndex = p.regularizerIndex;
        ap.rejectIdentity = p.rejectIdentity;
        ArrayList<Patch> allPatches = new ArrayList<Patch>();
        for (Layer l : layer.getParent().getLayers().subList(p.firstLayerIndex, p.lastLayerIndex + 1)) {
            for (Displayable d : l.getDisplayables(Patch.class)) {
                allPatches.add((Patch)d);
            }
        }
        if (p.clearTransform) {
            if (worker != null) {
                worker.setTaskName("Clearing present transforms");
            }
            DistortionCorrectionTask.setCoordinateTransform(allPatches, null, Runtime.getRuntime().availableProcessors());
            Display.repaint();
        }
        if (worker != null) {
            worker.setTaskName("Establishing SIFT correspondences");
        }
        ArrayList tiles = new ArrayList();
        ArrayList fixedTiles = new ArrayList();
        ArrayList<Patch> fixedPatches = new ArrayList<Patch>();
        if (active != null && active instanceof Patch) {
            fixedPatches.add((Patch)active);
        }
        Align.tilesFromPatches(ap, patches, fixedPatches, tiles, fixedTiles);
        ArrayList<AbstractAffineTile2D<?>[]> tilePairs = new ArrayList<AbstractAffineTile2D<?>[]>();
        if (p.tilesAreInPlace) {
            AbstractAffineTile2D.pairOverlappingTiles(tiles, tilePairs);
        } else {
            AbstractAffineTile2D.pairTiles(tiles, tilePairs);
        }
        AbstractAffineTile2D fixedTile = null;
        fixedTile = fixedTiles.size() > 0 ? (AbstractAffineTile2D)((Object)fixedTiles.get(0)) : (AbstractAffineTile2D)((Object)tiles.get(0));
        Align.connectTilePairs(ap, tiles, tilePairs, p.maxNumThreadsSift, p.multipleHypotheses);
        for (AbstractAffineTile2D abstractAffineTile2D : tiles) {
            Rectangle box = abstractAffineTile2D.getPatch().getCoordinateTransformBoundingBox();
            for (PointMatch m : abstractAffineTile2D.getMatches()) {
                double[] l = m.getP1().getL();
                w = m.getP1().getW();
                l[0] = l[0] + (double)box.x;
                l[1] = l[1] + (double)box.y;
                w[0] = l[0];
                w[1] = l[1];
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        ArrayList graphs = AbstractAffineTile2D.identifyConnectedGraphs(tiles);
        if (graphs.size() > 1) {
            Utils.log("Could not interconnect all images with correspondences.  ");
        }
        Set largestGraph = null;
        for (Set graph : graphs) {
            if (largestGraph != null && largestGraph.size() >= graph.size()) continue;
            largestGraph = graph;
        }
        ArrayList arrayList = new ArrayList();
        for (Tile t : largestGraph) {
            arrayList.add((AbstractAffineTile2D)t);
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Utils.log("Estimating lens model:");
        Align.optimizeTileConfiguration(ap, arrayList, fixedTiles);
        double e = 0.0;
        int n = 0;
        w = arrayList.iterator();
        while (w.hasNext()) {
            AbstractAffineTile2D t = (AbstractAffineTile2D)((Object)w.next());
            for (PointMatch pm : t.getMatches()) {
                e += pm.getDistance();
                ++n;
            }
        }
        double dEpsilon_i = 0.0;
        double epsilon_i = e /= (double)n;
        double dEpsilon_0 = 0.0;
        NonLinearTransform lensModel = null;
        Utils.log("0: epsilon = " + e);
        HashMap<Point, Point> originalPoints = new HashMap<Point, Point>();
        for (AbstractAffineTile2D abstractAffineTile2D : arrayList) {
            for (PointMatch pointMatch : abstractAffineTile2D.getMatches()) {
                originalPoints.put(pointMatch.getP1(), pointMatch.getP1().clone());
            }
        }
        for (int i = 1; i < 20 && (i < 2 || dEpsilon_i <= dEpsilon_0 / 1000.0); ++i) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            ArrayList<Distortion_Correction.PointMatchCollectionAndAffine> arrayList2 = new ArrayList<Distortion_Correction.PointMatchCollectionAndAffine>();
            for (AbstractAffineTile2D[] abstractAffineTile2DArray : tilePairs) {
                AffineTransform a = abstractAffineTile2DArray[0].createAffine();
                a.preConcatenate(((Affine2D)abstractAffineTile2DArray[1].getModel()).createInverseAffine());
                ArrayList<PointMatch> commonMatches = new ArrayList<PointMatch>();
                abstractAffineTile2DArray[0].commonPointMatches(abstractAffineTile2DArray[1], commonMatches);
                ArrayList<PointMatch> originalCommonMatches = new ArrayList<PointMatch>();
                for (PointMatch pm : commonMatches) {
                    originalCommonMatches.add(new PointMatch((Point)originalPoints.get(pm.getP1()), (Point)originalPoints.get(pm.getP2())));
                }
                arrayList2.add(new Distortion_Correction.PointMatchCollectionAndAffine(a, originalCommonMatches));
            }
            if (worker != null) {
                worker.setTaskName("Estimating lens distortion correction");
            }
            lensModel = Distortion_Correction.createInverseDistortionModel(arrayList2, p.dimension, p.lambda, (int)fixedTile.getWidth(), (int)fixedTile.getHeight());
            for (AbstractAffineTile2D abstractAffineTile2D : arrayList) {
                for (PointMatch pm : abstractAffineTile2D.getMatches()) {
                    Point currentPoint = pm.getP1();
                    Point originalPoint = (Point)originalPoints.get(currentPoint);
                    double[] l = currentPoint.getL();
                    double[] lo = originalPoint.getL();
                    l[0] = lo[0];
                    l[1] = lo[1];
                    lensModel.applyInPlace(l);
                }
            }
            Align.optimizeTileConfiguration(ap, arrayList, fixedTiles);
            e = 0.0;
            n = 0;
            for (AbstractAffineTile2D abstractAffineTile2D : arrayList) {
                for (PointMatch pm : abstractAffineTile2D.getMatches()) {
                    e += pm.getDistance();
                    ++n;
                }
            }
            dEpsilon_i = (e /= (double)n) - epsilon_i;
            epsilon_i = e;
            if (i == 1) {
                dEpsilon_0 = dEpsilon_i;
            }
            Utils.log(i + ": epsilon = " + e);
            Utils.log(i + ": delta epsilon = " + dEpsilon_i);
        }
        if (lensModel != null) {
            if (p.visualize) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (worker != null) {
                    worker.setTaskName("Visualizing lens distortion correction");
                }
                lensModel.visualizeSmall(p.lambda);
            }
            if (worker != null) {
                worker.setTaskName("Applying lens distortion correction");
            }
            DistortionCorrectionTask.appendCoordinateTransform(allPatches, lensModel, Runtime.getRuntime().availableProcessors());
            Utils.log("Done.");
        } else {
            Utils.log("No lens model found.");
        }
    }

    public static final void run(CorrectDistortionFromSelectionParam p, List<Patch> patches, Displayable active, Layer layer) {
        DistortionCorrectionTask.run(p, patches, active, layer, null);
    }

    public static final Bureaucrat correctDistortionFromSelection(final Selection selection) {
        final ArrayList<Patch> patches = new ArrayList<Patch>();
        for (Displayable d : Display.getFront().getSelection().getSelected()) {
            if (!(d instanceof Patch)) continue;
            patches.add((Patch)d);
        }
        if (patches.size() < 2) {
            Utils.log("No images in the selection.");
            return null;
        }
        Worker worker = new Worker("Lens correction"){

            @Override
            public final void run() {
                try {
                    this.startedWorking();
                    if (!correctDistortionFromSelectionParam.setup(selection)) {
                        return;
                    }
                    DistortionCorrectionTask.run(correctDistortionFromSelectionParam.clone(), patches, selection.getActive(), selection.getLayer(), null);
                    Display.repaint();
                }
                catch (Exception e) {
                    IJError.print(e);
                }
                finally {
                    this.finishedWorking();
                }
            }
        };
        return Bureaucrat.createAndStart(worker, selection.getProject());
    }

    protected static final class AppendCoordinateTransformThread
    extends Thread {
        protected final List<Patch> patches;
        protected final CoordinateTransform transform;
        protected final AtomicInteger ai;

        public AppendCoordinateTransformThread(List<Patch> patches, CoordinateTransform transform, AtomicInteger ai) {
            this.patches = patches;
            this.transform = transform;
            this.ai = ai;
        }

        @Override
        public final void run() {
            int i = this.ai.getAndIncrement();
            while (i < this.patches.size() && !this.isInterrupted()) {
                Patch patch = this.patches.get(i);
                patch.appendCoordinateTransform(this.transform);
                patch.updateMipMaps();
                IJ.showProgress((int)i, (int)this.patches.size());
                i = this.ai.getAndIncrement();
            }
        }
    }

    protected static final class SetCoordinateTransformThread
    extends Thread {
        protected final List<Patch> patches;
        protected final CoordinateTransform transform;
        protected final AtomicInteger ai;

        public SetCoordinateTransformThread(List<Patch> patches, CoordinateTransform transform, AtomicInteger ai) {
            this.patches = patches;
            this.transform = transform;
            this.ai = ai;
        }

        @Override
        public final void run() {
            int i = this.ai.getAndIncrement();
            while (i < this.patches.size() && !this.isInterrupted()) {
                Patch patch = this.patches.get(i);
                patch.setCoordinateTransform(this.transform);
                patch.updateMipMaps();
                patch.getProject().getLoader().decacheImagePlus(patch.getId());
                IJ.showProgress((int)i, (int)this.patches.size());
                i = this.ai.getAndIncrement();
            }
        }
    }

    public static class CorrectDistortionFromSelectionParam
    extends Distortion_Correction.BasicParam {
        public int firstLayerIndex;
        public int lastLayerIndex;
        public boolean clearTransform = false;
        public boolean visualize = false;
        public boolean tilesAreInPlace = false;
        public int minNumInliers = 20;
        public boolean multipleHypotheses = true;
        public boolean rejectIdentity = true;
        public float identityTolerance = 5.0f;
        public int desiredModelIndex = 1;
        public int maxIterationsOptimize = 2000;
        public int maxPlateauwidthOptimize = 200;
        public int maxNumThreadsSift = Runtime.getRuntime().availableProcessors();
        public boolean regularize = false;
        public int regularizerIndex = 0;
        public double lambdaRegularize = 0.01;

        public CorrectDistortionFromSelectionParam() {
            this.sift.fdSize = 4;
            this.expectedModelIndex = 0;
            this.desiredModelIndex = 0;
            this.minInlierRatio = 0.0f;
        }

        public boolean setupSIFT(String title) {
            GenericDialog gdSIFT = new GenericDialog(title + "SIFT parameters");
            SIFT.addFields((GenericDialog)gdSIFT, (FloatArray2DSIFT.Param)this.sift);
            gdSIFT.addMessage("Local Descriptor Matching:");
            gdSIFT.addNumericField("closest/next_closest_ratio :", (double)this.rod, 2);
            gdSIFT.addMessage("Miscellaneous:");
            gdSIFT.addNumericField("feature_extraction_threads :", (double)this.maxNumThreadsSift, 0);
            gdSIFT.showDialog();
            if (gdSIFT.wasCanceled()) {
                return false;
            }
            SIFT.readFields((GenericDialog)gdSIFT, (FloatArray2DSIFT.Param)this.sift);
            this.rod = (float)gdSIFT.getNextNumber();
            this.maxNumThreadsSift = (int)gdSIFT.getNextNumber();
            return true;
        }

        public boolean setup(Selection selection) {
            if (!this.setupSIFT("Distortion Correction: ")) {
                return false;
            }
            GenericDialog gd = new GenericDialog("Distortion Correction: Geometric filters");
            gd.addNumericField("maximal_alignment_error :", (double)this.maxEpsilon, 2, 6, "px");
            gd.addNumericField("minimal_inlier_ratio :", (double)this.minInlierRatio, 2);
            gd.addNumericField("minimal_number_of_inliers :", (double)this.minNumInliers, 0);
            gd.addChoice("expected_transformation :", RegularizedAffineLayerAlignment.Param.modelStrings, RegularizedAffineLayerAlignment.Param.modelStrings[this.expectedModelIndex]);
            gd.addCheckbox("test_multiple_hypotheses", this.multipleHypotheses);
            gd.addCheckbox("ignore constant background", this.rejectIdentity);
            gd.addNumericField("tolerance :", (double)this.identityTolerance, 2, 6, "px");
            gd.addCheckbox("tiles are rougly in place", this.tilesAreInPlace);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            this.maxEpsilon = (float)gd.getNextNumber();
            this.minInlierRatio = (float)gd.getNextNumber();
            this.minNumInliers = (int)gd.getNextNumber();
            this.expectedModelIndex = gd.getNextChoiceIndex();
            this.multipleHypotheses = gd.getNextBoolean();
            this.rejectIdentity = gd.getNextBoolean();
            this.identityTolerance = (float)gd.getNextNumber();
            this.tilesAreInPlace = gd.getNextBoolean();
            GenericDialog gdOptimize = new GenericDialog("Distortion Correction: Montage Optimization");
            gdOptimize.addChoice("desired_transformation :", modelStrings, modelStrings[this.desiredModelIndex]);
            gdOptimize.addCheckbox("regularize_model", this.regularize);
            gdOptimize.addMessage("Optimization:");
            gdOptimize.addNumericField("maximal_iterations :", (double)this.maxIterationsOptimize, 0);
            gdOptimize.addNumericField("maximal_plateauwidth :", (double)this.maxPlateauwidthOptimize, 0);
            gdOptimize.showDialog();
            if (gdOptimize.wasCanceled()) {
                return false;
            }
            this.desiredModelIndex = gdOptimize.getNextChoiceIndex();
            this.regularize = gdOptimize.getNextBoolean();
            this.maxIterationsOptimize = (int)gdOptimize.getNextNumber();
            this.maxPlateauwidthOptimize = (int)gdOptimize.getNextNumber();
            if (this.regularize) {
                GenericDialog gdRegularize = new GenericDialog("Distortion Correction: Montage Regularization");
                gdRegularize.addChoice("regularizer :", modelStrings, modelStrings[this.regularizerIndex]);
                gdRegularize.addNumericField("lambda :", this.lambdaRegularize, 2);
                gdRegularize.showDialog();
                if (gdRegularize.wasCanceled()) {
                    return false;
                }
                this.regularizerIndex = gdRegularize.getNextChoiceIndex();
                this.lambdaRegularize = gdRegularize.getNextNumber();
            }
            GenericDialog gdLens = new GenericDialog("Distortion Correction: Lens Distortion");
            gdLens.addMessage("Lens Model :");
            gdLens.addNumericField("power_of_polynomial_kernel :", (double)this.dimension, 0);
            gdLens.addNumericField("lambda :", this.lambda, 6);
            gdLens.addMessage("Apply Distortion Correction :");
            Utils.addLayerRangeChoices(selection.getLayer(), gdLens);
            gdLens.addCheckbox("clear_present_transforms", this.clearTransform);
            gdLens.addCheckbox("visualize_distortion_model", this.visualize);
            gdLens.showDialog();
            if (gdLens.wasCanceled()) {
                return false;
            }
            this.dimension = (int)gdLens.getNextNumber();
            this.lambda = gdLens.getNextNumber();
            this.firstLayerIndex = gdLens.getNextChoiceIndex();
            this.lastLayerIndex = gdLens.getNextChoiceIndex();
            this.clearTransform = gdLens.getNextBoolean();
            this.visualize = gdLens.getNextBoolean();
            return true;
        }

        @Override
        public CorrectDistortionFromSelectionParam clone() {
            CorrectDistortionFromSelectionParam p = new CorrectDistortionFromSelectionParam();
            p.sift.set(this.sift);
            p.dimension = this.dimension;
            p.expectedModelIndex = this.expectedModelIndex;
            p.lambda = this.lambda;
            p.maxEpsilon = this.maxEpsilon;
            p.minInlierRatio = this.minInlierRatio;
            p.rod = this.rod;
            p.tilesAreInPlace = this.tilesAreInPlace;
            p.firstLayerIndex = this.firstLayerIndex;
            p.lastLayerIndex = this.lastLayerIndex;
            p.clearTransform = this.clearTransform;
            p.visualize = this.visualize;
            p.desiredModelIndex = this.desiredModelIndex;
            p.identityTolerance = this.identityTolerance;
            p.lambdaRegularize = this.lambdaRegularize;
            p.maxIterationsOptimize = this.maxIterationsOptimize;
            p.maxNumThreadsSift = this.maxNumThreadsSift;
            p.maxPlateauwidthOptimize = this.maxPlateauwidthOptimize;
            p.minNumInliers = this.minNumInliers;
            p.multipleHypotheses = this.multipleHypotheses;
            p.regularize = this.regularize;
            p.regularizerIndex = this.regularizerIndex;
            p.rejectIdentity = this.rejectIdentity;
            return p;
        }
    }
}

