/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection.converters;

import java.lang.reflect.Array;
import org.renjin.eval.EvalException;
import org.renjin.invoke.reflection.converters.Converter;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;

public class DoubleArrayConverter
implements Converter<Object> {
    public final Class componentClass;

    public DoubleArrayConverter(Class clazz) {
        this.componentClass = clazz.getComponentType();
    }

    public static boolean accept(Class clazz) {
        Class<?> iclazz = clazz.getComponentType();
        return clazz.isArray() && (iclazz == Double.TYPE || iclazz == Double.class || iclazz == Float.TYPE || iclazz == Float.class || iclazz == Long.TYPE || iclazz == Long.class);
    }

    @Override
    public SEXP convertToR(Object value) {
        if (value == null) {
            return new DoubleArrayVector(DoubleVector.NA);
        }
        double[] dArray = new double[Array.getLength(value)];
        for (int i = 0; i < Array.getLength(value); ++i) {
            dArray[i] = ((Number)Array.get(value, i)).doubleValue();
        }
        return new DoubleArrayVector(dArray);
    }

    @Override
    public boolean acceptsSEXP(SEXP exp2) {
        return exp2 instanceof DoubleVector || exp2 instanceof IntVector || exp2 instanceof LogicalVector;
    }

    @Override
    public int getSpecificity() {
        return 3;
    }

    @Override
    public Object convertToJava(SEXP value) {
        if (!(value instanceof AtomicVector)) {
            throw new EvalException("It's not an AtomicVector", value.getTypeName());
        }
        if (value.length() < 1) {
            return new Double[0];
        }
        AtomicVector dv = (AtomicVector)value;
        int length2 = dv.length();
        Object array2 = Array.newInstance(this.componentClass, value.length());
        for (int i = 0; i < length2; ++i) {
            Array.set(array2, i, dv.getElementAsObject(i));
        }
        return array2;
    }
}

