/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.Warning;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Logical;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;

public abstract class SpecialFunction
extends PrimitiveFunction {
    public static final String TYPE_NAME = "special";
    private final String name;

    protected SpecialFunction(String name) {
        this.name = name;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visitSpecial(this);
    }

    public static boolean asLogicalNoNA(Context context, FunctionCall call2, SEXP s) {
        Logical logical2;
        if (s.length() == 0) {
            throw new EvalException("argument is of length zero", new Object[0]);
        }
        if (s.length() > 1) {
            Warning.invokeWarning(context, call2, "the condition has length > 1 and only the first element will be used", new Object[0]);
        }
        if ((logical2 = s.asLogical()) == Logical.NA) {
            throw new EvalException("missing value where TRUE/FALSE needed", new Object[0]);
        }
        return logical2 == Logical.TRUE;
    }

    protected void checkArity(FunctionCall call2, int expectedArguments, int optional) {
        int count = call2.getArguments().length();
        EvalException.check(count <= expectedArguments && count >= expectedArguments - optional, "invalid number of arguments", new Object[0]);
    }
}

