/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.updater;

import java.awt.Adjustable;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import net.imagej.ui.swing.updater.SwingTools;
import net.imagej.updater.util.Progress;
import net.imagej.updater.util.UpdateCanceledException;

public class ProgressDialog
extends JDialog
implements Progress {
    JProgressBar progress;
    JButton detailsToggle;
    int toggleHeight = -1;
    JScrollPane detailsScrollPane;
    Details details;
    Detail latestDetail;
    String title;
    boolean canceled;
    protected long latestUpdate;
    protected long itemLatestUpdate;

    public ProgressDialog(Frame owner) {
        this(owner, null);
    }

    public ProgressDialog(Frame owner, String title) {
        super(owner);
        Container root = this.getContentPane();
        root.setLayout(new BoxLayout(root, 1));
        this.progress = new JProgressBar();
        this.progress.setStringPainted(true);
        this.progress.setMinimum(0);
        root.add(this.progress);
        JPanel buttons = new JPanel();
        this.detailsToggle = new JButton("Show Details");
        this.detailsToggle.addActionListener(event -> this.toggleDetails());
        buttons.add(this.detailsToggle);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(e -> {
            this.canceled = true;
            this.dispose();
        });
        buttons.add(cancel);
        buttons.setMaximumSize(buttons.getMinimumSize());
        root.add(buttons);
        this.details = new Details();
        this.detailsScrollPane = new JScrollPane(this.details, 20, 30);
        this.detailsScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                Adjustable adjustable;
                int maximum;
                int value = e.getValue();
                if (value != (maximum = (adjustable = e.getAdjustable()).getMaximum())) {
                    adjustable.setValue(maximum);
                }
            }
        });
        this.detailsScrollPane.setVisible(false);
        root.add(this.detailsScrollPane);
        if (title != null) {
            this.setTitle(title);
        }
        this.pack();
        if (owner != null) {
            Dimension o = owner.getSize();
            Dimension size = this.getSize();
            if (size.width < o.width / 2) {
                size.width = o.width / 2;
                this.setSize(size);
            }
            this.setLocation(owner.getX() + (o.width - size.width) / 2, owner.getY() + (o.height - size.height) / 2);
        }
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ProgressDialog.this.cancel();
                }
            }
        };
        root.addKeyListener(keyAdapter);
        this.detailsToggle.addKeyListener(keyAdapter);
        cancel.addKeyListener(keyAdapter);
        this.setLocationRelativeTo(null);
        if (title != null) {
            this.setVisible(true);
        }
    }

    public void cancel() {
        this.canceled = true;
    }

    protected void checkIfCanceled() {
        if (this.canceled) {
            throw new UpdateCanceledException();
        }
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        this.setTitle();
        this.setVisible(true);
    }

    protected void setTitle() {
        this.checkIfCanceled();
        SwingTools.invokeOnEDT(() -> {
            if (this.detailsScrollPane.isVisible() || this.latestDetail == null) {
                this.progress.setString(this.title);
            } else {
                this.progress.setString(this.title + ": " + this.latestDetail.getString());
            }
        });
        this.repaint();
    }

    public void setCount(int count, int total) {
        this.checkIfCanceled();
        if (this.updatesTooFast()) {
            return;
        }
        SwingTools.invokeOnEDT(() -> {
            this.progress.setMaximum(total);
            this.progress.setValue(count);
        });
        this.repaint();
    }

    public void addItem(Object item) {
        this.checkIfCanceled();
        this.details.addDetail(item.toString());
        if (this.itemUpdatesTooFast() && !this.detailsScrollPane.isVisible()) {
            return;
        }
        this.setTitle();
        this.validate();
        this.repaint();
    }

    public void setItemCount(int count, int total) {
        this.checkIfCanceled();
        if (this.itemUpdatesTooFast()) {
            return;
        }
        SwingTools.invokeOnEDT(() -> {
            this.latestDetail.setMaximum(total);
            this.latestDetail.setValue(count);
            this.repaint();
        });
    }

    public void itemDone(Object item) {
        this.checkIfCanceled();
        if (this.itemUpdatesTooFast() && !this.detailsScrollPane.isVisible()) {
            return;
        }
        SwingTools.invokeOnEDT(() -> this.latestDetail.setValue(this.latestDetail.getMaximum()));
    }

    public void done() {
        if (this.latestDetail != null) {
            this.latestDetail.setValue(this.latestDetail.getMaximum());
        }
        SwingTools.invokeOnEDT(() -> {
            this.progress.setValue(this.progress.getMaximum());
            this.dispose();
        });
    }

    public void toggleDetails() {
        SwingTools.invokeOnEDT(() -> {
            boolean show = !this.detailsScrollPane.isVisible();
            this.detailsScrollPane.setVisible(show);
            this.detailsScrollPane.invalidate();
            this.detailsToggle.setText(show ? "Hide Details" : "Show Details");
            this.setTitle();
            Dimension dimension = this.getSize();
            if (this.toggleHeight == -1) {
                this.toggleHeight = dimension.height + 100;
            }
            this.setSize(new Dimension(dimension.width, this.toggleHeight));
            this.toggleHeight = dimension.height;
        });
    }

    protected boolean updatesTooFast() {
        if (System.currentTimeMillis() - this.latestUpdate < 50L) {
            return true;
        }
        this.latestUpdate = System.currentTimeMillis();
        return false;
    }

    protected boolean itemUpdatesTooFast() {
        if (System.currentTimeMillis() - this.itemLatestUpdate < 50L) {
            return true;
        }
        this.itemLatestUpdate = System.currentTimeMillis();
        return false;
    }

    public static void main(String[] args) {
        ProgressDialog dialog = new ProgressDialog(null, "Hello");
        dialog.addItem("Bello");
        dialog.setVisible(true);
    }

    private class Detail
    extends JProgressBar {
        Detail(String text) {
            this.setStringPainted(true);
            this.setString(text);
        }
    }

    private class Details
    extends JPanel {
        Details() {
            this.setLayout(new BoxLayout(this, 1));
        }

        public void addDetail(String title) {
            this.addDetail(new Detail(title));
        }

        public void addDetail(Detail detail) {
            this.add(detail);
            ProgressDialog.this.latestDetail = detail;
        }
    }
}

