/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.updater;

import javax.swing.JComboBox;
import net.imagej.ui.swing.updater.FileTable;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;

public class ViewOptions
extends JComboBox<Object> {
    protected final int customOptionStart = this.getItemCount();

    public ViewOptions() {
        super(Option.values());
        this.setMaximumRowCount(15);
    }

    public void clearCustomOptions() {
        while (this.getItemCount() > this.customOptionStart) {
            this.removeItemAt(this.customOptionStart);
        }
    }

    public void addCustomOption(final String title, final Iterable<FileObject> iterable) {
        this.addItem(new CustomOption(){

            public String toString() {
                return title;
            }

            @Override
            public Iterable<FileObject> getIterable() {
                return iterable;
            }
        });
    }

    public Iterable<FileObject> getView(FileTable table) {
        if (this.getSelectedIndex() >= this.customOptionStart) {
            return ((CustomOption)this.getSelectedItem()).getIterable();
        }
        FilesCollection files = table.files.clone(table.getAllFiles().notHidden());
        files.sort();
        switch ((Option)((Object)this.getSelectedItem())) {
            case INSTALLED: {
                return files.installed();
            }
            case UNINSTALLED: {
                return files.uninstalled();
            }
            case UPTODATE: {
                return files.upToDate();
            }
            case UPDATEABLE: {
                return files.shownByDefault();
            }
            case LOCALLY_MODIFIED: {
                return files.locallyModified();
            }
            case MANAGED: {
                return files.managedFiles();
            }
            case OTHERS: {
                return files.localOnly();
            }
            case CHANGES: {
                return files.changes();
            }
            case SELECTED: {
                return table.getSelectedFiles();
            }
        }
        return files;
    }

    protected static interface CustomOption {
        public Iterable<FileObject> getIterable();
    }

    public static enum Option {
        ALL("all files"),
        INSTALLED("installed files only"),
        UNINSTALLED("uninstalled files only"),
        UPTODATE("only up-to-date files"),
        UPDATEABLE("updateable files only"),
        LOCALLY_MODIFIED("locally modified files only"),
        MANAGED("downloaded files only"),
        OTHERS("local-only files"),
        CHANGES("changes"),
        SELECTED("selected");

        String label;

        private Option(String label) {
            this.label = "View " + label;
        }

        public String toString() {
            return this.label;
        }
    }
}

