/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.viewer.image;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.display.DataView;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageCanvas;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayView;
import net.imagej.display.event.DataViewDeselectedEvent;
import net.imagej.display.event.DataViewSelectedEvent;
import net.imagej.display.event.MouseCursorEvent;
import net.imagej.display.event.PanZoomEvent;
import net.imagej.ui.swing.overlay.FigureCreatedEvent;
import net.imagej.ui.swing.overlay.JHotDrawAdapter;
import net.imagej.ui.swing.overlay.JHotDrawService;
import net.imagej.ui.swing.overlay.JHotDrawTool;
import net.imagej.ui.swing.overlay.ToolDelegator;
import net.imagej.ui.swing.viewer.image.DatasetFigureView;
import net.imagej.ui.swing.viewer.image.FigureView;
import net.imagej.ui.swing.viewer.image.OverlayFigureView;
import net.imagej.ui.swing.viewer.image.SwingImageDisplayViewer;
import net.imglib2.RandomAccess;
import net.imglib2.display.screenimage.awt.ARGBScreenImage;
import net.imglib2.type.numeric.RealType;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.event.FigureSelectionEvent;
import org.jhotdraw.draw.event.FigureSelectionListener;
import org.jhotdraw.draw.tool.Tool;
import org.scijava.Disposable;
import org.scijava.display.event.DisplayDeletedEvent;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.event.EventSubscriber;
import org.scijava.input.MouseCursor;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.thread.ThreadService;
import org.scijava.tool.ToolService;
import org.scijava.tool.event.ToolActivatedEvent;
import org.scijava.ui.awt.AWTCursors;
import org.scijava.ui.awt.AWTDropTargetEventDispatcher;
import org.scijava.ui.awt.AWTInputEventDispatcher;
import org.scijava.ui.swing.StaticSwingUtils;
import org.scijava.util.IntCoords;
import org.scijava.util.RealCoords;
import org.scijava.util.RealRect;

public class JHotDrawImageCanvas
extends JPanel
implements AdjustmentListener,
ComponentListener,
FigureSelectionListener,
Disposable {
    private final SwingImageDisplayViewer displayViewer;
    private final Drawing drawing;
    private final DefaultDrawingView drawingView;
    private final DrawingEditor drawingEditor;
    private final ToolDelegator toolDelegator;
    private final JScrollPane scrollPane;
    private final List<FigureView> figureViews = new ArrayList<FigureView>();
    private final List<EventSubscriber<?>> subscribers;
    @Parameter
    private ToolService toolService;
    @Parameter
    private EventService eventService;
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private ThreadService threadService;
    @Parameter
    private JHotDrawService jHotDrawService;
    @Parameter
    private LogService log;

    public JHotDrawImageCanvas(SwingImageDisplayViewer displayViewer) {
        displayViewer.getDisplay().getContext().inject((Object)this);
        this.displayViewer = displayViewer;
        this.drawing = new DefaultDrawing();
        this.drawingView = new DefaultDrawingView(){

            public Dimension getPreferredSize() {
                Dimension drawViewSize = super.getPreferredSize();
                if (drawViewSize.width > 0 && drawViewSize.height > 0) {
                    return drawViewSize;
                }
                RealRect imageBounds = JHotDrawImageCanvas.this.getDisplay().getPlaneExtents();
                double zoomFactor = JHotDrawImageCanvas.this.getDisplay().getCanvas().getZoomFactor();
                int x = (int)(imageBounds.width * zoomFactor);
                int y = (int)(imageBounds.height * zoomFactor);
                int extra = 2;
                return new Dimension(x + 2, y + 2);
            }
        };
        this.drawingView.setDrawing(this.drawing);
        this.drawingEditor = new DefaultDrawingEditor();
        this.drawingEditor.add((DrawingView)this.drawingView);
        this.toolDelegator = new ToolDelegator();
        this.toolDelegator.setSelection(false);
        this.drawingEditor.setTool((Tool)this.toolDelegator);
        this.scrollPane = new JScrollPane((Component)this.drawingView);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        org.scijava.tool.Tool activeTool = this.toolService.getActiveTool();
        this.activateTool(activeTool);
        this.subscribers = this.eventService.subscribe((Object)this);
        this.drawingView.addFigureSelectionListener((FigureSelectionListener)this);
        this.drawingView.addComponentListener((ComponentListener)this);
    }

    public Drawing getDrawing() {
        return this.drawing;
    }

    public DefaultDrawingView getDrawingView() {
        return this.drawingView;
    }

    public DrawingEditor getDrawingEditor() {
        return this.drawingEditor;
    }

    public void addEventDispatcher(AWTInputEventDispatcher dispatcher) {
        dispatcher.register((Component)this.drawingView, true, true);
    }

    public void addEventDispatcher(AWTDropTargetEventDispatcher dispatcher) {
        dispatcher.register((Component)this.drawingView);
    }

    public Dataset capture() {
        ImageDisplay display = this.getDisplay();
        if (display == null) {
            return null;
        }
        DatasetView datasetView = this.imageDisplayService.getActiveDatasetView(display);
        if (datasetView == null) {
            return null;
        }
        ARGBScreenImage screenImage = datasetView.getScreenImage();
        BufferedImage pixels = screenImage.image();
        int w = ((Image)pixels).getWidth(null);
        int h = ((Image)pixels).getHeight(null);
        BufferedImage outputImage = new BufferedImage(w, h, 2);
        Graphics2D outputGraphics = outputImage.createGraphics();
        outputGraphics.drawImage((Image)pixels, 0, 0, null);
        for (FigureView view : this.figureViews) {
            view.getFigure().draw(outputGraphics);
        }
        Dataset dataset = this.datasetService.create(new long[]{w, h, 3L}, "Captured view", new AxisType[]{Axes.X, Axes.Y, Axes.CHANNEL}, 8, false, false);
        dataset.setRGBMerged(true);
        RandomAccess accessor = dataset.randomAccess();
        for (int x = 0; x < w; ++x) {
            accessor.setPosition(x, 0);
            for (int y = 0; y < h; ++y) {
                accessor.setPosition(y, 1);
                int rgb = outputImage.getRGB(x, y);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb >> 0 & 0xFF;
                accessor.setPosition(0, 2);
                ((RealType)accessor.get()).setReal((float)r);
                accessor.setPosition(1, 2);
                ((RealType)accessor.get()).setReal((float)g);
                accessor.setPosition(2, 2);
                ((RealType)accessor.get()).setReal((float)b);
            }
        }
        return dataset;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.syncCanvas();
    }

    public void selectionChanged(FigureSelectionEvent event) {
        Set newSelection = event.getNewSelection();
        Set oldSelection = event.getOldSelection();
        Iterator iterator = this.getDisplay().iterator();
        while (iterator.hasNext()) {
            DataView view = (DataView)iterator.next();
            FigureView figureView = this.getFigureView(view);
            if (figureView == null) continue;
            Figure figure = figureView.getFigure();
            if (newSelection.contains(figure)) {
                view.setSelected(true);
                continue;
            }
            if (!oldSelection.contains(figure)) continue;
            view.setSelected(false);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.syncCanvas();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @EventHandler
    protected void onEvent(DataViewSelectedEvent event) {
        DataView view = event.getView();
        FigureView figureView = this.getFigureView(view);
        if (figureView == null) {
            return;
        }
        Figure figure = figureView.getFigure();
        if (!this.drawingView.getSelectedFigures().contains(figure)) {
            this.drawingView.addToSelection(figure);
        }
    }

    @EventHandler
    protected void onEvent(DataViewDeselectedEvent event) {
        DataView view = event.getView();
        FigureView figureView = this.getFigureView(view);
        if (figureView == null) {
            return;
        }
        Figure figure = figureView.getFigure();
        if (this.drawingView.getSelectedFigures().contains(figure)) {
            this.drawingView.removeFromSelection(figure);
        }
    }

    @EventHandler
    protected void onEvent(ToolActivatedEvent event) {
        org.scijava.tool.Tool iTool = event.getTool();
        this.activateTool(iTool);
    }

    @EventHandler
    protected void onEvent(DisplayDeletedEvent event) {
        if (event.getObject() != this.getDisplay()) {
            return;
        }
        this.eventService.unsubscribe(this.subscribers);
    }

    @EventHandler
    protected void onEvent(PanZoomEvent event) {
        ImageCanvas canvas = event.getCanvas();
        if (canvas != this.getDisplay().getCanvas()) {
            return;
        }
        this.syncUI();
    }

    @EventHandler
    protected void onEvent(MouseCursorEvent event) {
        ImageCanvas canvas = event.getCanvas();
        if (canvas != this.getDisplay().getCanvas()) {
            return;
        }
        MouseCursor cursor = canvas.getCursor();
        Cursor awtCursor = AWTCursors.getCursor((MouseCursor)cursor);
        this.drawingView.setCursor(awtCursor);
    }

    @EventHandler
    protected void onEvent(FigureCreatedEvent event) {
        ImageDisplay display = event.getDisplay();
        if (display != this.getDisplay()) {
            return;
        }
        OverlayView overlay = event.getView();
        for (int i = 0; i < display.numDimensions(); ++i) {
            AxisType axisType = ((CalibratedAxis)display.axis(i)).type();
            if (axisType.isXY() || overlay.getData().dimensionIndex(axisType) >= 0) continue;
            overlay.setPosition(display.getLongPosition(axisType), axisType);
        }
        if (this.drawingView.getSelectedFigures().contains(event.getFigure())) {
            overlay.setSelected(true);
        }
        OverlayFigureView figureView = new OverlayFigureView(this.displayViewer, overlay, event.getFigure());
        this.figureViews.add(figureView);
        display.add(overlay);
        display.update();
    }

    void rebuild() {
        Iterator iterator = this.getDisplay().iterator();
        while (iterator.hasNext()) {
            DataView dataView = (DataView)iterator.next();
            FigureView figureView = this.getFigureView(dataView);
            if (figureView != null) continue;
            if (dataView instanceof DatasetView) {
                figureView = new DatasetFigureView(this.displayViewer, (DatasetView)dataView);
            } else if (dataView instanceof OverlayView) {
                figureView = new OverlayFigureView(this.displayViewer, (OverlayView)dataView);
            } else {
                this.log.error((Object)("Don't know how to make a figure view for " + dataView.getClass().getName()));
                continue;
            }
            this.figureViews.add(figureView);
        }
        int idx = 0;
        while (idx < this.figureViews.size()) {
            FigureView figureView = this.figureViews.get(idx);
            if (!this.getDisplay().contains(figureView.getDataView())) {
                this.figureViews.remove(idx);
                figureView.dispose();
                continue;
            }
            ++idx;
        }
    }

    void update() {
        for (FigureView figureView : this.figureViews) {
            figureView.update();
        }
    }

    private ImageDisplay getDisplay() {
        return this.displayViewer.getDisplay();
    }

    private FigureView getFigureView(DataView dataView) {
        for (FigureView figureView : this.figureViews) {
            if (figureView.getDataView() != dataView) continue;
            return figureView;
        }
        return null;
    }

    private void syncCanvas() {
        this.sync(true);
    }

    private void syncUI() {
        this.sync(false);
    }

    private void sync(boolean updateCanvas) {
        boolean zoomChanged;
        ImageCanvas canvas = this.getDisplay().getCanvas();
        if (!this.threadService.isDispatchThread()) {
            throw new IllegalStateException("Cannot sync viewport from thread: " + Thread.currentThread().getName());
        }
        Dimension uiSize = this.scrollPane.getViewport().getExtentSize();
        double uiZoom = this.drawingView.getScaleFactor();
        Point uiOffset = this.scrollPane.getViewport().getViewPosition();
        int canvasWidth = canvas.getViewportWidth();
        int canvasHeight = canvas.getViewportHeight();
        double canvasZoom = canvas.getZoomFactor();
        IntCoords canvasOffset = canvas.getPanOffset();
        boolean sizeChanged = uiSize.width != canvasWidth || uiSize.height != canvasHeight;
        boolean offsetChanged = uiOffset.x != canvasOffset.x || uiOffset.y != canvasOffset.y;
        boolean bl = zoomChanged = uiZoom != canvasZoom;
        if (!(sizeChanged || offsetChanged || zoomChanged)) {
            return;
        }
        if (this.log.isDebug()) {
            this.log.debug((Object)(this.getClass().getSimpleName() + " " + (updateCanvas ? "syncCanvas: " : "syncUI: ") + "\n\tUI size = " + uiSize.width + " x " + uiSize.height + "\n\tUI offset = " + uiOffset.x + ", " + uiOffset.y + "\n\tUI zoom = " + uiZoom + "\n\tCanvas size = " + canvasWidth + " x " + canvasHeight + "\n\tCanvas offset = " + canvasOffset.x + ", " + canvasOffset.y + "\n\tCanvas zoom = " + canvasZoom + "\n\t" + (sizeChanged ? "sizeChanged " : "") + (offsetChanged ? "offsetChanged " : "") + (zoomChanged ? "zoomChanged " : "")));
        }
        if (updateCanvas) {
            if (sizeChanged) {
                canvas.setViewportSize(uiSize.width, uiSize.height);
            }
            if (offsetChanged || zoomChanged) {
                double panCenterX = ((double)uiOffset.x + (double)uiSize.width / 2.0) / uiZoom;
                double panCenterY = ((double)uiOffset.y + (double)uiSize.height / 2.0) / uiZoom;
                canvas.setZoomAndCenter(uiZoom, new RealCoords(panCenterX, panCenterY));
            }
        } else {
            if (sizeChanged) {
                Dimension newViewSize = new Dimension(canvasWidth, canvasHeight);
                this.scrollPane.getViewport().setViewSize(newViewSize);
            }
            if (zoomChanged) {
                this.drawingView.setScaleFactor(canvasZoom);
            }
            if (offsetChanged) {
                Point newViewPos = new Point(canvasOffset.x, canvasOffset.y);
                this.scrollPane.getViewport().setViewPosition(newViewPos);
            }
            if (zoomChanged) {
                this.maybeResizeWindow();
            }
        }
    }

    private void maybeResizeWindow() {
        Rectangle bounds = StaticSwingUtils.getWorkSpaceBounds();
        RealRect imageBounds = this.getDisplay().getPlaneExtents();
        ImageCanvas canvas = this.getDisplay().getCanvas();
        IntCoords topLeft = canvas.dataToPanelCoords(new RealCoords(imageBounds.x, imageBounds.y));
        IntCoords bottomRight = canvas.dataToPanelCoords(new RealCoords(imageBounds.x + imageBounds.width, imageBounds.y + imageBounds.height));
        if (bottomRight.x - topLeft.x > bounds.width) {
            return;
        }
        if (bottomRight.y - topLeft.y > bounds.height) {
            return;
        }
        this.displayViewer.getWindow().pack();
    }

    private void activateTool(org.scijava.tool.Tool tool) {
        JHotDrawAdapter<?> adapter = this.jHotDrawService.getAdapter(tool);
        if (adapter != null) {
            JHotDrawTool creationTool = adapter.getCreationTool(this.getDisplay());
            this.toolDelegator.setCreationTool(creationTool);
            this.toolDelegator.setSelection(true);
        } else {
            this.toolDelegator.setCreationTool(null);
            this.toolDelegator.setSelection(false);
        }
    }

    public void dispose() {
        this.figureViews.clear();
    }
}

