/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.IOException;
import java.util.ArrayList;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.ui.dnd.AbstractDragAndDropData;
import org.scijava.ui.dnd.MIMEType;

public class AWTDragAndDropData
extends AbstractDragAndDropData {
    private final Transferable t;
    @Parameter(required=false)
    private LogService log;

    public AWTDragAndDropData(Context context, Transferable t) {
        this.setContext(context);
        this.t = t;
    }

    public boolean isSupported(MIMEType mimeType) {
        for (DataFlavor flavor : this.t.getTransferDataFlavors()) {
            if (!mimeType.isCompatible(new MIMEType(flavor.getMimeType()))) continue;
            return true;
        }
        return false;
    }

    public Object getData(MIMEType mimeType) {
        for (DataFlavor flavor : this.t.getTransferDataFlavors()) {
            if (!mimeType.isCompatible(new MIMEType(flavor.getMimeType()))) continue;
            try {
                return this.t.getTransferData(flavor);
            }
            catch (UnsupportedFlavorException exc) {
                throw new IllegalArgumentException("Unsupported MIME type: " + mimeType, exc);
            }
            catch (IOException exc) {
                if (this.log == null) continue;
                this.log.error((Object)"Drag-and-drop error", (Throwable)exc);
            }
            catch (InvalidDnDOperationException exc) {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported MIME type: " + mimeType);
    }

    public ArrayList<MIMEType> getMIMETypes() {
        ArrayList<MIMEType> mimeTypes = new ArrayList<MIMEType>();
        for (DataFlavor flavor : this.t.getTransferDataFlavors()) {
            mimeTypes.add(new MIMEType(flavor.getMimeType()));
        }
        return mimeTypes;
    }
}

