/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.launcher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public class SplashScreen {
    private static final int PROGRESS_MAX = 10000;
    private static final String LOGO_PATH = "splash/imagej.png";
    private static Object splashWindow;
    private static Object progressBar;

    public static void show() {
        ImageIcon imageIcon;
        if (Boolean.getBoolean("java.awt.headless")) {
            return;
        }
        JWindow window = new JWindow();
        splashWindow = window;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL logoURL = classLoader.getResource(LOGO_PATH);
        if (logoURL == null) {
            String parent = System.getProperty("imagej.dir") != null ? System.getProperty("imagej.dir") : ".";
            File logoFile = new File(parent, "images/icon.png");
            if (!logoFile.exists()) {
                return;
            }
            imageIcon = new ImageIcon(logoFile.getPath());
        } else {
            imageIcon = new ImageIcon(logoURL);
        }
        JLabel logoImage = new JLabel(imageIcon);
        JProgressBar bar = new JProgressBar();
        bar.setMaximum(10000);
        progressBar = bar;
        bar.setStringPainted(true);
        bar.setString("Starting ImageJ...");
        JPanel pane = new JPanel();
        pane.setOpaque(false);
        pane.setLayout(new BorderLayout());
        pane.add((Component)logoImage, "Center");
        pane.add((Component)bar, "South");
        window.setContentPane(pane);
        window.pack();
        window.setAlwaysOnTop(true);
        window.setLocationRelativeTo(null);
        window.setBackground(new Color(0, 0, 0, 0));
        window.setVisible(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                block2: while (true) {
                    Window[] windows;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (splashWindow == null) {
                        return;
                    }
                    Window[] windowArray = windows = Window.getWindows();
                    int n = windowArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block2;
                        Window win = windowArray[n2];
                        if (win.isVisible() && win != splashWindow) {
                            SplashScreen.hide();
                            return;
                        }
                        ++n2;
                    }
                    break;
                }
            }
        }, "Splash-Monitor").start();
    }

    public static void update(String message, double progress) {
        if (progressBar == null) {
            return;
        }
        ((JProgressBar)progressBar).setString(message);
        ((JProgressBar)progressBar).setValue((int)(progress * 10000.0));
    }

    public static void hide() {
        if (splashWindow == null) {
            return;
        }
        ((Window)splashWindow).dispose();
        splashWindow = null;
    }
}

