/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.deconvolve;

import java.util.concurrent.atomic.AtomicInteger;
import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Deconvolve.RichardsonLucyUpdate.class, priority=100.0)
public class RichardsonLucyTVUpdate<T extends RealType<T> & NativeType<T>, I extends RandomAccessibleInterval<T>>
extends AbstractUnaryComputerOp<I, I>
implements Ops.Deconvolve.RichardsonLucyUpdate {
    @Parameter
    private float regularizationFactor;
    @Parameter(required=false)
    private RandomAccessibleInterval<T> variation;
    final double FLOAT32_EPS = 0.0;

    @Override
    public void compute(I correction, I estimate) {
        if (this.variation == null) {
            Type type = (Type)Util.getTypeFromInterval(correction);
            this.variation = this.ops().create().img((Dimensions)correction, (NativeType)type.createVariable());
        }
        this.divUnitGradFastThread((RandomAccessibleInterval<T>)estimate);
        Cursor cursorCorrection = Views.iterable(correction).cursor();
        Cursor cursorVariation = Views.iterable(this.variation).cursor();
        Cursor cursorEstimate = Views.iterable(estimate).cursor();
        while (cursorEstimate.hasNext()) {
            cursorCorrection.fwd();
            cursorVariation.fwd();
            cursorEstimate.fwd();
            ((RealType)cursorEstimate.get()).mul(cursorCorrection.get());
            ((RealType)cursorEstimate.get()).mul(1.0f / (1.0f - this.regularizationFactor * ((RealType)cursorVariation.get()).getRealFloat()));
        }
    }

    static double hypot3(double a, double b, double c) {
        return Math.sqrt(a * a + b * b + c * c);
    }

    static double m(double a, double b) {
        if (a < 0.0 && b < 0.0) {
            if (a >= b) {
                return a;
            }
            return b;
        }
        if (a > 0.0 && b > 0.0) {
            if (a < b) {
                return a;
            }
            return b;
        }
        return 0.0;
    }

    void divUnitGradFastThread(final RandomAccessibleInterval<T> estimate) {
        final int Nx = (int)estimate.dimension(0);
        final int Ny = (int)estimate.dimension(1);
        final int Nz = estimate.numDimensions() > 2 ? (int)estimate.dimension(2) : 1;
        final AtomicInteger ai = new AtomicInteger(0);
        int numThreads = 4;
        Thread[] threads = SimpleMultiThreading.newThreads((int)4);
        final int zChunkSize = Nz / threads.length;
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    RandomAccess outRandom = RichardsonLucyTVUpdate.this.variation.randomAccess();
                    Cursor outCursor = Views.iterable((RandomAccessibleInterval)RichardsonLucyTVUpdate.this.variation).cursor();
                    int myNumber = ai.getAndIncrement();
                    int start = myNumber * zChunkSize;
                    int end = myNumber < 3 ? Math.min(start + zChunkSize, Nz) : Nz;
                    double hx = 1.0;
                    double hy = 1.0;
                    double hz = 3.0;
                    Cursor fimjmCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    Cursor fimCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    Cursor fimkmCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    Cursor fimkpCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    Cursor fimjpCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    Cursor fjmkmCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    Cursor fjmCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    Cursor fjmkpCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    Cursor fkmCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    Cursor fijkCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    Cursor fkpCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    Cursor fjpkmCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    Cursor fjpCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    Cursor fipjmCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    Cursor fipkmCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    Cursor fipCursor = Views.iterable((RandomAccessibleInterval)estimate).cursor();
                    for (int k = start; k < end; ++k) {
                        int km1 = k > 0 ? k - 1 : 0;
                        int kp1 = k + 1 == Nz ? k : k + 1;
                        for (int j = 0; j < Ny; ++j) {
                            int jm1 = j > 0 ? j - 1 : 0;
                            int jp1 = j + 1 == Ny ? j : j + 1;
                            fimjmCursor.reset();
                            fimjmCursor.jumpFwd((long)(k * Nx * Ny + jm1 * Nx));
                            fimjmCursor.fwd();
                            fimkmCursor.reset();
                            fimkmCursor.jumpFwd((long)(km1 * Nx * Ny + j * Nx));
                            fimkmCursor.fwd();
                            fimCursor.reset();
                            fimCursor.jumpFwd((long)(k * Nx * Ny + j * Nx));
                            fimCursor.fwd();
                            fimkpCursor.reset();
                            fimkpCursor.jumpFwd((long)(kp1 * Nx * Ny + j * Nx));
                            fimkpCursor.fwd();
                            fimjpCursor.reset();
                            fimjpCursor.jumpFwd((long)(k * Nx * Ny + jp1 * Nx));
                            fimjpCursor.fwd();
                            fjmkmCursor.reset();
                            fjmkmCursor.jumpFwd((long)(km1 * Nx * Ny + jm1 * Nx));
                            fjmkmCursor.fwd();
                            fjmCursor.reset();
                            fjmCursor.jumpFwd((long)(k * Nx * Ny + jm1 * Nx));
                            fjmCursor.fwd();
                            fjmkpCursor.reset();
                            fjmkpCursor.jumpFwd((long)(kp1 * Nx * Ny + jm1 * Nx));
                            fjmkpCursor.fwd();
                            fkmCursor.reset();
                            fkmCursor.jumpFwd((long)(km1 * Nx * Ny + j * Nx));
                            fkmCursor.fwd();
                            fijkCursor.reset();
                            fijkCursor.jumpFwd((long)(k * Nx * Ny + j * Nx));
                            fijkCursor.fwd();
                            fkpCursor.reset();
                            fkpCursor.jumpFwd((long)(kp1 * Nx * Ny + j * Nx));
                            fkpCursor.fwd();
                            fjpkmCursor.reset();
                            fjpkmCursor.jumpFwd((long)(km1 * Nx * Ny + jp1 * Nx));
                            fjpkmCursor.fwd();
                            fjpCursor.reset();
                            fjpCursor.jumpFwd((long)(k * Nx * Ny + jp1 * Nx));
                            fjpCursor.fwd();
                            fipjmCursor.reset();
                            fipjmCursor.jumpFwd((long)(k * Nx * Ny + jm1 * Nx));
                            fipjmCursor.fwd();
                            fipkmCursor.reset();
                            fipkmCursor.jumpFwd((long)(km1 * Nx * Ny + j * Nx));
                            fipkmCursor.fwd();
                            fipCursor.reset();
                            fipCursor.jumpFwd((long)(k * Nx * Ny + j * Nx));
                            fipCursor.fwd();
                            outCursor.reset();
                            outCursor.jumpFwd((long)(k * Nx * Ny + j * Nx));
                            outCursor.fwd();
                            for (int i = 0; i < Nx; ++i) {
                                if (i > 1) {
                                    fimjmCursor.fwd();
                                    fimCursor.fwd();
                                    fimkmCursor.fwd();
                                    fimkpCursor.fwd();
                                    fimjpCursor.fwd();
                                }
                                if (i > 0) {
                                    fjmkmCursor.fwd();
                                    fjmCursor.fwd();
                                    fjmkpCursor.fwd();
                                    fkmCursor.fwd();
                                    outRandom.setPosition(new int[]{i, j, k});
                                    fijkCursor.fwd();
                                    fkpCursor.fwd();
                                    fjpkmCursor.fwd();
                                    fjpCursor.fwd();
                                    outCursor.fwd();
                                }
                                if (i < Nx - 1) {
                                    fipjmCursor.fwd();
                                    fipkmCursor.fwd();
                                    fipCursor.fwd();
                                }
                                try {
                                    double fimjm = ((RealType)fimjmCursor.get()).getRealFloat();
                                    double fim = ((RealType)fimCursor.get()).getRealFloat();
                                    double fimkm = ((RealType)fimkmCursor.get()).getRealFloat();
                                    double fimkp = ((RealType)fimkpCursor.get()).getRealFloat();
                                    double fimjp = ((RealType)fimjpCursor.get()).getRealFloat();
                                    double fjmkm = ((RealType)fjmkmCursor.get()).getRealFloat();
                                    double fjm = ((RealType)fjmCursor.get()).getRealFloat();
                                    double fkm = ((RealType)fkmCursor.get()).getRealFloat();
                                    double fijk = ((RealType)fijkCursor.get()).getRealFloat();
                                    double fkp = ((RealType)fkpCursor.get()).getRealFloat();
                                    double fjpkm = ((RealType)fjpkmCursor.get()).getRealFloat();
                                    double fjp = ((RealType)fjpCursor.get()).getRealFloat();
                                    double fipjm = ((RealType)fipjmCursor.get()).getRealFloat();
                                    double fipkm = ((RealType)fipkmCursor.get()).getRealFloat();
                                    double fip = ((RealType)fipCursor.get()).getRealFloat();
                                    double Dxpf = (fip - fijk) / hx;
                                    double Dxmf = (fijk - fim) / hx;
                                    double Dypf = (fjp - fijk) / hy;
                                    double Dymf = (fijk - fjm) / hy;
                                    double Dzpf = (fkp - fijk) / hz;
                                    double Dzmf = (fijk - fkm) / hz;
                                    double aijk = RichardsonLucyTVUpdate.hypot3(Dxpf, RichardsonLucyTVUpdate.m(Dypf, Dymf), RichardsonLucyTVUpdate.m(Dzpf, Dzmf));
                                    double bijk = RichardsonLucyTVUpdate.hypot3(Dypf, RichardsonLucyTVUpdate.m(Dxpf, Dxmf), RichardsonLucyTVUpdate.m(Dzpf, Dzmf));
                                    double cijk = RichardsonLucyTVUpdate.hypot3(Dzpf, RichardsonLucyTVUpdate.m(Dypf, Dymf), RichardsonLucyTVUpdate.m(Dxpf, Dxmf));
                                    aijk = aijk > 0.0 ? Dxpf / aijk : 0.0;
                                    bijk = bijk > 0.0 ? Dypf / bijk : 0.0;
                                    cijk = cijk > 0.0 ? Dzpf / cijk : 0.0;
                                    Dxpf = (fijk - fim) / hx;
                                    Dypf = (fimjp - fim) / hy;
                                    Dymf = (fim - fimjm) / hy;
                                    Dzpf = (fimkp - fim) / hz;
                                    Dzmf = (fim - fimkm) / hz;
                                    double aim = RichardsonLucyTVUpdate.hypot3(Dxpf, RichardsonLucyTVUpdate.m(Dypf, Dymf), RichardsonLucyTVUpdate.m(Dzpf, Dzmf));
                                    aim = aim > 0.0 ? Dxpf / aim : 0.0;
                                    Dxpf = (fipjm - fjm) / hx;
                                    Dxmf = (fjm - fimjm) / hx;
                                    Dypf = (fijk - fjm) / hy;
                                    Dzmf = (fjm - fjmkm) / hz;
                                    double bjm = RichardsonLucyTVUpdate.hypot3(Dypf, RichardsonLucyTVUpdate.m(Dxpf, Dxmf), RichardsonLucyTVUpdate.m(Dzpf, Dzmf));
                                    bjm = bjm > 0.0 ? Dypf / bjm : 0.0;
                                    Dxpf = (fipkm - fkm) / hx;
                                    Dxmf = (fjm - fimkm) / hx;
                                    Dypf = (fjpkm - fkm) / hy;
                                    Dymf = (fkm - fjmkm) / hy;
                                    Dzpf = (fijk - fkm) / hz;
                                    double ckm = RichardsonLucyTVUpdate.hypot3(Dzpf, RichardsonLucyTVUpdate.m(Dypf, Dymf), RichardsonLucyTVUpdate.m(Dxpf, Dxmf));
                                    ckm = ckm > 0.0 ? Dzpf / ckm : 0.0;
                                    double Dxma = (aijk - aim) / hx;
                                    double Dymb = (bijk - bjm) / hy;
                                    double Dzmc = (cijk - ckm) / hz;
                                    ((RealType)outCursor.get()).setReal(Dxma + Dymb + Dzmc);
                                    continue;
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
    }
}

