/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.eval;

import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.imagej.ops.OpEnvironment;
import org.scijava.parsington.Operator;
import org.scijava.parsington.Operators;
import org.scijava.parsington.Variable;
import org.scijava.parsington.eval.DefaultStackEvaluator;

public class OpEvaluator
extends DefaultStackEvaluator {
    private final OpEnvironment ops;
    private final HashMap<Operator, String> opMap;

    public OpEvaluator(OpEnvironment ops) {
        this.ops = ops;
        this.opMap = new HashMap();
        this.opMap.put(Operators.POW, "math.power");
        this.opMap.put(Operators.POS, "identity");
        this.opMap.put(Operators.NEG, "math.negate");
        this.opMap.put(Operators.MUL, "math.multiply");
        this.opMap.put(Operators.DIV, "math.divide");
        this.opMap.put(Operators.MOD, "math.remainder");
        this.opMap.put(Operators.ADD, "math.add");
        this.opMap.put(Operators.SUB, "math.subtract");
        this.opMap.put(Operators.LEFT_SHIFT, "math.leftShift");
        this.opMap.put(Operators.RIGHT_SHIFT, "math.rightShift");
        this.opMap.put(Operators.UNSIGNED_RIGHT_SHIFT, "math.unsignedRightShift");
        this.opMap.put(Operators.LESS_THAN, "logic.lessThan");
        this.opMap.put(Operators.GREATER_THAN, "logic.greaterThan");
        this.opMap.put(Operators.LESS_THAN_OR_EQUAL, "logic.lessThanOrEqual");
        this.opMap.put(Operators.GREATER_THAN_OR_EQUAL, "logic.greaterThanOrEqual");
        this.opMap.put(Operators.EQUAL, "logic.equal");
        this.opMap.put(Operators.NOT_EQUAL, "logic.notEqual");
        this.opMap.put(Operators.BITWISE_AND, "math.and");
        this.opMap.put(Operators.BITWISE_OR, "math.or");
        this.opMap.put(Operators.LOGICAL_AND, "logic.and");
        this.opMap.put(Operators.LOGICAL_OR, "logic.or");
    }

    public Object execute(String opName, Object ... args) {
        Object[] argValues = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            argValues[i] = this.value(args[i]);
        }
        return this.ops.run(opName, argValues);
    }

    public String getOpName(Operator op) {
        return this.opMap.containsKey(op) ? this.opMap.get(op) : op.getToken();
    }

    public Map<Operator, String> getOpMap() {
        return this.opMap;
    }

    public Object execute(Operator op, Object ... args) {
        return this.execute(this.getOpName(op), args);
    }

    public Object function(Object a, Object b) {
        if (a instanceof Variable) {
            return this.execute(((Variable)a).getToken(), this.list(b).toArray());
        }
        return null;
    }

    public Object dot(Object a, Object b) {
        if (a instanceof Variable && b instanceof Variable) {
            String namespace = ((Variable)a).getToken();
            String opName = ((Variable)b).getToken();
            return new Variable(namespace + "." + opName);
        }
        return this.execute(Operators.DOT, a, b);
    }

    public Object transpose(Object a) {
        return this.execute(Operators.TRANSPOSE, a);
    }

    public Object dotTranspose(Object a) {
        return this.execute(Operators.DOT_TRANSPOSE, a);
    }

    public Object pow(Object a, Object b) {
        return this.execute(Operators.POW, a, b);
    }

    public Object dotPow(Object a, Object b) {
        return this.execute(Operators.DOT_POW, a, b);
    }

    public Object pos(Object a) {
        return this.execute(Operators.POS, a);
    }

    public Object neg(Object a) {
        return this.execute(Operators.NEG, a);
    }

    public Object complement(Object a) {
        return this.execute(Operators.COMPLEMENT, a);
    }

    public Object not(Object a) {
        return this.execute(Operators.NOT, a);
    }

    public Object mul(Object a, Object b) {
        return this.execute(Operators.MUL, a, b);
    }

    public Object div(Object a, Object b) {
        return this.execute(Operators.DIV, a, b);
    }

    public Object mod(Object a, Object b) {
        return this.execute(Operators.MOD, a, b);
    }

    public Object rightDiv(Object a, Object b) {
        return this.execute(Operators.RIGHT_DIV, a, b);
    }

    public Object dotMul(Object a, Object b) {
        return this.execute(Operators.DOT_MUL, a, b);
    }

    public Object dotDiv(Object a, Object b) {
        return this.execute(Operators.DOT_DIV, a, b);
    }

    public Object dotRightDiv(Object a, Object b) {
        return this.execute(Operators.DOT_RIGHT_DIV, a, b);
    }

    public Object add(Object a, Object b) {
        return this.execute(Operators.ADD, a, b);
    }

    public Object sub(Object a, Object b) {
        return this.execute(Operators.SUB, a, b);
    }

    public Object leftShift(Object a, Object b) {
        return this.execute(Operators.LEFT_SHIFT, a, b);
    }

    public Object rightShift(Object a, Object b) {
        return this.execute(Operators.RIGHT_SHIFT, a, b);
    }

    public Object unsignedRightShift(Object a, Object b) {
        return this.execute(Operators.UNSIGNED_RIGHT_SHIFT, a, b);
    }

    public Object colon(Object a, Object b) {
        return this.execute(Operators.COLON, a, b);
    }

    public Object lessThan(Object a, Object b) {
        return this.execute(Operators.LESS_THAN, a, b);
    }

    public Object greaterThan(Object a, Object b) {
        return this.execute(Operators.GREATER_THAN, a, b);
    }

    public Object lessThanOrEqual(Object a, Object b) {
        return this.execute(Operators.LESS_THAN_OR_EQUAL, a, b);
    }

    public Object greaterThanOrEqual(Object a, Object b) {
        return this.execute(Operators.GREATER_THAN_OR_EQUAL, a, b);
    }

    public Object instanceOf(Object a, Object b) {
        return this.execute(Operators.INSTANCEOF, a, b);
    }

    public Object equal(Object a, Object b) {
        return this.execute(Operators.EQUAL, a, b);
    }

    public Object notEqual(Object a, Object b) {
        return this.execute(Operators.NOT_EQUAL, a, b);
    }

    public Object bitwiseAnd(Object a, Object b) {
        return this.execute(Operators.BITWISE_AND, a, b);
    }

    public Object bitwiseOr(Object a, Object b) {
        return this.execute(Operators.BITWISE_OR, a, b);
    }

    public Object logicalAnd(Object a, Object b) {
        return this.execute(Operators.LOGICAL_AND, a, b);
    }

    public Object logicalOr(Object a, Object b) {
        return this.execute(Operators.LOGICAL_OR, a, b);
    }

    public Object execute(Operator op, Deque<Object> stack) {
        int i;
        int arity = op.getArity();
        Object[] args = new Object[arity];
        for (i = args.length - 1; i >= 0; --i) {
            args[i] = stack.pop();
        }
        for (i = 0; i < args.length; ++i) {
            stack.push(args[i]);
        }
        Object result = super.execute(op, stack);
        if (result != null) {
            return result;
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            args[i2] = this.value(args[i2]);
        }
        return this.execute(op, args);
    }

    private List<?> list(Object o) {
        if (o instanceof List) {
            return (List)o;
        }
        return Collections.singletonList(o);
    }
}

