/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom2d;

import java.util.ArrayList;
import net.imagej.ops.Ops;
import net.imagej.ops.geom.GeomUtils;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.roi.geom.real.DefaultWritablePolygon2D;
import net.imglib2.roi.geom.real.Polygon2D;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.BoundingBox.class)
public class DefaultBoundingBox
extends AbstractUnaryFunctionOp<Polygon2D, Polygon2D>
implements Ops.Geometric.BoundingBox {
    @Override
    public Polygon2D calculate(Polygon2D input) {
        double min_x = Double.POSITIVE_INFINITY;
        double max_x = Double.NEGATIVE_INFINITY;
        double min_y = Double.POSITIVE_INFINITY;
        double max_y = Double.NEGATIVE_INFINITY;
        for (RealLocalizable rl : GeomUtils.vertices(input)) {
            if (rl.getDoublePosition(0) < min_x) {
                min_x = rl.getDoublePosition(0);
            }
            if (rl.getDoublePosition(0) > max_x) {
                max_x = rl.getDoublePosition(0);
            }
            if (rl.getDoublePosition(1) < min_y) {
                min_y = rl.getDoublePosition(1);
            }
            if (!(rl.getDoublePosition(1) > max_y)) continue;
            max_y = rl.getDoublePosition(1);
        }
        ArrayList<RealPoint> bounds = new ArrayList<RealPoint>();
        bounds.add(new RealPoint(new double[]{min_x, min_y}));
        bounds.add(new RealPoint(new double[]{min_x, max_y}));
        bounds.add(new RealPoint(new double[]{max_x, max_y}));
        bounds.add(new RealPoint(new double[]{max_x, min_y}));
        return new DefaultWritablePolygon2D(bounds);
    }
}

