/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.scalespace;

import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.function.SubtractNormReal;
import mpicbg.imglib.algorithm.gauss.GaussianConvolution2;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussian;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.function.Function;
import mpicbg.imglib.function.RealTypeConverter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

public class DifferenceOfGaussianReal<A extends RealType<A>, B extends RealType<B>>
extends DifferenceOfGaussian<A, B> {
    double normalizationFactor;
    double minPeakValue;

    public DifferenceOfGaussianReal(Image<A> img, ImageFactory<B> factory, OutOfBoundsStrategyFactory<B> outOfBoundsFactory, double sigma1, double sigma2, double minPeakValue, double normalizationFactor) {
        super(img, factory, new RealTypeConverter(), outOfBoundsFactory, sigma1, sigma2, DifferenceOfGaussianReal.createVariable(factory, minPeakValue), DifferenceOfGaussianReal.createVariable(factory, normalizationFactor));
        this.normalizationFactor = normalizationFactor;
        this.minPeakValue = minPeakValue;
    }

    public DifferenceOfGaussianReal(Image<A> img, ImageFactory<B> factory, OutOfBoundsStrategyFactory<B> outOfBoundsFactory, double[] sigma1, double[] sigma2, double minPeakValue, double normalizationFactor) {
        super(img, factory, new RealTypeConverter(), outOfBoundsFactory, sigma1, sigma2, DifferenceOfGaussianReal.createVariable(factory, minPeakValue), DifferenceOfGaussianReal.createVariable(factory, normalizationFactor));
        this.normalizationFactor = normalizationFactor;
        this.minPeakValue = minPeakValue;
    }

    protected static <T extends RealType<T>> T createVariable(ImageFactory<T> img, double value) {
        RealType type = (RealType)img.createType();
        type.setReal(value);
        return (T)type;
    }

    @Override
    public void setMinPeakValue(B value) {
        this.minPeakValue = value.getRealDouble();
    }

    @Override
    public B getMinPeakValue() {
        return (B)DifferenceOfGaussianReal.createVariable(this.factory, this.minPeakValue);
    }

    @Override
    protected OutputAlgorithm<B> getGaussianConvolution(double[] sigma, int numThreads) {
        GaussianConvolution2 gauss = new GaussianConvolution2(this.image, this.factory, this.outOfBoundsFactory, new RealTypeConverter(), sigma);
        return gauss;
    }

    @Override
    protected Function<B, B, B> getNormalizedSubtraction() {
        return new SubtractNormReal(this.normalizationFactor);
    }

    @Override
    protected boolean isPeakHighEnough(B value) {
        return Math.abs(value.getRealDouble()) >= this.minPeakValue;
    }

    @Override
    protected DifferenceOfGaussian.SpecialPoint isSpecialPoint(LocalNeighborhoodCursor<B> neighborhoodCursor, B centerValue) {
        boolean isMax;
        double value;
        boolean isMin = true;
        double centerValueReal = centerValue.getRealDouble();
        for (isMax = true; (isMax || isMin) && neighborhoodCursor.hasNext(); isMin &= value >= centerValueReal, isMax &= value <= centerValueReal) {
            neighborhoodCursor.fwd();
            value = ((RealType)neighborhoodCursor.getType()).getRealDouble();
        }
        if (isMin) {
            return DifferenceOfGaussian.SpecialPoint.MAX;
        }
        if (isMax) {
            return DifferenceOfGaussian.SpecialPoint.MIN;
        }
        return DifferenceOfGaussian.SpecialPoint.INVALID;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "DifferenceOfGaussian: [Image<A> img] is null.";
            return false;
        }
        if (this.factory == null) {
            this.errorMessage = "DifferenceOfGaussian: [ImageFactory<B> img] is null.";
            return false;
        }
        if (this.outOfBoundsFactory == null) {
            this.errorMessage = "DifferenceOfGaussian: [OutOfBoundsStrategyFactory<B>] is null.";
            return false;
        }
        return true;
    }
}

