/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.array;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.basictypecontainer.array.FakeArray;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.array.ArrayCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;

public class ArrayLocalizableCursor<T extends Type<T>>
extends ArrayCursor<T>
implements LocalizableCursor<T> {
    protected final int numDimensions;
    protected final int[] position;
    protected final int[] dimensions;

    public ArrayLocalizableCursor(Array<T, ?> container, Image<T> image, T type) {
        super(container, image, type);
        this.numDimensions = container.getNumDimensions();
        this.position = new int[this.numDimensions];
        this.dimensions = container.getDimensions();
        this.reset();
    }

    public static ArrayLocalizableCursor<FakeType> createLinearCursor(int[] dim) {
        Array array = new Array(null, new FakeArray(), dim, 1);
        return new ArrayLocalizableCursor<FakeType>(array, null, new FakeType());
    }

    @Override
    public void fwd() {
        this.type.incIndex();
        for (int d = 0; d < this.numDimensions; ++d) {
            if (this.position[d] >= this.dimensions[d] - 1) continue;
            int n = d;
            this.position[n] = this.position[n] + 1;
            for (int e = 0; e < d; ++e) {
                this.position[e] = 0;
            }
            return;
        }
    }

    @Override
    public void fwd(long steps) {
        for (long j = 0L; j < steps; ++j) {
            this.fwd();
        }
    }

    @Override
    public void reset() {
        if (this.dimensions == null) {
            return;
        }
        this.isClosed = false;
        this.type.updateIndex(-1);
        this.position[0] = -1;
        for (int d = 1; d < this.numDimensions; ++d) {
            this.position[d] = 0;
        }
        this.type.updateContainer(this);
    }

    @Override
    public void getPosition(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            position[d] = this.position[d];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int dim) {
        return this.position[dim];
    }

    @Override
    public String getPositionAsString() {
        String pos = "(" + this.position[0];
        for (int d = 1; d < this.numDimensions; ++d) {
            pos = pos + ", " + this.position[d];
        }
        pos = pos + ")";
        return pos;
    }

    @Override
    public String toString() {
        return this.getPositionAsString() + " = " + this.getType();
    }
}

