/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.lanczos;

import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.InterpolatorImpl;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

public class LanczosInterpolator<T extends RealType<T>>
extends InterpolatorImpl<T> {
    protected static final float piSquare = (float)(Math.PI * Math.PI);
    final LocalizableByDimCursor<T> cursor;
    final RegionOfInterestCursor<T> roiCursor;
    final float alphaF;
    final int alpha;
    final int numDimensions;
    final T interpolatedValue;
    final int[] offset;
    final int[] size;
    final float minValue;
    final float maxValue;
    final boolean clipping;

    protected LanczosInterpolator(Image<T> img, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, int alpha, boolean clipping) {
        super(img, interpolatorFactory, outOfBoundsStrategyFactory);
        this.alphaF = alpha;
        this.alpha = alpha;
        this.numDimensions = img.getNumDimensions();
        this.offset = new int[this.numDimensions];
        this.size = new int[this.numDimensions];
        for (int d = 0; d < this.numDimensions; ++d) {
            this.size[d] = alpha * 2;
        }
        this.cursor = img.createLocalizableByDimCursor(outOfBoundsStrategyFactory);
        this.roiCursor = new RegionOfInterestCursor<T>(this.cursor, this.offset, this.size);
        this.interpolatedValue = (RealType)img.createType();
        this.clipping = clipping;
        this.minValue = (float)this.interpolatedValue.getMinValue();
        this.maxValue = (float)this.interpolatedValue.getMaxValue();
        this.moveTo(this.position);
    }

    @Override
    public T getType() {
        this.roiCursor.reset(this.offset, this.size);
        float convolved = 0.0f;
        while (this.roiCursor.hasNext()) {
            this.roiCursor.fwd();
            float v = 1.0f;
            for (int d = 0; d < this.numDimensions; ++d) {
                v *= LanczosInterpolator.sinc(this.position[d] - (float)this.cursor.getPosition(d), this.alphaF);
            }
            convolved += ((RealType)this.roiCursor.getType()).getRealFloat() * v;
        }
        if (this.clipping) {
            if (convolved < this.minValue) {
                convolved = this.minValue;
            } else if (convolved > this.maxValue) {
                convolved = this.maxValue;
            }
            this.interpolatedValue.setReal(convolved);
        } else {
            this.interpolatedValue.setReal(convolved);
        }
        return this.interpolatedValue;
    }

    protected static final float sinc(float x, float a) {
        if (x == 0.0f) {
            return 1.0f;
        }
        return (float)((double)a * Math.sin(Math.PI * (double)x) * Math.sin(Math.PI * (double)x / (double)a) / (double)((float)(Math.PI * Math.PI) * x * x));
    }

    protected static final int floor(float value) {
        return value > 0.0f ? (int)value : (int)value - 1;
    }

    @Override
    public void close() {
    }

    @Override
    public void moveTo(float[] pos) {
        for (int d = 0; d < this.numDimensions; ++d) {
            float p;
            this.position[d] = p = pos[d];
            this.offset[d] = LanczosInterpolator.floor(p) - this.alpha + 1;
        }
    }

    @Override
    public void moveTo(double[] pos) {
        for (int d = 0; d < this.numDimensions; ++d) {
            float p;
            this.position[d] = p = (float)pos[d];
            this.offset[d] = LanczosInterpolator.floor(p) - this.alpha + 1;
        }
    }

    @Override
    public void moveRel(float[] vector) {
        for (int d = 0; d < this.numDimensions; ++d) {
            float p;
            this.position[d] = p = this.position[d] + vector[d];
            this.offset[d] = LanczosInterpolator.floor(p) - this.alpha + 1;
        }
    }

    @Override
    public void moveRel(double[] vector) {
        for (int d = 0; d < this.numDimensions; ++d) {
            float p;
            this.position[d] = p = (float)((double)this.position[d] + vector[d]);
            this.offset[d] = LanczosInterpolator.floor(p) - this.alpha + 1;
        }
    }

    @Override
    public void setPosition(float[] pos) {
        for (int d = 0; d < this.numDimensions; ++d) {
            float p;
            this.position[d] = p = pos[d];
            this.offset[d] = LanczosInterpolator.floor(p) - this.alpha + 1;
        }
    }

    @Override
    public void setPosition(double[] pos) {
        for (int d = 0; d < this.numDimensions; ++d) {
            float p;
            this.position[d] = p = (float)pos[d];
            this.offset[d] = LanczosInterpolator.floor(p) - this.alpha + 1;
        }
    }
}

