/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.labeling;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.labeling.BoundingBox;
import mpicbg.imglib.labeling.Labeling;
import mpicbg.imglib.labeling.LabelingCursorStrategy;
import mpicbg.imglib.labeling.LabelingType;
import mpicbg.imglib.labeling.LocalizableLabelingCursor;
import mpicbg.imglib.labeling.LocalizableLabelingPerimeterCursor;
import mpicbg.imglib.type.label.FakeType;

public class DefaultLabelingCursorStrategy<T extends Comparable<T>, L extends Labeling<T>>
implements LabelingCursorStrategy<T, L> {
    protected final L labeling;
    protected long generation;
    protected LabelingType<T> type = null;
    protected Map<T, LabelStatistics> statistics;

    public DefaultLabelingCursorStrategy(L labeling) {
        this.labeling = labeling;
        this.generation = Long.MIN_VALUE;
    }

    protected void computeStatistics() {
        if (this.type == null || this.type.getGeneration() != this.generation) {
            this.statistics = new HashMap<T, LabelStatistics>();
            LocalizableCursor c = ((Image)this.labeling).createLocalizableCursor();
            if (this.type == null) {
                this.type = (LabelingType)c.getType();
            }
            int[] position = c.createPositionArray();
            LabelStatistics last = null;
            Comparable lastLabel = null;
            for (LabelingType t : c) {
                c.getPosition(position);
                for (Comparable label : t.getLabeling()) {
                    if (last == null || !label.equals(lastLabel)) {
                        lastLabel = label;
                        last = this.statistics.get(label);
                        if (last == null) {
                            last = new LabelStatistics(c.getNumDimensions());
                            this.statistics.put(label, last);
                        }
                    }
                    last.update(position);
                }
            }
            this.generation = this.type.getGeneration();
            c.close();
        }
    }

    @Override
    public LocalizableCursor<FakeType> createLocalizableLabelCursor(T label) {
        int[] offset = new int[((Image)this.labeling).getNumDimensions()];
        int[] size = new int[((Image)this.labeling).getNumDimensions()];
        this.getExtents(label, offset, size);
        for (int i = 0; i < offset.length; ++i) {
            int n = i;
            size[n] = size[n] - offset[i];
        }
        LocalizableByDimCursor c = ((Image)this.labeling).createLocalizableByDimCursor();
        RegionOfInterestCursor roiCursor = new RegionOfInterestCursor(c, offset, size);
        return new LocalizableLabelingCursor(roiCursor, offset, label);
    }

    @Override
    public LocalizableCursor<FakeType> createLocalizablePerimeterCursor(T label) {
        int[] offset = new int[((Image)this.labeling).getNumDimensions()];
        int[] size = new int[((Image)this.labeling).getNumDimensions()];
        this.getExtents(label, offset, size);
        for (int i = 0; i < offset.length; ++i) {
            int n = i;
            size[n] = size[n] - offset[i];
        }
        LocalizableByDimCursor c = ((Image)this.labeling).createLocalizableByDimCursor();
        RegionOfInterestCursor roiCursor = new RegionOfInterestCursor(c, offset, size);
        LocalizableByDimCursor cc = ((Image)this.labeling).createLocalizableByDimCursor();
        return new LocalizableLabelingPerimeterCursor(roiCursor, offset, cc, label);
    }

    @Override
    public boolean getExtents(T label, int[] minExtents, int[] maxExtents) {
        this.computeStatistics();
        LabelStatistics stats = this.statistics.get(label);
        if (stats == null) {
            if (minExtents != null) {
                Arrays.fill(minExtents, 0);
            }
            if (maxExtents != null) {
                Arrays.fill(maxExtents, 0);
            }
            return false;
        }
        stats.getExtents(minExtents, maxExtents);
        return true;
    }

    @Override
    public boolean getRasterStart(T label, int[] start) {
        this.computeStatistics();
        LabelStatistics stats = this.statistics.get(label);
        if (stats == null) {
            Arrays.fill(start, 0);
            return false;
        }
        stats.getRasterStart(start);
        return true;
    }

    @Override
    public long getArea(T label) {
        this.computeStatistics();
        LabelStatistics stats = this.statistics.get(label);
        if (stats == null) {
            return 0L;
        }
        return stats.getArea();
    }

    @Override
    public Collection<T> getLabels() {
        this.computeStatistics();
        return this.statistics.keySet();
    }

    private class LabelStatistics
    extends BoundingBox {
        private int[] rasterStart;
        private long area;

        public LabelStatistics(int dimensions) {
            super(dimensions);
            this.area = 0L;
            this.rasterStart = new int[dimensions];
            Arrays.fill(this.rasterStart, Integer.MAX_VALUE);
        }

        public void getRasterStart(int[] dest) {
            System.arraycopy(this.rasterStart, 0, dest, 0, this.rasterStart.length);
        }

        public long getArea() {
            return this.area;
        }

        @Override
        public void update(int[] coordinates) {
            super.update(coordinates);
            ++this.area;
            for (int i = 0; i < this.rasterStart.length; ++i) {
                if (this.rasterStart[i] > coordinates[i]) {
                    System.arraycopy(coordinates, 0, this.rasterStart, 0, this.rasterStart.length);
                    return;
                }
                if (this.rasterStart[i] >= coordinates[i]) continue;
                return;
            }
        }
    }
}

