/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij.export.imgloader;

import ij.ImagePlus;
import io.scif.img.ImgIOException;
import io.scif.img.ImgOpener;
import java.util.HashMap;
import java.util.Map;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.SetupImgLoader;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.converter.RealUnsignedShortConverter;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.planar.PlanarImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;

@Deprecated
public class FusionImageLoader<T extends RealType<T>>
implements ImgLoader {
    private final String pattern;
    private final int numSlices;
    private final SliceLoader<T> sliceLoader;
    private final RealUnsignedShortConverter<T> converter;
    private final ImgFactory<UnsignedShortType> factory;
    private final UnsignedShortType type;
    private final HashMap<Integer, SetupLoader> setupIdToSetupImgLoader;

    public FusionImageLoader(String pattern, HashMap<Integer, Integer> setupIdToChannelId, int numSlices, SliceLoader<T> sliceLoader, double sliceValueMin, double sliceValueMax) {
        this(pattern, setupIdToChannelId, numSlices, sliceLoader, sliceValueMin, sliceValueMax, (ImgFactory<UnsignedShortType>)new PlanarImgFactory());
    }

    public FusionImageLoader(String pattern, HashMap<Integer, Integer> setupIdToChannelId, int numSlices, SliceLoader<T> sliceLoader, double sliceValueMin, double sliceValueMax, ImgFactory<UnsignedShortType> factory) {
        this.pattern = pattern;
        this.numSlices = numSlices;
        this.sliceLoader = sliceLoader;
        this.converter = new RealUnsignedShortConverter(sliceValueMin, sliceValueMax);
        this.factory = factory;
        this.type = new UnsignedShortType();
        this.setupIdToSetupImgLoader = new HashMap();
        for (Map.Entry<Integer, Integer> entry : setupIdToChannelId.entrySet()) {
            this.setupIdToSetupImgLoader.put(entry.getKey(), new SetupLoader(entry.getValue()));
        }
    }

    public SetupLoader getSetupImgLoader(int setupId) {
        return this.setupIdToSetupImgLoader.get(setupId);
    }

    public class SetupLoader
    implements SetupImgLoader<UnsignedShortType> {
        private final int channelId;

        protected SetupLoader(int channelId) {
            this.channelId = channelId;
        }

        public RandomAccessibleInterval<UnsignedShortType> getImage(int timepointId, ImgLoaderHint ... hints) {
            Dimensions dimensions = this.getImageSize(timepointId);
            Img img = FusionImageLoader.this.factory.create(dimensions, (Object)FusionImageLoader.this.type);
            for (int z = 0; z < FusionImageLoader.this.numSlices; ++z) {
                RandomAccessibleInterval slice = FusionImageLoader.this.sliceLoader.load(String.format(FusionImageLoader.this.pattern, timepointId, this.channelId, z));
                Cursor d = Views.flatIterable((RandomAccessibleInterval)Views.hyperSlice((RandomAccessibleInterval)img, (int)2, (long)z)).cursor();
                for (UnsignedShortType t : Converters.convert((RandomAccessibleInterval)Views.flatIterable(slice), (Converter)FusionImageLoader.this.converter, (Type)FusionImageLoader.this.type)) {
                    ((UnsignedShortType)d.next()).set((GenericShortType)t);
                }
            }
            return img;
        }

        public UnsignedShortType getImageType() {
            return FusionImageLoader.this.type;
        }

        public RandomAccessibleInterval<FloatType> getFloatImage(int timepointId, boolean normalize, ImgLoaderHint ... hints) {
            throw new UnsupportedOperationException();
        }

        public Dimensions getImageSize(int timepointId) {
            RandomAccessibleInterval slice = FusionImageLoader.this.sliceLoader.load(String.format(FusionImageLoader.this.pattern, timepointId, this.channelId, 0));
            return new FinalDimensions(new long[]{slice.dimension(0), slice.dimension(1), FusionImageLoader.this.numSlices});
        }

        public VoxelDimensions getVoxelSize(int timepointId) {
            return new FinalVoxelDimensions("px", new double[]{1.0, 1.0, 1.0});
        }
    }

    public static class Gray8ImagePlusLoader
    implements SliceLoader<UnsignedByteType> {
        @Override
        public RandomAccessibleInterval<UnsignedByteType> load(String fn) {
            return ImageJFunctions.wrapByte((ImagePlus)new ImagePlus(fn));
        }
    }

    public static class Gray16ImagePlusLoader
    implements SliceLoader<UnsignedShortType> {
        @Override
        public RandomAccessibleInterval<UnsignedShortType> load(String fn) {
            return ImageJFunctions.wrapShort((ImagePlus)new ImagePlus(fn));
        }
    }

    public static class Gray32ImagePlusLoader
    implements SliceLoader<FloatType> {
        @Override
        public RandomAccessibleInterval<FloatType> load(String fn) {
            return ImageJFunctions.wrapFloat((ImagePlus)new ImagePlus(fn));
        }
    }

    public static class ArrayImgLoader<T extends RealType<T> & NativeType<T>>
    implements SliceLoader<T> {
        final ImgOpener opener = new ImgOpener();
        final ArrayImgFactory<T> factory = new ArrayImgFactory();
        final T type;

        public ArrayImgLoader(T type) {
            this.type = type;
        }

        @Override
        public RandomAccessibleInterval<T> load(String fn) {
            try {
                System.out.println(fn);
                return (RandomAccessibleInterval)this.opener.openImgs(fn, this.factory, this.type).get(0);
            }
            catch (ImgIOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static interface SliceLoader<T> {
        public RandomAccessibleInterval<T> load(String var1);
    }
}

