/*
 * Decompiled with CFR 0.152.
 */
package numericalMethods.calculus.minimizing;

import java.io.Serializable;
import numericalMethods.function.nmDoubleParametrized;
import numericalMethods.function.nmDoubleValued;

public final class nmBrent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double CGOLD = 0.381966;
    private static final double ZEPS = 1.0E-10;
    private static double ITMAX = 100.0;

    public static double getITMAX() {
        return ITMAX;
    }

    public static void setITMAX(double v) {
        ITMAX = v;
    }

    private static final double copySign(double value, double signDonor) {
        return signDonor <= 0.0 ? -Math.abs(value) : Math.abs(value);
    }

    public static final void search(double[] t, double[] X, nmDoubleValued f, double tol) {
        nmBrent.search(t[0], t[1], t[2], X, f, tol);
    }

    public static final void search(double ax, double bx, double cx, double[] X, nmDoubleValued f, double tol) {
        double fw;
        double fx;
        double v;
        nmDoubleParametrized F = (nmDoubleParametrized)((Object)f);
        double d = 0.0;
        double e = 0.0;
        double a = ax >= cx ? cx : ax;
        double b = ax <= cx ? cx : ax;
        double w = v = bx;
        double x = v;
        F.setDoubleParameter(x);
        double fv = fx = f.getDoubleValue();
        double inValue = fw = fx;
        int iter = 1;
        while ((double)iter <= ITMAX) {
            double u;
            double xm = 0.5 * (a + b);
            double tol1 = tol * Math.abs(x) + 1.0E-10;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a)) {
                X[0] = x;
                X[1] = fx;
                return;
            }
            if (Math.abs(e) > tol1) {
                double r = (x - w) * (fx - fv);
                double q = (x - v) * (fx - fw);
                double p = (x - v) * q - (x - w) * r;
                if ((q = 2.0 * (q - r)) > 0.0) {
                    p = -p;
                }
                q = Math.abs(q);
                double etmp = e;
                e = d;
                if (Math.abs(p) >= Math.abs(0.5 * q * etmp) || p < q * (a - x) || p >= q * (b - x)) {
                    e = x < xm ? b - x : a - x;
                    d = 0.381966 * e;
                } else {
                    d = p / q;
                    u = x + d;
                    if (u - a < tol2 || b - u < tol2) {
                        d = nmBrent.copySign(tol1, xm - x);
                    }
                }
            } else {
                e = x < xm ? b - x : a - x;
                d = 0.381966 * e;
            }
            u = Math.abs(d) < tol1 ? x + nmBrent.copySign(tol1, d) : x + d;
            F.setDoubleParameter(u);
            double fu = f.getDoubleValue();
            if (fu <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                w = x;
                x = u;
                fv = fw;
                fw = fx;
                fx = fu;
            } else {
                if (u < x) {
                    a = u;
                } else {
                    b = u;
                }
                if (fu <= fw || w == x) {
                    v = w;
                    w = u;
                    fv = fw;
                    fw = fu;
                } else if (fu <= fv || v == x || v == w) {
                    v = u;
                    fv = fu;
                }
            }
            ++iter;
        }
        System.out.println("Too many iteration in BRENT\n");
        X[0] = x;
        X[1] = fx;
        if (fx > inValue) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(" proc Brent failed to decrease center value! ").append(ax).append(" ").append(bx).append(" ").append(cx))));
        }
    }
}

