/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.util;

import java.awt.Frame;
import java.io.IOException;
import java.io.OutputStream;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.log.LogService;

public abstract class UpdaterUserInterface {
    protected static UpdaterUserInterface ui = new StderrInterface();

    public abstract void error(String var1);

    public abstract void info(String var1, String var2);

    public abstract void log(String var1);

    public abstract void debug(String var1);

    public abstract OutputStream getOutputStream();

    public abstract void showStatus(String var1);

    public abstract void handleException(Throwable var1);

    public abstract boolean isBatchMode();

    public abstract int optionDialog(String var1, String var2, Object[] var3, int var4);

    public abstract boolean promptYesNo(String var1, String var2);

    public abstract String getPref(String var1);

    public abstract void setPref(String var1, String var2);

    public abstract void savePreferences();

    public abstract void openURL(String var1) throws IOException;

    public abstract String getString(String var1);

    public abstract String getPassword(String var1);

    public abstract void addWindow(Frame var1);

    public abstract void removeWindow(Frame var1);

    public static void set(UpdaterUserInterface ui) {
        UpdaterUserInterface.ui = ui;
    }

    public static final UpdaterUserInterface get() {
        return ui;
    }

    protected static class StderrInterface
    extends UpdaterUserInterface {
        protected LogService log = UpdaterUtil.getLogService();

        @Override
        public void error(String message) {
            this.log.error((Object)message);
        }

        @Override
        public void info(String message, String title) {
            this.log.info((Object)(title + ": " + message));
        }

        @Override
        public void log(String message) {
            this.log.info((Object)message);
        }

        @Override
        public void debug(String message) {
            this.log.debug((Object)message);
        }

        @Override
        public OutputStream getOutputStream() {
            return System.err;
        }

        @Override
        public void showStatus(String message) {
            this.log.info((Object)message);
        }

        @Override
        public void handleException(Throwable exception) {
            this.log.error(exception);
        }

        @Override
        public boolean isBatchMode() {
            return true;
        }

        @Override
        public int optionDialog(String message, String title, Object[] options, int def) {
            throw new RuntimeException("TODO");
        }

        @Override
        public String getPref(String key) {
            return null;
        }

        @Override
        public void setPref(String key, String value) {
        }

        @Override
        public void savePreferences() {
            throw new RuntimeException("TODO");
        }

        @Override
        public void openURL(String url) {
            this.log.info((Object)("Open URL " + url));
        }

        @Override
        public String getString(String title) {
            System.err.print(title + " ");
            return new String(System.console().readLine());
        }

        @Override
        public String getPassword(String title) {
            System.err.print(title + " ");
            return new String(System.console().readPassword());
        }

        @Override
        public void addWindow(Frame window) {
        }

        @Override
        public void removeWindow(Frame window) {
        }

        @Override
        public boolean promptYesNo(String message, String title) {
            System.err.println(title + " " + message);
            String answer = new String(System.console().readLine());
            return answer.toLowerCase().startsWith("y");
        }
    }
}

