/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.display.interactive;

import net.imagej.autoscale.AutoscaleService;
import net.imagej.autoscale.DataRange;
import net.imagej.command.InteractiveImageCommand;
import net.imagej.display.DatasetView;
import net.imagej.widget.HistogramBundle;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.histogram.BinMapper1d;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.histogram.Real1dBinMapper;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.widget.Button;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Adjust"), @Menu(label="Brightness/Contrast...", accelerator="shift ^C", weight=0.0)}, iconPath="/icons/commands/contrast.png", headless=true, initializer="initValues", attrs={@Attr(name="no-legacy")})
public class BrightnessContrast<T extends RealType<T>>
extends InteractiveImageCommand {
    private static final int SLIDER_MIN = 0;
    private static final int SLIDER_MAX = 100;
    private static final String S_MIN = "0";
    private static final String S_MAX = "100";
    private static final int MAX_POWER = 4;
    private static final String PLANE = "Plane";
    private static final String GLOBAL = "Global";
    @Parameter
    private AutoscaleService autoscaleService;
    @Parameter(type=ItemIO.BOTH, callback="viewChanged")
    private DatasetView view;
    @Parameter(label="Histogram")
    private HistogramBundle bundle;
    @Parameter(label="Minimum", persist=false, callback="minMaxChanged", style="scroll bar")
    private double min = Double.NaN;
    @Parameter(label="Maximum", persist=false, callback="minMaxChanged", style="scroll bar")
    private double max = Double.NaN;
    @Parameter(callback="brightnessContrastChanged", persist=false, style="scroll bar", min="0", max="100")
    private int brightness;
    @Parameter(callback="brightnessContrastChanged", persist=false, style="scroll bar", min="0", max="100")
    private int contrast;
    @Parameter(label="Default", callback="setDefault")
    private Button defaultButton;
    @Parameter(label="Range:", style="radioButtonHorizontal", choices={"Plane", "Global"}, callback="viewChanged")
    String rangeChoice = "Plane";
    private double dataMin;
    private double dataMax;
    private double initialMin;
    private double initialMax;

    public BrightnessContrast() {
        super(new String[]{"view"});
    }

    public void run() {
        this.updateDisplay();
    }

    public DatasetView getView() {
        return this.view;
    }

    public void setView(DatasetView view) {
        this.view = view;
    }

    public double getMinimum() {
        return this.min;
    }

    public void setMinimum(double min) {
        this.min = min;
    }

    public double getMaximum() {
        return this.max;
    }

    public void setMaximum(double max) {
        this.max = max;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public void setBrightness(int brightness) {
        this.brightness = brightness;
    }

    public int getContrast() {
        return this.contrast;
    }

    public void setContrast(int contrast) {
        this.contrast = contrast;
    }

    protected void initValues() {
        this.viewChanged();
    }

    protected void viewChanged() {
        Object interval = this.rangeChoice.equals(PLANE) ? this.view.xyPlane() : this.view.getData().getImgPlus();
        this.computeDataMinMax((RandomAccessibleInterval<? extends RealType<?>>)interval);
        this.computeInitialMinMax();
        if (Double.isNaN(this.min)) {
            this.min = this.initialMin;
        }
        if (Double.isNaN(this.max)) {
            this.max = this.initialMax;
        }
        this.computeBrightnessContrast();
    }

    protected void minMaxChanged() {
        this.computeBrightnessContrast();
    }

    protected void brightnessContrastChanged() {
        this.computeMinMax();
    }

    protected void setDefault() {
        this.brightness = 50;
        this.contrast = 50;
        this.brightnessContrastChanged();
        this.updateDisplay();
    }

    private void computeDataMinMax(RandomAccessibleInterval<? extends RealType<?>> img) {
        DataRange range = this.autoscaleService.getDefaultRandomAccessRange(img);
        this.dataMin = range.getMin();
        this.dataMax = range.getMax();
        MutableModuleItem minItem = this.getInfo().getMutableInput("min", Double.class);
        minItem.setSoftMinimum((Object)this.dataMin);
        minItem.setSoftMaximum((Object)this.dataMax);
        MutableModuleItem maxItem = this.getInfo().getMutableInput("max", Double.class);
        maxItem.setSoftMinimum((Object)this.dataMin);
        maxItem.setSoftMaximum((Object)this.dataMax);
        IterableInterval iterable = Views.iterable(img);
        Real1dBinMapper mapper = new Real1dBinMapper(this.dataMin, this.dataMax, 256L, false);
        Histogram1d histogram = new Histogram1d((Iterable)iterable, (BinMapper1d)mapper);
        if (this.bundle == null) {
            this.bundle = new HistogramBundle(histogram);
        } else {
            this.bundle.setHistogram(0, histogram);
        }
        this.bundle.setDataMinMax(this.dataMin, this.dataMax);
        this.log().debug((Object)("computeDataMinMax: dataMin=" + this.dataMin + ", dataMax=" + this.dataMax));
    }

    private void computeInitialMinMax() {
        this.initialMin = this.view.getChannelMin(0);
        this.initialMax = this.view.getChannelMax(0);
        this.log().debug((Object)("computeInitialMinMax: initialMin=" + this.initialMin + ", initialMax=" + this.initialMax));
    }

    private void computeMinMax() {
        double bUnit = (double)(this.brightness - 0) / 100.0;
        double cUnit = (double)(this.contrast - 0) / 100.0;
        double b = 2.0 * bUnit - 1.0;
        double m = Math.exp(8.0 * cUnit - 4.0);
        double minUnit = -b / m;
        double maxUnit = (1.0 - b) / m;
        this.min = (this.dataMax - this.dataMin) * minUnit + this.dataMin;
        this.max = (this.dataMax - this.dataMin) * maxUnit + this.dataMin;
        this.bundle.setTheoreticalMinMax(this.min, this.max);
        this.log().debug((Object)("computeMinMax: bUnit=" + bUnit + ", cUnit=" + cUnit + ", b=" + b + ", m=" + m + ", minUnit=" + minUnit + ", maxUnit=" + maxUnit + ", min=" + this.min + ", max=" + this.max));
    }

    private void computeBrightnessContrast() {
        double minUnit = (this.min - this.dataMin) / (this.dataMax - this.dataMin);
        double maxUnit = (this.max - this.dataMin) / (this.dataMax - this.dataMin);
        double m = 1.0 / (maxUnit - minUnit);
        double b = -m * minUnit;
        double bUnit = (b + 1.0) / 2.0;
        double cUnit = (Math.log(m) + 4.0) / 8.0;
        this.brightness = (int)(100.0 * bUnit + 0.0 + 0.5);
        this.contrast = (int)(100.0 * cUnit + 0.0 + 0.5);
        this.bundle.setTheoreticalMinMax(this.min, this.max);
        this.log().debug((Object)("computeBrightnessContrast: minUnit=" + minUnit + ", maxUnit=" + maxUnit + ", m=" + m + ", b=" + b + ", bUnit=" + bUnit + ", cUnit=" + cUnit + ", brightness=" + this.brightness + ", contrast=" + this.contrast));
    }

    private void updateDisplay() {
        this.view.setChannelRanges(this.min, this.max);
        this.view.getProjector().map();
        this.view.update();
    }
}

