/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import view5d.APoint;
import view5d.ImageCanvas;
import view5d.My3DData;
import view5d.MyMenuProcessor;
import view5d.PositionLabel;
import view5d.View5D;

public class ImgPanel
extends Panel
implements MouseWheelListener {
    static final long serialVersionUID = 1L;
    Container applet;
    ImgPanel DataPanel = null;
    My3DData data3d;
    public ImageCanvas c1;
    public ImageCanvas c2;
    public ImageCanvas c3;
    public PositionLabel label;
    boolean ROIstarted = false;
    APoint DraggedMarker = null;
    APoint SavedMarker = null;
    MenuBar MyMenu;
    boolean ScrollbarPresent = false;
    double[] OldOffset;

    public void InitScaling() {
        this.c2.InitScaling();
        this.c3.InitScaling();
        this.c1.InitScaling();
        this.c3.CalcPrev();
        this.c3.UpdateAllNoCoord();
    }

    public void OwnerPanel(ImgPanel owner) {
        this.DataPanel = owner;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() < 0) {
            this.data3d.nextTime(1);
        } else {
            this.data3d.nextTime(-1);
        }
        this.AdjustOffset();
        this.c1.UpdateAll();
    }

    public void CheckScrollBar() {
        if (this.data3d.Times > 1) {
            Scrollbar Slider = this.label.TimeScrollbar;
            if (!this.ScrollbarPresent) {
                Slider = new Scrollbar(1, 0, 1, 0, this.data3d.Times);
                Slider.setBackground(new Color(70, 70, 200));
                this.ScrollbarPresent = true;
                this.label.TimeScrollbar = Slider;
                this.add("East", Slider);
                this.data3d.TrackDirection = 4;
                if (this.data3d.SizeZ > 1) {
                    this.data3d.SearchZ = 1;
                    this.data3d.COMZ = 1;
                }
                Slider.setBlockIncrement(this.data3d.Times / 10 + 1);
                Slider.addAdjustmentListener(this.c1);
                Slider.addMouseWheelListener(this);
                Slider.setVisible(true);
            } else {
                Slider.setMaximum(this.data3d.Times);
                Slider.setBlockIncrement(this.data3d.Times / 10 + 1);
                Slider.setVisible(true);
            }
            Slider.doLayout();
            this.doLayout();
        }
    }

    public void setPositions(APoint ap) {
        if (ap != null) {
            APoint p = this.data3d.LimitPoint(ap);
            this.c2.PositionValue = (int)(p.coord[0] + 0.5);
            this.c3.PositionValue = (int)(p.coord[1] + 0.5);
            this.c1.PositionValue = (int)(p.coord[2] + 0.5);
            if ((int)(p.coord[3] + 0.5) >= 0 && (int)(p.coord[3] + 0.5) < this.data3d.Elements) {
                this.data3d.setElement((int)(p.coord[3] + 0.5));
            }
            if ((int)(p.coord[4] + 0.5) >= 0 && (int)(p.coord[4] + 0.5) < this.data3d.Times) {
                this.data3d.setTime((int)(p.coord[4] + 0.5));
            }
        }
    }

    public float[] getPositions() {
        float[] pos = new float[]{(float)this.c2.PositionValue, (float)this.c3.PositionValue, (float)this.c1.PositionValue, this.data3d.ActiveElement, this.data3d.ActiveTime};
        return pos;
    }

    public void RememberOffset() {
        this.OldOffset = this.data3d.ElementAt((int)this.data3d.ActiveElement).DisplayOffset;
    }

    public void LimitPositions() {
        if (this.c1.PositionValue < 0.0) {
            this.c1.PositionValue = 0.0;
        }
        if (this.c2.PositionValue < 0.0) {
            this.c2.PositionValue = 0.0;
        }
        if (this.c3.PositionValue < 0.0) {
            this.c3.PositionValue = 0.0;
        }
        if (this.c1.PositionValue >= (double)this.c1.getMaxPos()) {
            this.c1.PositionValue = this.c1.getMaxPos() - 1;
        }
        if (this.c2.PositionValue >= (double)this.c2.getMaxPos()) {
            this.c2.PositionValue = this.c2.getMaxPos() - 1;
        }
        if (this.c3.PositionValue >= (double)this.c3.getMaxPos()) {
            this.c3.PositionValue = this.c3.getMaxPos() - 1;
        }
    }

    public void AdjustOffset() {
        double[] NewOffset = this.data3d.ElementAt((int)this.data3d.ActiveElement).DisplayOffset;
        if (this.OldOffset != null) {
            this.c2.PositionValue += (double)((int)(this.OldOffset[0] - NewOffset[0]));
            this.c3.PositionValue += (double)((int)(this.OldOffset[1] - NewOffset[1]));
            this.c1.PositionValue += (double)((int)(this.OldOffset[2] - NewOffset[2]));
            this.LimitPositions();
        }
    }

    public void AdvancePos() {
        switch (this.data3d.TrackDirection) {
            case 0: {
                this.c2.PositionValue += 1.0;
                this.c2.PositionValue %= (double)this.c2.getMaxPos();
                break;
            }
            case 1: {
                this.c3.PositionValue += 1.0;
                this.c3.PositionValue %= (double)this.c3.getMaxPos();
                break;
            }
            case 2: {
                this.c1.PositionValue += 1.0;
                this.c1.PositionValue %= (double)this.c1.getMaxPos();
                break;
            }
            case 3: {
                this.data3d.setElement((this.data3d.ActiveElement + 1) % this.data3d.Elements);
            }
            case 4: {
                this.data3d.setTime((this.data3d.ActiveTime + 1) % this.data3d.Times);
            }
        }
    }

    void AddPopupMenu(Menu aMenu, boolean doSubMenu) {
        if (doSubMenu) {
            this.c1.MyPopupMenu.add(aMenu);
        } else {
            this.MyMenu.add(aMenu);
        }
    }

    public ImgPanel(Container app, My3DData mydata) {
        this.applet = app;
        this.setLayout(new BorderLayout());
        Panel grid = new Panel();
        grid.setLayout(new GridLayout(2, 2));
        this.add("Center", grid);
        this.data3d = mydata;
        try {
            this.c1 = new ImageCanvas(this.applet, this, this.data3d, 2, "XY");
            this.c1.AspectLocked.setState(true);
            this.c2 = new ImageCanvas(this.applet, this, this.data3d, 0, "ZY");
            this.c3 = new ImageCanvas(this.applet, this, this.data3d, 1, "XZ");
        }
        catch (Exception e) {
            this.applet.add("South", new Label("Caught Exception:" + e.getMessage()));
            this.applet.setVisible(true);
            e.printStackTrace();
        }
        this.c2.TakeOtherCanvas1(this.c1);
        this.c2.TakeOtherCanvas2(this.c3);
        this.c3.TakeOtherCanvas1(this.c2);
        this.c3.TakeOtherCanvas2(this.c1);
        this.c1.TakeOtherCanvas1(this.c2);
        this.c1.TakeOtherCanvas2(this.c3);
        grid.add(this.c1);
        grid.add(this.c2);
        grid.add(this.c3);
        this.MyMenu = new MenuBar();
        boolean doSubMenu = this.applet instanceof View5D;
        if (!(this.applet instanceof View5D) && System.getProperty("os.name").startsWith("Mac")) {
            doSubMenu = true;
        }
        Menu SubMenu = new Menu("General", false);
        this.AddPopupMenu(SubMenu, doSubMenu);
        MenuItem tmp = new MenuItem("Help [? or F1]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '?'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Exit [$]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '$'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Readmode (Complex only) [^ or F2]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '^'));
        SubMenu.add(tmp);
        SubMenu = new Menu("Import/Export", false);
        this.AddPopupMenu(SubMenu, doSubMenu);
        tmp = new MenuItem("Reload data [l]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'l'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Reload markers [L]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'L'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Export this element [X] (only in ImageJ)");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'X'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Spawn Viewer [s]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 's'));
        SubMenu.add(tmp);
        SubMenu = new Menu("Measuring & Markers", false);
        this.AddPopupMenu(SubMenu, doSubMenu);
        tmp = new MenuItem("Set Axes Units and Scalings [N]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'N'));
        SubMenu.add(tmp);
        tmp = new MenuItem("set marker [m]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'm'));
        SubMenu.add(tmp);
        tmp = new MenuItem("set split marker [\\]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '\\'));
        SubMenu.add(tmp);
        tmp = new MenuItem("delete active marker [M]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'M'));
        SubMenu.add(tmp);
        tmp = new MenuItem("delete trailing markers [Q]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'Q'));
        SubMenu.add(tmp);
        tmp = new MenuItem("tag/untag marker [&]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '&'));
        SubMenu.add(tmp);
        tmp = new MenuItem("new marker list [k]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'k'));
        SubMenu.add(tmp);
        tmp = new MenuItem("delete marker list [K]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'K'));
        SubMenu.add(tmp);
        tmp = new MenuItem("activate next marker [0]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '0'));
        SubMenu.add(tmp);
        tmp = new MenuItem("activate previous marker [9]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '9'));
        SubMenu.add(tmp);
        tmp = new MenuItem("activate next marker list [j]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'j'));
        SubMenu.add(tmp);
        tmp = new MenuItem("activate previous marker list [J]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'J'));
        SubMenu.add(tmp);
        tmp = new MenuItem("toggles the marker color of current list [w]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'w'));
        SubMenu.add(tmp);
        tmp = new MenuItem("auto-track marker [W]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'W'));
        SubMenu.add(tmp);
        tmp = new MenuItem("align display to marker track [|]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '|'));
        SubMenu.add(tmp);
        tmp = new MenuItem("reset track alignments  [{]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '{'));
        SubMenu.add(tmp);
        tmp = new MenuItem("subtract track from data [#]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '#'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Show detailed marker menu [n]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'n'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Marker list property menu [}]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '}'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Reload markers [L]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'L'));
        SubMenu.add(tmp);
        SubMenu = new Menu("Color", false);
        this.AddPopupMenu(SubMenu, doSubMenu);
        tmp = new MenuItem("Toggle multicolor overlay [C]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'C'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Next color map for element [c]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'c'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Next inverse color map [d]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'd'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Toggle over/underflow [o]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'o'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Toggle logarithmic scale [O]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'O'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Adjust threshold element [t]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 't'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Adjust all thresholds [T]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'T'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Coarse raise lower display threshold [1]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '1'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Coarse decrease lower display threshold [2]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '2'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Coarse raise upper display threshold [3]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '3'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Coarse decrease upper display threshold [4], use 5-8 for fine tuning");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '4'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Transfer display thresholds to data thresholds [!]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '!'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Advance element [e]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'e'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Devance element [E]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'E'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Define underflow gate [u]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'u'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Toggle defined underflow gate [U]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'U'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Red glow colormap [R]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'R'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Gray colormap [G]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'G'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Rainbow colormap [B]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'B'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Red colomap [r]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'r'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Green colormap [g]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'g'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Blue colormap [b]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'b'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Show in overlay [v]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'v'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Show in multiplicative Overlay [V]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'V'));
        SubMenu.add(tmp);
        SubMenu = new Menu("ROIs", false);
        this.AddPopupMenu(SubMenu, doSubMenu);
        tmp = new MenuItem("Toggle rectangular ROIs [S]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'S'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Extract with ROI [Y]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'Y'));
        SubMenu.add(tmp);
        SubMenu = new Menu("Processing", false);
        this.AddPopupMenu(SubMenu, doSubMenu);
        tmp = new MenuItem("Clone element with upcast to float [f]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'f'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Clone displayed element as short [F]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'f'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Mathematically add gate element [+]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '+'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Mathematically subtract from gate element [-]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '-'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Mathematically multiply with gate element [*]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '*'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Ratio with gate element [/]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '/'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Define this element offset from ROI mean [_]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, '_'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Delete active element [D]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'D'));
        SubMenu.add(tmp);
        SubMenu = new Menu("Histograms", false);
        this.AddPopupMenu(SubMenu, doSubMenu);
        tmp = new MenuItem("Select for histogram X-axis [x]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'x'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Select for histogram Y-axis [y]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'y'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Select for histogram Z-axis [z]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'z'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Histogram (<= 3 dimensional) / apply histogram ROI to data [h]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'h'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Force new histogram window [H]");
        tmp.addActionListener(new MyMenuProcessor(this.c1, 'H'));
        SubMenu.add(tmp);
        this.label = new PositionLabel("View5D initialization.", this.c1, this.c2, this.c3, this.data3d);
        grid.add(this.label);
        this.c1.ConnectLabel(this.label);
        this.c2.ConnectLabel(this.label);
        this.c3.ConnectLabel(this.label);
        this.setBounds(0, 0, 20, 20);
        this.c1.UpdateAllNoCoord();
    }
}

