/*
 * Decompiled with CFR 0.152.
 */
package levelsets.algorithm;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public abstract class DeferredArray3D {
    private final int xdim;
    private final int ydim;
    private final int zdim;
    private final int xtiles;
    private final int ytiles;
    private final int ztiles;
    protected final int tilesize;
    protected final Object[] tiles;

    public DeferredArray3D(int xdim, int ydim, int zdim, int tilesize) {
        this.tilesize = tilesize;
        this.xdim = xdim;
        this.ydim = ydim;
        this.zdim = zdim;
        int xtiles = xdim / tilesize;
        if (xdim % tilesize > 0) {
            ++xtiles;
        }
        this.xtiles = xtiles;
        int ytiles = ydim / tilesize;
        if (ydim % tilesize > 0) {
            ++ytiles;
        }
        this.ytiles = ytiles;
        int ztiles = zdim / tilesize;
        if (zdim % tilesize > 0) {
            ++ztiles;
        }
        this.ztiles = ztiles;
        this.tiles = new Object[xtiles * ytiles * ztiles];
    }

    public final int getTileSize() {
        return this.tilesize;
    }

    protected final Object getTile(int x, int y, int z, boolean create) {
        this.checkBounds(x, y, z);
        int x_tile = x / this.tilesize;
        int y_tile = y / this.tilesize;
        int z_tile = z / this.tilesize;
        int offset = x_tile + y_tile * this.xtiles + z_tile * this.xtiles * this.ytiles;
        Object tile = this.tiles[offset];
        if (tile == null && create) {
            this.tiles[offset] = this.createTile(this.tilesize);
            return this.tiles[offset];
        }
        return tile;
    }

    public final int getXLength() {
        return this.xdim;
    }

    public final int getYLength() {
        return this.ydim;
    }

    public final int getZLength() {
        return this.zdim;
    }

    public final void dumpToFile(String path) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(new File(path)));
            out.write(this.getXLength() + " " + this.getYLength() + " " + this.getZLength());
            out.newLine();
            out.newLine();
            for (int z = 0; z < this.getZLength(); ++z) {
                for (int y = 0; y < this.getYLength(); ++y) {
                    for (int x = 0; x < this.getXLength(); ++x) {
                        out.write(this.getAsString(x, y, z) + " ");
                    }
                    out.newLine();
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private final void checkBounds(int x, int y, int z) {
        if (x < 0 || x > this.xdim - 1 || y < 0 || y > this.ydim - 1 || z < 0 || z > this.zdim - 1) {
            throw new ArrayIndexOutOfBoundsException("At index : (" + x + ", " + y + ", " + z + ")");
        }
    }

    protected abstract Object createTile(int var1);

    protected abstract String getAsString(int var1, int var2, int var3);
}

