/*
 * Decompiled with CFR 0.152.
 */
package levelsets.filter;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import levelsets.filter.MorphologicalOperator;

public class GreyValueErosion
extends MorphologicalOperator {
    public GreyValueErosion(boolean[][] mask) {
        super(mask);
    }

    @Override
    protected final void processPosition(int x, int y, WritableRaster raster, Raster in) {
        int minValue = Integer.MAX_VALUE;
        for (int i = 0; i < this.mask.length; ++i) {
            for (int j = 0; j < this.mask[0].length; ++j) {
                if (!this.mask[i][j]) continue;
                in.getPixel(i + x + 1 - this.center, j + y + 1 - this.center, this.pixel);
                if (this.pixel[0] >= minValue) continue;
                minValue = this.pixel[0];
            }
        }
        this.pixel[1] = this.pixel[2] = minValue;
        this.pixel[0] = this.pixel[2];
        raster.setPixel(x, y, this.pixel);
    }

    @Override
    protected final void processPosition(int x, int y, int width, short[] source, short[] target) {
        short minValue = Short.MAX_VALUE;
        for (int i = 0; i < this.mask.length; ++i) {
            for (int j = 0; j < this.mask[0].length; ++j) {
                int pos;
                if (!this.mask[i][j] || source[pos = i + x + 1 - this.center + (j + y + 1 - this.center) * width] >= minValue) continue;
                minValue = source[pos];
            }
        }
        target[x + y * width] = minValue;
    }
}

