/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.path.Path;

public class SemicolonOperator
implements Expression {
    private List<Expression> qs;

    public SemicolonOperator(List<Expression> qs) {
        this.qs = qs;
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path path, PathOutput output, boolean requirePath) throws JsonQueryException {
        if (this.qs.isEmpty()) {
            return;
        }
        for (Expression q : this.qs.subList(0, this.qs.size() - 1)) {
            q.apply(scope, in, out -> {});
        }
        this.qs.get(this.qs.size() - 1).apply(scope, in, path, output, requirePath);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String sep = "";
        for (Expression q : this.qs) {
            builder.append(sep);
            builder.append(q);
            sep = "; ";
        }
        return builder.toString();
    }
}

