/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import net.imglib2.cache.CacheLoader;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.label.LabelUtils;
import net.imglib2.type.label.LongMappedAccess;
import net.imglib2.type.label.LongMappedAccessData;
import net.imglib2.type.label.VolatileLabelMultisetArray;
import net.imglib2.util.Intervals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLabelMultisetLoader
implements CacheLoader<Long, Cell<VolatileLabelMultisetArray>> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CellGrid grid;
    private final long invalidLabel;

    public AbstractLabelMultisetLoader(CellGrid grid) {
        this(grid, -2L);
    }

    public AbstractLabelMultisetLoader(CellGrid grid, long invalidLabel) {
        this.grid = grid;
        this.invalidLabel = invalidLabel;
    }

    protected abstract byte[] getData(long ... var1);

    public Cell<VolatileLabelMultisetArray> get(Long key) {
        int numDimensions = this.grid.numDimensions();
        long[] cellMin = new long[numDimensions];
        int[] cellSize = new int[numDimensions];
        long[] gridPosition = new long[numDimensions];
        int[] cellDimensions = new int[numDimensions];
        this.grid.cellDimensions(cellDimensions);
        this.grid.getCellDimensions(key.longValue(), cellMin, cellSize);
        for (int i = 0; i < numDimensions; ++i) {
            gridPosition[i] = cellMin[i] / (long)cellDimensions[i];
        }
        byte[] bytes = this.getData(gridPosition);
        Objects.requireNonNull(bytes, "Expecting non-null byte array");
        LOG.debug("Got {} bytes from loader.", (Object)bytes.length);
        LOG.trace("Got bytes from loader: {}", (Object)bytes);
        int n = (int)Intervals.numElements((int[])cellSize);
        return new Cell(cellSize, cellMin, (Object)LabelUtils.fromBytes(bytes, n));
    }

    public static int argMaxListSizeInBytes(int numEntries) {
        return 8 * numEntries + 4;
    }

    public static int listOffsetsSizeInBytes(int numOffsets) {
        return 4 * numOffsets;
    }

    public static VolatileLabelMultisetArray dummy(int numElements, long label) {
        LongMappedAccessData store = LongMappedAccessData.factory.createStorage(16L);
        LongMappedAccess access = store.createAccess();
        access.putInt(1, 0);
        access.putLong(label, 4);
        access.putInt(1, 12);
        int[] data = new int[numElements];
        long[] argMax = new long[]{label};
        return new VolatileLabelMultisetArray(data, store, true, argMax);
    }
}

