/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.shm;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import org.apposed.appose.SharedMemory;
import org.apposed.appose.ShmFactory;
import org.apposed.appose.shm.CLibrary;
import org.apposed.appose.shm.LibRt;
import org.apposed.appose.shm.ShmBase;
import org.apposed.appose.shm.Shms;
import org.apposed.appose.util.Platforms;

public class ShmLinux
implements ShmFactory {
    @Override
    public SharedMemory create(String name, boolean create, long rsize) {
        if (!Platforms.isLinux()) {
            return null;
        }
        return new SharedMemoryLinux(name, create, rsize);
    }

    private static class SharedMemoryLinux
    extends ShmBase<Integer> {
        private SharedMemoryLinux(String name, boolean create, long rsize) {
            super(SharedMemoryLinux.prepareShm(name, create, rsize));
        }

        @Override
        protected void doUnlink() {
            LibRtOrC.shm_unlink(this.name());
        }

        @Override
        protected void doClose() {
            if (this.info.pointer != Pointer.NULL && LibRtOrC.munmap(this.info.pointer, this.size()) == -1) {
                throw new RuntimeException("munmap failed. Errno: " + Native.getLastError());
            }
            if (LibRtOrC.close((Integer)this.info.handle) == -1) {
                throw new RuntimeException("close failed. Errno: " + Native.getLastError());
            }
        }

        private static ShmBase.ShmInfo<Integer> prepareShm(String name, boolean create, long rsize) {
            String shmName;
            long prevSize;
            if (name == null) {
                while ((prevSize = SharedMemoryLinux.getSHMSize(shmName = Shms.makeFilename(14, "/psm_"))) >= 0L) {
                }
            } else {
                shmName = Shms.withLeadingSlash(name);
                prevSize = SharedMemoryLinux.getSHMSize(shmName);
            }
            Shms.checkSize(shmName, prevSize, rsize);
            int shmFd = LibRtOrC.shm_open(shmName, Shms.O_CREAT | Shms.O_RDWR, 438);
            if (shmFd < 0) {
                throw new RuntimeException("shm_open failed, errno: " + Native.getLastError());
            }
            if (create && LibRtOrC.ftruncate(shmFd, rsize) == -1) {
                LibRtOrC.close(shmFd);
                throw new RuntimeException("ftruncate failed, errno: " + Native.getLastError());
            }
            long shmSize = SharedMemoryLinux.getSHMSize(shmFd);
            Pointer pointer = LibRtOrC.mmap(Pointer.NULL, shmSize, Shms.PROT_READ | Shms.PROT_WRITE, Shms.MAP_SHARED, shmFd, 0L);
            if (pointer == Pointer.NULL) {
                LibRtOrC.close(shmFd);
                LibRtOrC.shm_unlink(shmName);
                throw new RuntimeException("mmap failed, errno: " + Native.getLastError());
            }
            ShmBase.ShmInfo<Integer> info = new ShmBase.ShmInfo<Integer>();
            info.name = Shms.withoutLeadingSlash(shmName);
            info.rsize = rsize;
            info.size = shmSize;
            info.pointer = pointer;
            info.handle = shmFd;
            info.unlinkOnClose = create;
            return info;
        }

        private static long getSHMSize(String name) {
            int shmFd = LibRtOrC.shm_open(name, Shms.O_RDONLY, 448);
            if (shmFd < 0) {
                return -1L;
            }
            return SharedMemoryLinux.getSHMSize(shmFd);
        }

        private static long getSHMSize(int shmFd) {
            if (shmFd < 0) {
                throw new RuntimeException("Invalid shmFd. It should be bigger than 0.");
            }
            long size = LibRtOrC.lseek(shmFd, 0L, 2);
            if (size == -1L) {
                throw new RuntimeException("Failed to get shared memory segment size. Errno: " + Native.getLastError());
            }
            return size;
        }

        private static class LibRtOrC {
            private static boolean useLibRT = true;
            static final int SEEK_SET = 0;
            static final int SEEK_CUR = 1;
            static final int SEEK_END = 2;

            private LibRtOrC() {
            }

            static int shm_open(String name, int oflag, int mode) {
                if (useLibRT) {
                    try {
                        return LibRt.INSTANCE.shm_open(name, oflag, mode);
                    }
                    catch (Exception ex) {
                        useLibRT = false;
                    }
                }
                return CLibrary.INSTANCE.shm_open(name, oflag, mode);
            }

            static long lseek(int fd, long offset, int whence) {
                if (useLibRT) {
                    try {
                        return LibRt.INSTANCE.lseek(fd, offset, whence);
                    }
                    catch (Exception ex) {
                        useLibRT = false;
                    }
                }
                return CLibrary.INSTANCE.lseek(fd, offset, whence);
            }

            static int ftruncate(int fd, long length) {
                if (useLibRT) {
                    try {
                        return LibRt.INSTANCE.ftruncate(fd, length);
                    }
                    catch (Exception ex) {
                        useLibRT = false;
                    }
                }
                return CLibrary.INSTANCE.ftruncate(fd, length);
            }

            static Pointer mmap(Pointer addr, long length, int prot, int flags, int fd, long offset) {
                if (useLibRT) {
                    try {
                        return LibRt.INSTANCE.mmap(addr, length, prot, flags, fd, offset);
                    }
                    catch (Exception ex) {
                        useLibRT = false;
                    }
                }
                return CLibrary.INSTANCE.mmap(addr, length, prot, flags, fd, offset);
            }

            static int munmap(Pointer addr, long length) {
                if (useLibRT) {
                    try {
                        return LibRt.INSTANCE.munmap(addr, length);
                    }
                    catch (Exception ex) {
                        useLibRT = false;
                    }
                }
                return CLibrary.INSTANCE.munmap(addr, length);
            }

            static int close(int fd) {
                if (useLibRT) {
                    try {
                        return LibRt.INSTANCE.close(fd);
                    }
                    catch (Exception ex) {
                        useLibRT = false;
                    }
                }
                return CLibrary.INSTANCE.close(fd);
            }

            static int shm_unlink(String name) {
                if (useLibRT) {
                    try {
                        return LibRt.INSTANCE.shm_unlink(name);
                    }
                    catch (Exception ex) {
                        useLibRT = false;
                    }
                }
                return CLibrary.INSTANCE.shm_unlink(name);
            }
        }
    }
}

