/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import java.util.Optional;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.SparseArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ConstrainedSolver;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.type.IndexSelector;
import org.ojalgo.type.context.NumberContext;

abstract class ActiveSetSolver
extends ConstrainedSolver {
    private static final double RELATIVELY_SMALL = PrimitiveFunction.SQRT.invoke(PrimitiveMath.MACHINE_EPSILON);
    private final IndexSelector myActivator;
    private int myConstraintToInclude = -1;
    private MatrixStore<Double> myInvQC;
    private final PrimitiveDenseStore myIterationX;
    private final PrimitiveDenseStore mySlackI;
    private final PrimitiveDenseStore mySolutionL;

    ActiveSetSolver(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
        int tmpCountVariables = this.countVariables();
        int tmpCountEqualityConstraints = this.countEqualityConstraints();
        int tmpCountInequalityConstraints = this.countInequalityConstraints();
        this.myActivator = new IndexSelector(tmpCountInequalityConstraints);
        this.mySolutionL = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpCountEqualityConstraints + tmpCountInequalityConstraints, 1L);
        this.myIterationX = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpCountVariables, 1L);
        this.mySlackI = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpCountInequalityConstraints, 1L);
    }

    private final void shrink() {
        int[] incl = this.myActivator.getIncluded();
        PrimitiveDenseStore soluL = this.getSolutionL();
        int numbEqus = this.countEqualityConstraints();
        int toExclude = incl[0];
        double maxWeight = PrimitiveMath.ZERO;
        for (int i = 0; i < incl.length; ++i) {
            double tmpValue = soluL.doubleValue((long)(numbEqus + incl[i]));
            double tmpWeight = PrimitiveFunction.ABS.invoke(tmpValue) * PrimitiveFunction.MAX.invoke(-tmpValue, PrimitiveMath.ONE);
            if (!(tmpWeight > maxWeight)) continue;
            maxWeight = tmpWeight;
            toExclude = incl[i];
        }
        this.exclude(toExclude);
    }

    protected boolean checkFeasibility(boolean onlyExcluded) {
        double tmpSlack;
        boolean retVal = true;
        if (!onlyExcluded) {
            if (this.hasEqualityConstraints()) {
                MatrixStore<Double> tmpSE = this.getSE();
                int i = 0;
                while (retVal && (long)i < tmpSE.countRows()) {
                    if (!this.options.feasibility.isZero(tmpSE.doubleValue(i))) {
                        retVal = false;
                    }
                    ++i;
                }
            }
            if (this.hasInequalityConstraints() && this.myActivator.countIncluded() > 0) {
                int[] tmpIncluded = this.myActivator.getIncluded();
                PhysicalStore<Double> tmpSI = this.getSlackI();
                for (int i = 0; retVal && i < tmpIncluded.length; ++i) {
                    tmpSlack = tmpSI.doubleValue(tmpIncluded[i]);
                    if (!(tmpSlack < PrimitiveMath.ZERO) || this.options.feasibility.isZero(tmpSlack)) continue;
                    retVal = false;
                }
            }
        }
        if (this.hasInequalityConstraints() && this.myActivator.countExcluded() > 0) {
            int[] tmpExcluded = this.myActivator.getExcluded();
            PhysicalStore<Double> tmpSI = this.getSlackI();
            for (int e = 0; retVal && e < tmpExcluded.length; ++e) {
                tmpSlack = tmpSI.doubleValue(tmpExcluded[e]);
                if (!(tmpSlack < PrimitiveMath.ZERO) || this.options.feasibility.isZero(tmpSlack)) continue;
                retVal = false;
            }
        }
        return retVal;
    }

    @Override
    protected boolean computeQ(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        boolean retVal = super.computeQ(matrix);
        this.myInvQC = this.getSolutionQ(this.getIterationC());
        return retVal;
    }

    protected int countExcluded() {
        return this.myActivator.countExcluded();
    }

    protected int countIncluded() {
        return this.myActivator.countIncluded();
    }

    protected void exclude(int anIndexToExclude) {
        this.myActivator.exclude(anIndexToExclude);
    }

    @Override
    protected MatrixStore<Double> extractSolution() {
        return super.extractSolution();
    }

    protected int[] getExcluded() {
        return this.myActivator.getExcluded();
    }

    protected int[] getIncluded() {
        return this.myActivator.getIncluded();
    }

    protected int getLastExcluded() {
        return this.myActivator.getLastExcluded();
    }

    protected int getLastIncluded() {
        return this.myActivator.getLastIncluded();
    }

    protected void include(int anIndexToInclude) {
        this.myActivator.include(anIndexToInclude);
    }

    @Override
    protected final boolean initialise(Optimisation.Result kickStarter) {
        Optimisation.Result resultLP;
        boolean usableKickStarter;
        super.initialise(kickStarter);
        boolean feasible = false;
        boolean bl = usableKickStarter = kickStarter != null && kickStarter.getState().isApproximate();
        if (usableKickStarter) {
            this.getSolutionX().fillMatching(kickStarter);
            feasible = kickStarter.getState().isFeasible() ? true : this.checkFeasibility(false);
        }
        if (!feasible && (feasible = (resultLP = this.solveLP()).getState().isFeasible())) {
            this.getSolutionX().fillMatching(resultLP);
            Optional<Access1D<?>> tmpMultipliers = resultLP.getMultipliers();
            if (tmpMultipliers.isPresent()) {
                this.getSolutionL().fillMatching(tmpMultipliers.get());
            } else {
                this.getSolutionL().fillAll(PrimitiveMath.ZERO);
            }
        }
        if (feasible) {
            this.setState(Optimisation.State.FEASIBLE);
            this.resetActivator();
        } else {
            this.setState(Optimisation.State.INFEASIBLE);
            this.getSolutionX().fillAll(PrimitiveMath.ZERO);
        }
        if (this.isDebug()) {
            this.log("Initial solution: {}", this.getSolutionX().copy().asList());
            if (this.getMatrixAE() != null) {
                this.log("Initial E-slack: {}", this.getSE().copy().asList());
            }
            if (this.getMatrixAI() != null) {
                this.log("Initial I-slack: {}", this.getSlackI().copy().asList());
            }
        }
        return this.getState().isFeasible();
    }

    @Override
    protected final boolean needsAnotherIteration() {
        if (this.isDebug()) {
            this.log("\nNeedsAnotherIteration?", new Object[0]);
            this.log(this.myActivator.toString(), new Object[0]);
        }
        int tmpToInclude = -1;
        int tmpToExclude = -1;
        if (this.hasInequalityConstraints() && (tmpToInclude = this.suggestConstraintToInclude()) == -1) {
            tmpToExclude = this.suggestConstraintToExclude();
        }
        if (this.isDebug()) {
            this.log("Suggested to include: {}", tmpToInclude);
            this.log("Suggested to exclude: {}", tmpToExclude);
        }
        if (tmpToExclude == -1) {
            if (tmpToInclude == -1) {
                this.setState(Optimisation.State.OPTIMAL);
                return false;
            }
            this.myActivator.include(tmpToInclude);
            this.setState(Optimisation.State.APPROXIMATE);
            return true;
        }
        if (tmpToInclude == -1) {
            this.exclude(tmpToExclude);
            this.setState(Optimisation.State.APPROXIMATE);
            return true;
        }
        this.exclude(tmpToExclude);
        this.myActivator.include(tmpToInclude);
        this.setState(Optimisation.State.APPROXIMATE);
        return true;
    }

    protected int suggestConstraintToExclude() {
        double tmpVal;
        int retVal = -1;
        int[] tmpIncluded = this.myActivator.getIncluded();
        int tmpLastIncluded = this.myActivator.getLastIncluded();
        int tmpIndexOfLast = -1;
        double tmpMin = Double.POSITIVE_INFINITY;
        Object tmpLI = this.getSolutionL().logical().offsets(this.countEqualityConstraints(), 0).row(tmpIncluded).get();
        if (this.isDebug() && tmpLI.count() > 0L) {
            this.log("Looking for the largest negative lagrange multiplier among these: {}.", tmpLI.copy().asList());
        }
        int i = 0;
        while ((long)i < tmpLI.countRows()) {
            if (tmpIncluded[i] != tmpLastIncluded) {
                tmpVal = tmpLI.doubleValue(i, 0L);
                if (tmpVal < PrimitiveMath.ZERO && tmpVal < tmpMin && !this.options.solution.isZero(tmpVal)) {
                    tmpMin = tmpVal;
                    retVal = i;
                    if (this.isDebug()) {
                        this.log("Best so far: {} @ {} ({}).", tmpMin, retVal, tmpIncluded[i]);
                    }
                }
            } else {
                tmpIndexOfLast = i;
            }
            ++i;
        }
        if (retVal < 0 && tmpIndexOfLast >= 0 && (tmpVal = tmpLI.doubleValue(tmpIndexOfLast, 0L)) < PrimitiveMath.ZERO && tmpVal < tmpMin && !this.options.solution.isZero(tmpVal)) {
            tmpMin = tmpVal;
            retVal = tmpIndexOfLast;
            if (this.isDebug()) {
                this.log("Only the last included needs to be excluded: {} @ {} ({}).", tmpMin, retVal, tmpIncluded[retVal]);
            }
        }
        return retVal >= 0 ? tmpIncluded[retVal] : retVal;
    }

    protected int suggestConstraintToInclude() {
        return this.getConstraintToInclude();
    }

    protected String toActivatorString() {
        return this.myActivator.toString();
    }

    @Override
    final int countIterationConstraints() {
        return this.countEqualityConstraints() + this.countIncluded();
    }

    int getConstraintToInclude() {
        return this.myConstraintToInclude;
    }

    MatrixStore<Double> getInvQC() {
        return this.myInvQC;
    }

    @Override
    final MatrixStore<Double> getIterationA() {
        int numbEqus = this.countEqualityConstraints();
        int numbVars = this.countVariables();
        int[] incl = this.myActivator.getIncluded();
        PhysicalStore retVal = (PhysicalStore)PrimitiveDenseStore.FACTORY.makeZero(numbEqus + incl.length, numbVars);
        if (numbEqus > 0) {
            this.getMatrixAE().supplyTo(retVal.regionByLimits(numbEqus, numbVars));
        }
        for (int i = 0; i < incl.length; ++i) {
            this.getMatrixAI(incl[i]).supplyNonZerosTo(retVal.regionByRows(numbEqus + i));
        }
        return retVal;
    }

    @Override
    final MatrixStore<Double> getIterationB() {
        int i;
        int numbEqus = this.countEqualityConstraints();
        int[] incl = this.myActivator.getIncluded();
        PhysicalStore retVal = (PhysicalStore)PrimitiveDenseStore.FACTORY.makeZero(numbEqus + incl.length, 1L);
        for (i = 0; i < numbEqus; ++i) {
            retVal.set((long)i, this.getMatrixBE().doubleValue(i));
        }
        for (i = 0; i < incl.length; ++i) {
            retVal.set((long)(numbEqus + i), this.getMatrixBI().doubleValue(incl[i]));
        }
        return retVal;
    }

    @Override
    final MatrixStore<Double> getIterationC() {
        return this.getMatrixC();
    }

    MatrixStore<Double> getIterationL(int[] included) {
        int tmpCountE = this.countEqualityConstraints();
        Object tmpLI = this.mySolutionL.logical().offsets(tmpCountE, 0).row(included).get();
        return this.mySolutionL.logical().limits(tmpCountE, 1).below(new MatrixStore[]{tmpLI}).get();
    }

    PrimitiveDenseStore getIterationX() {
        return this.myIterationX;
    }

    PhysicalStore<Double> getSlackI() {
        this.supplySlackI(this.mySlackI);
        return this.mySlackI;
    }

    PrimitiveDenseStore getSolutionL() {
        return this.mySolutionL;
    }

    final void handleIterationResults(boolean solved, PrimitiveDenseStore iterX, int[] included, int[] excluded) {
        PhysicalStore<Double> soluX = this.getSolutionX();
        if (solved) {
            double normStepX;
            double normCurrentX;
            iterX.modifyMatching(PrimitiveFunction.SUBTRACT, (Access1D<Double>)soluX);
            if (this.isDebug()) {
                this.log("Current: {}", soluX.asList());
                this.log("Step: {}", iterX.asList());
            }
            if (!(this.options.solution.isSmall(normCurrentX = ((Double)soluX.aggregateAll(Aggregator.NORM2)).doubleValue(), normStepX = iterX.aggregateAll(Aggregator.NORM2).doubleValue()) || !this.options.solution.isSmall(PrimitiveMath.ONE, normCurrentX) && this.options.solution.isSmall(normStepX, normCurrentX))) {
                double stepLength = PrimitiveMath.ONE;
                if (excluded.length > 0) {
                    PhysicalStore<Double> slack = this.getSlackI();
                    if (this.isDebug()) {
                        MatrixStore<PrimitiveDenseStore> change = this.getMatrixAI(excluded).get().multiply(iterX);
                        PhysicalStore<PrimitiveDenseStore> steps = slack.copy();
                        steps.modifyMatching(PrimitiveFunction.DIVIDE, change);
                        this.log("Numer/slack: {}", slack.asList());
                        this.log("Denom/chang: {}", change.copy().asList());
                        this.log("Looking for the largest possible step length (smallest positive scalar) among these: {}).", steps.asList());
                    }
                    for (int i = 0; i < excluded.length; ++i) {
                        double tmpVal;
                        SparseArray<Double> excludedInequalityRow = this.getMatrixAI(excluded[i]);
                        double tmpN = slack.doubleValue(excluded[i]);
                        double tmpD = excludedInequalityRow.dot(iterX);
                        double d = tmpVal = this.options.feasibility.isSmall(tmpD, tmpN) ? PrimitiveMath.ZERO : tmpN / tmpD;
                        if (tmpD > PrimitiveMath.ZERO && tmpVal >= PrimitiveMath.ZERO && tmpVal < stepLength && !this.options.solution.isSmall(normStepX, tmpD)) {
                            stepLength = tmpVal;
                            this.setConstraintToInclude(excluded[i]);
                            if (!this.isDebug()) continue;
                            this.log("Best so far: {} @ {} ({}).", stepLength, i, this.getConstraintToInclude());
                            continue;
                        }
                        if (NumberContext.compare(tmpVal, PrimitiveMath.ZERO) != 0 || !this.isDebug()) continue;
                        this.log("Zero, but still not good...", new Object[0]);
                        this.log("Numer/slack: {}", tmpN);
                        this.log("Denom/chang: {}", tmpD);
                        this.log("Small:       {}", this.options.solution.isSmall(normStepX, tmpD));
                    }
                }
                if (stepLength > PrimitiveMath.ZERO) {
                    iterX.axpy(stepLength, soluX);
                } else if (this.getConstraintToInclude() >= 0 && this.myActivator.getLastExcluded() == this.getConstraintToInclude() && this.myActivator.getLastIncluded() == this.getConstraintToInclude()) {
                    this.setConstraintToInclude(-1);
                }
                this.setState(Optimisation.State.APPROXIMATE);
            } else if (this.isDebug()) {
                if (this.isDebug()) {
                    this.log("Step too small!", new Object[0]);
                }
                this.setState(Optimisation.State.FEASIBLE);
            }
        } else if (included.length >= 1) {
            this.shrink();
            this.performIteration();
        } else if (!this.isSolvableQ()) {
            double largestInQ = (Double)this.getIterationQ().aggregateAll(Aggregator.LARGEST);
            double largestInC = this.getMatrixC().aggregateAll(Aggregator.LARGEST);
            double largest = PrimitiveFunction.MAX.invoke(largestInQ, largestInC);
            this.getIterationQ().modifyDiagonal(PrimitiveFunction.ADD.second(largest * RELATIVELY_SMALL));
            this.computeQ(this.getIterationQ());
            this.getSolutionL().modifyAll(arg -> {
                if (Double.isFinite(arg)) {
                    return arg;
                }
                return PrimitiveMath.ZERO;
            });
            this.resetActivator();
            this.performIteration();
        } else if (this.checkFeasibility(false)) {
            this.setState(Optimisation.State.FEASIBLE);
        } else {
            this.setState(Optimisation.State.INFEASIBLE);
        }
        if (this.isDebug()) {
            this.log("Post iteration", new Object[0]);
            this.log("\tSolution: {}", soluX.copy().asList());
            this.log("\tL: {}", this.getSolutionL().asList());
            if (this.getMatrixAE() != null && this.getMatrixAE().count() > 0L) {
                this.log("\tE-slack: {}", this.getSE().copy().asList());
                if (!this.options.feasibility.isZero(this.getSE().aggregateAll(Aggregator.LARGEST))) {
                    // empty if block
                }
            }
            this.log("\tI-slack: {}", this.mySlackI.copy().asList());
            if (!this.options.feasibility.isZero(this.mySlackI.aggregateAll(Aggregator.LARGEST))) {
                // empty if block
            }
        }
    }

    void resetActivator() {
        this.myActivator.excludeAll();
        int numbEqus = this.countEqualityConstraints();
        int numbVars = this.countVariables();
        if (this.hasInequalityConstraints()) {
            PhysicalStore<Double> slack = this.getSlackI();
            int[] excl = this.getExcluded();
            for (int i = 0; i < excl.length; ++i) {
                if (!this.options.feasibility.isZero(slack.doubleValue(excl[i])) || this.options.solution.isZero(this.getSolutionL().doubleValue((long)(numbEqus + excl[i])))) continue;
                this.include(excl[i]);
            }
        }
        while (numbEqus + this.countIncluded() >= numbVars && this.countIncluded() > 0) {
            this.shrink();
        }
        if (this.isDebug() && numbEqus + this.countIncluded() > numbVars) {
            this.log("Redundant contraints!", new Object[0]);
        }
    }

    void setConstraintToInclude(int constraintToInclude) {
        this.myConstraintToInclude = constraintToInclude;
    }
}

