/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.MultiLineLabel;
import ij.gui.Roi;
import ij.gui.YesNoCancelDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import stitching.CommonFunctions;
import stitching.CrossCorrelationResult3D;
import stitching.FloatArray3D;
import stitching.ImageInformation;
import stitching.Point3D;
import stitching.Quicksortable;
import stitching.utils.Log;

public class Stitching_3D
implements PlugIn {
    private String myURL = "http://fly.mpi-cbg.de/~preibisch/contact.html";
    public String imgStack1;
    public String imgStack2;
    public String fusedImageName;
    public static String methodStatic = CommonFunctions.methodList[1];
    public static String handleRGB1Static = CommonFunctions.colorList[CommonFunctions.colorList.length - 1];
    public static String handleRGB2Static = CommonFunctions.colorList[CommonFunctions.colorList.length - 1];
    public static boolean fuseImagesStatic = true;
    public static boolean windowingStatic = true;
    public static boolean coregisterStatic = false;
    public static boolean computeOverlapStatic = true;
    public static int checkPeaksStatic = 5;
    public static int numberOfChannelsStatic = 1;
    public static double alphaStatic = 1.5;
    public static int xOffsetStatic = 0;
    public static int yOffsetStatic = 0;
    public static int zOffsetStatic = 0;
    public String method;
    public String handleRGB1;
    public String handleRGB2;
    public boolean fuseImages;
    public boolean windowing;
    public boolean coregister;
    public boolean computeOverlap = true;
    public int checkPeaks;
    public int numberOfChannels;
    public double alpha;
    public int xOffset = 0;
    public int yOffset = 0;
    public int zOffset = 0;
    public ImagePlus imp1 = null;
    public ImagePlus imp2 = null;
    public boolean wasIndexed;
    public boolean doLogging = true;
    public double minOverlap = 0.01;
    private ArrayList<String[]> coregStacks;
    private ArrayList<ImagePlus[]> coregStackIMPs;
    private ArrayList<Boolean> coregWasIndexed;
    private Point3D shift = null;
    private CrossCorrelationResult3D[] result = null;
    private Point3D translation = null;

    public Point3D getTranslation() {
        return this.shift.clone();
    }

    public CrossCorrelationResult3D[] getCrossCorrelationResults() {
        return this.result;
    }

    public CrossCorrelationResult3D getCrossCorrelationResult() {
        return this.result[0].clone();
    }

    public void run(String args) {
        int[] idList = WindowManager.getIDList();
        if (idList == null) {
            IJ.error((String)"You need two open image stacks.");
            return;
        }
        int stacks = 0;
        for (int i = 0; i < idList.length; ++i) {
            if (WindowManager.getImage((int)idList[i]).getStackSize() <= 1) continue;
            ++stacks;
        }
        if (stacks < 2) {
            IJ.error((String)"You need two open image stacks.");
            return;
        }
        String[] stackList = new String[stacks];
        int[] stackIDs = new int[stacks];
        stacks = 0;
        for (int i = 0; i < idList.length; ++i) {
            if (WindowManager.getImage((int)idList[i]).getStackSize() <= 1) continue;
            stackList[stacks] = WindowManager.getImage((int)idList[i]).getTitle();
            stackIDs[stacks] = idList[i];
            ++stacks;
        }
        GenericDialog gd = new GenericDialog("Stitching of 3D Images");
        gd.addChoice("First_Stack (reference)", stackList, stackList[0]);
        gd.addChoice("Use_Channel_for_First", CommonFunctions.colorList, handleRGB1Static);
        this.enableChannelChoice((Choice)gd.getChoices().get(0), (Choice)gd.getChoices().get(1), stackIDs);
        gd.addChoice("Second_Stack (to register)", stackList, stackList[1]);
        gd.addChoice("Use_Channel_for_Second", CommonFunctions.colorList, handleRGB2Static);
        this.enableChannelChoice((Choice)gd.getChoices().get(2), (Choice)gd.getChoices().get(3), stackIDs);
        gd.addCheckbox("Use_Windowing", windowingStatic);
        gd.addNumericField("Peaks", (double)checkPeaksStatic, 0);
        gd.addCheckbox("Create_Fused_Image", fuseImagesStatic);
        gd.addChoice("Fusion_Method", CommonFunctions.methodList, methodStatic);
        gd.addNumericField("Fusion alpha", alphaStatic, 2);
        gd.addStringField("Fused_Image_Name: ", "Fused_" + stackList[0] + "_" + stackList[1]);
        gd.addCheckbox("Apply_to_other_Channels", coregisterStatic);
        gd.addNumericField("Number_of_other_Channels", (double)numberOfChannelsStatic, 0);
        gd.addCheckbox("compute_overlap", computeOverlapStatic);
        gd.addNumericField("x", (double)this.xOffset, xOffsetStatic);
        gd.addNumericField("y", (double)this.yOffset, yOffsetStatic);
        gd.addNumericField("z", (double)this.zOffset, zOffsetStatic);
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\n" + this.myURL);
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        CommonFunctions.addHyperLinkListener(text, this.myURL);
        Component[] c1 = new Component[]{(Component)gd.getChoices().get(4), (Component)gd.getStringFields().get(0), (Component)gd.getCheckboxes().get(2), (Component)gd.getNumericFields().get(1), (Component)gd.getNumericFields().get(2)};
        Stitching_3D.addEnablerListener((Checkbox)gd.getCheckboxes().get(1), c1, null);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.imgStack1 = gd.getNextChoice();
        handleRGB1Static = gd.getNextChoice();
        this.imgStack2 = gd.getNextChoice();
        handleRGB2Static = gd.getNextChoice();
        this.imp1 = WindowManager.getImage((int)stackIDs[((Choice)gd.getChoices().get(0)).getSelectedIndex()]);
        this.imp2 = WindowManager.getImage((int)stackIDs[((Choice)gd.getChoices().get(2)).getSelectedIndex()]);
        windowingStatic = gd.getNextBoolean();
        checkPeaksStatic = (int)gd.getNextNumber();
        fuseImagesStatic = gd.getNextBoolean();
        methodStatic = gd.getNextChoice();
        alphaStatic = gd.getNextNumber();
        this.fusedImageName = gd.getNextString();
        coregisterStatic = gd.getNextBoolean();
        numberOfChannelsStatic = (int)gd.getNextNumber();
        this.computeOverlap = gd.getNextBoolean();
        this.xOffset = (int)Math.round(gd.getNextNumber());
        this.yOffset = (int)Math.round(gd.getNextNumber());
        this.zOffset = (int)Math.round(gd.getNextNumber());
        this.method = methodStatic;
        this.handleRGB1 = handleRGB1Static;
        this.handleRGB2 = handleRGB2Static;
        this.fuseImages = fuseImagesStatic;
        this.windowing = windowingStatic;
        this.coregister = coregisterStatic;
        this.checkPeaks = checkPeaksStatic;
        this.numberOfChannels = numberOfChannelsStatic;
        this.alpha = alphaStatic;
        this.translation = !this.computeOverlap ? new Point3D(this.xOffset, this.yOffset, this.zOffset) : null;
        boolean calledFromMacro = false;
        if (!this.imp1.getTitle().equals(this.imgStack1) || !this.imp2.getTitle().equals(this.imgStack2)) {
            calledFromMacro = true;
            this.imp1 = WindowManager.getImage((String)this.imgStack1);
            this.imp2 = WindowManager.getImage((String)this.imgStack2);
        }
        if (!calledFromMacro && stackIDs[((Choice)gd.getChoices().get(0)).getSelectedIndex()] == stackIDs[((Choice)gd.getChoices().get(2)).getSelectedIndex()]) {
            IJ.error((String)"You selected the same stack twice. Stopping.");
            return;
        }
        if (this.fuseImages) {
            if (this.imp1.getType() != this.imp2.getType()) {
                IJ.error((String)"The Image Stacks are of a different type, it is unclear how to fuse them. Stopping.");
                return;
            }
            if ((this.imp1.getType() == 4 || this.imp1.getType() == 3) && this.method.equals(CommonFunctions.methodList[4])) {
                Log.warn("Red-Cyan Overlay is not possible for RGB images, reducing images to Single Channel data.");
            }
        }
        if (!this.fuseImages) {
            this.coregister = false;
        }
        if (this.imp1.getType() == 3) {
            new StackConverter(this.imp1).convertToRGB();
            new StackConverter(this.imp2).convertToRGB();
            this.wasIndexed = true;
        } else {
            this.wasIndexed = false;
        }
        if (this.coregister) {
            if (!this.fuseImages) {
                YesNoCancelDialog error = new YesNoCancelDialog(null, "Error", "Co-Registration makes only sense if you want to fuse the image stacks, actually you only get the numbers. Do you want to continue?");
                if (!error.yesPressed()) {
                    return;
                }
                this.coregister = false;
            } else if (stackList.length < 3) {
                YesNoCancelDialog error = new YesNoCancelDialog(null, "Error", "You have only two stacks open, there is nothing to co-register. Do you want to continue?");
                if (!error.yesPressed()) {
                    return;
                }
                this.coregister = false;
            } else if (this.numberOfChannels < 1) {
                YesNoCancelDialog error = new YesNoCancelDialog(null, "Error", "You have selected less than 1 stack to co-register...that makes no sense to me. Do you want to continue?");
                if (!error.yesPressed()) {
                    return;
                }
                this.coregister = false;
            } else {
                int i;
                GenericDialog coreg = new GenericDialog("Co-Registration");
                for (i = 0; i < this.numberOfChannels; ++i) {
                    coreg.addMessage("Co-Register Stack #" + (i + 1));
                    coreg.addChoice("First_Image_Stack_" + (i + 1) + " (not moved)", stackList, stackList[2]);
                    coreg.addChoice("Second_Image_Stack_" + (i + 1) + " (moved)", stackList, stackList[3]);
                    coreg.addStringField("Fused_Image_Name_" + (i + 1), "Fused Channel " + (i + 2));
                    if (i + 1 == this.numberOfChannels) continue;
                    coreg.addMessage("");
                }
                coreg.showDialog();
                if (coreg.wasCanceled()) {
                    return;
                }
                this.coregStacks = new ArrayList();
                this.coregStackIMPs = new ArrayList();
                this.coregWasIndexed = new ArrayList();
                for (i = 0; i < this.numberOfChannels; ++i) {
                    String[] entry = new String[]{coreg.getNextChoice(), coreg.getNextChoice(), coreg.getNextString()};
                    ImagePlus[] entryIMPs = new ImagePlus[]{WindowManager.getImage((int)stackIDs[((Choice)coreg.getChoices().get(i * 2)).getSelectedIndex()]), WindowManager.getImage((int)stackIDs[((Choice)coreg.getChoices().get(i * 2 + 1)).getSelectedIndex()])};
                    if (entryIMPs[0].getType() != entryIMPs[1].getType()) {
                        IJ.error((String)("The Image Stacks (Coreg #" + (i + 1) + ") are of a different type, it is unclear how to fuse them. Stopping."));
                        return;
                    }
                    if (stackIDs[((Choice)coreg.getChoices().get(i * 2)).getSelectedIndex()] == stackIDs[((Choice)coreg.getChoices().get(i * 2 + 1)).getSelectedIndex()]) {
                        IJ.error((String)("You selected the same stack twice (Coreg #" + (i + 1) + "). Stopping."));
                        return;
                    }
                    if (entryIMPs[0].getType() == 3) {
                        new StackConverter(entryIMPs[0]).convertToRGB();
                        new StackConverter(entryIMPs[1]).convertToRGB();
                        this.coregWasIndexed.add(true);
                    } else {
                        this.coregWasIndexed.add(false);
                    }
                    this.coregStacks.add(entry);
                    this.coregStackIMPs.add(entryIMPs);
                }
            }
        }
        if (this.doLogging) {
            Log.info("(" + new Date(System.currentTimeMillis()) + "):Starting");
        }
        this.work();
        if (this.doLogging) {
            Log.info("(" + new Date(System.currentTimeMillis()) + "):Finished");
        }
    }

    private final void enableChannelChoice(final Choice controller, final Choice target, final int[] stackIDs) {
        this.setRGB(stackIDs[controller.getSelectedIndex()], target);
        controller.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                Stitching_3D.this.setRGB(stackIDs[controller.getSelectedIndex()], target);
            }
        });
    }

    private final void setRGB(int imagejID, Choice target) {
        if (WindowManager.getImage((int)imagejID).getType() == 4 || WindowManager.getImage((int)imagejID).getType() == 3) {
            target.setEnabled(true);
        } else {
            target.setEnabled(false);
        }
    }

    public static final void addEnablerListener(Checkbox master, final Component[] enable, final Component[] disable) {
        master.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    this.process(enable, true);
                    this.process(disable, false);
                } else {
                    this.process(enable, false);
                    this.process(disable, true);
                }
            }

            private void process(Component[] c, boolean state) {
                if (null == c) {
                    return;
                }
                for (int i = 0; i < c.length; ++i) {
                    c[i].setEnabled(state);
                }
            }
        });
    }

    public static final void addInverseEnablerListener(Checkbox master, final Component[] enable, final Component[] disable) {
        master.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    this.process(enable, false);
                    this.process(disable, true);
                } else {
                    this.process(enable, true);
                    this.process(disable, false);
                }
            }

            private void process(Component[] c, boolean state) {
                if (null == c) {
                    return;
                }
                for (int i = 0; i < c.length; ++i) {
                    c[i].setEnabled(state);
                }
            }
        });
    }

    private ImagePlus getImage(String imgStack) {
        ImagePlus imp = null;
        try {
            imp = WindowManager.getImage((String)imgStack);
        }
        catch (Exception e) {
            IJ.error((String)("Could not find image stack: " + e));
        }
        return imp;
    }

    public Stitching_3D() {
    }

    public Stitching_3D(boolean windowing1, int checkPeaks1, boolean fuseImages1, String method1, String fusedImageName1) {
        this.windowing = windowing1;
        this.fuseImages = fuseImages1;
        this.method = method1;
        this.fusedImageName = fusedImageName1;
        this.checkPeaks = checkPeaks1;
    }

    public void work() {
        this.work(null, null);
    }

    public void work(FloatArray3D inputImage1, FloatArray3D inputImage2) {
        ImagePlus imp2;
        ImagePlus imp1;
        FloatArray3D img1 = null;
        FloatArray3D img2 = null;
        Point3D img1Dim = new Point3D(0, 0, 0);
        Point3D img2Dim = new Point3D(0, 0, 0);
        Point3D ext1Dim = new Point3D(0, 0, 0);
        Point3D ext2Dim = new Point3D(0, 0, 0);
        if (inputImage1 == null || inputImage2 == null) {
            imp1 = this.imp1 == null ? this.getImage(this.imgStack1) : this.imp1;
            imp2 = this.imp2 == null ? this.getImage(this.imgStack2) : this.imp2;
            if (imp1 == null || imp2 == null) {
                IJ.error((String)"Could not get the image stacks for some unknown reason.");
                return;
            }
            if (!this.checkRoi(imp1, imp2)) {
                return;
            }
            if (this.translation == null) {
                img1 = this.applyROI(imp1, img1Dim, ext1Dim, this.handleRGB1, this.windowing);
                img2 = this.applyROI(imp2, img2Dim, ext2Dim, this.handleRGB2, this.windowing);
            }
        } else {
            img1 = inputImage1;
            img2 = inputImage2;
            imp1 = this.FloatArrayToStack(img1, "Image1", 0.0f, 0.0f);
            imp2 = this.FloatArrayToStack(img2, "Image2", 0.0f, 0.0f);
            img1Dim.x = img1.width;
            img1Dim.y = img1.height;
            img1Dim.z = img1.depth;
            img2Dim.x = img2.width;
            img2Dim.y = img2.height;
            img2Dim.z = img2.depth;
        }
        if (this.translation == null) {
            if (this.windowing) {
                this.exponentialWindow(img1);
                this.exponentialWindow(img2);
            }
            FloatArray3D[] zeropadded = CommonFunctions.zeroPadImages(img1, img2);
            img1 = zeropadded[0];
            img2 = zeropadded[1];
            Point3D maxDim = new Point3D(img1.width, img1.height, img1.depth);
            FloatArray3D fft1 = CommonFunctions.computeFFT(img1);
            FloatArray3D fft2 = CommonFunctions.computeFFT(img2);
            FloatArray3D invPCM = CommonFunctions.computePhaseCorrelationMatrix(fft1, fft2, maxDim.x);
            ArrayList<Point3D> peaks = Stitching_3D.findPeaks(invPCM, img1Dim, img2Dim, ext1Dim, ext2Dim, this.checkPeaks);
            img1 = this.applyROI(imp1, img1Dim, ext1Dim, this.handleRGB1, false);
            img2 = this.applyROI(imp2, img2Dim, ext2Dim, this.handleRGB2, false);
            this.result = this.testCrossCorrelation(invPCM, peaks, img1, img2);
            img2.data = null;
            img1.data = null;
            img2 = null;
            img1 = null;
            this.shift = this.getImageOffset(this.result[0], imp1, imp2);
        } else {
            this.shift = this.translation;
        }
        if (this.fuseImages) {
            ImagePlus fused = this.fuseImages(imp1, imp2, this.shift, this.method, this.fusedImageName);
            if (fused != null) {
                if (this.wasIndexed) {
                    new StackConverter(fused).convertToIndexedColor(256);
                }
                fused.show();
            }
            if (this.coregister) {
                for (int i = 0; i < this.numberOfChannels; ++i) {
                    String[] stacks = this.coregStacks.get(i);
                    ImagePlus[] imps = this.coregStackIMPs.get(i);
                    imp1 = imps[0];
                    ImagePlus coregistered = this.fuseImages(imp1, imp2 = imps[1], this.shift, this.method, stacks[2]);
                    if (coregistered == null) continue;
                    if (this.coregWasIndexed.get(i).booleanValue()) {
                        new StackConverter(fused).convertToIndexedColor(256);
                    }
                    coregistered.show();
                }
            }
        }
        if (this.doLogging) {
            Log.info("Translation Parameters:");
            Log.info("(second stack relative to first stack)");
            if (this.translation == null) {
                Log.info("x=" + this.shift.x + " y=" + this.shift.y + " z=" + this.shift.z + " R=" + this.result[0].R);
            } else {
                Log.info("x=" + this.shift.x + " y=" + this.shift.y + " z=" + this.shift.z);
            }
        }
    }

    private Point3D getImageOffset(CrossCorrelationResult3D result, ImagePlus imp1, ImagePlus imp2) {
        Point3D si;
        Point3D sr = result.shift;
        if (imp1.getRoi() == null || imp2.getRoi() == null) {
            si = sr;
        } else {
            Roi roi1 = imp1.getRoi();
            Roi roi2 = imp2.getRoi();
            int x1 = roi1.getBoundingRect().x;
            int y1 = roi1.getBoundingRect().y;
            int x2 = roi2.getBoundingRect().x;
            int y2 = roi2.getBoundingRect().y;
            Point3D r1 = new Point3D(x1, y1, 0);
            Point3D r2 = new Point3D(x2, y2, 0);
            Point3D sir = this.add(r1, sr);
            si = this.subtract(sir, r2);
        }
        return si;
    }

    private Point3D subtract(Point3D a, Point3D b) {
        return new Point3D(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    private Point3D add(Point3D a, Point3D b) {
        return new Point3D(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    private ImagePlus fuseImages(ImagePlus imp1, ImagePlus imp2, Point3D shift, String fusionMethod, String name) {
        int dim = 3;
        ImageInformation i1 = new ImageInformation(3, 1, null);
        i1.closeAtEnd = false;
        i1.imp = imp1;
        i1.size[0] = imp1.getWidth();
        i1.size[1] = imp1.getHeight();
        i1.size[2] = imp1.getStack().getSize();
        i1.position = new float[3];
        i1.position[2] = 0.0f;
        i1.position[1] = 0.0f;
        i1.position[0] = 0.0f;
        i1.imageName = imp1.getTitle();
        i1.invalid = false;
        i1.imageType = imp1.getType();
        ImageInformation i2 = new ImageInformation(3, 2, null);
        i2.closeAtEnd = false;
        i2.imp = imp2;
        i2.size[0] = imp2.getWidth();
        i2.size[1] = imp2.getHeight();
        i2.size[2] = imp2.getStack().getSize();
        i2.position = new float[3];
        i2.position[0] = shift.x;
        i2.position[1] = shift.y;
        i2.position[2] = shift.z;
        i2.imageName = imp2.getTitle();
        i2.invalid = false;
        i2.imageType = imp2.getType();
        ArrayList<ImageInformation> imageInformationList = new ArrayList<ImageInformation>();
        imageInformationList.add(i1);
        imageInformationList.add(i2);
        float[] max = Stitch_Image_Collection.getAndApplyMinMax(imageInformationList, 3);
        return Stitch_Image_Collection.fuseImages(imageInformationList, max, name, fusionMethod, "rgb", 3, this.alpha, true);
    }

    private CrossCorrelationResult3D[] testCrossCorrelation(FloatArray3D invPCM, ArrayList<Point3D> peaks, FloatArray3D img1, FloatArray3D img2) {
        int numBestHits = peaks.size();
        int numCases = 8;
        Quicksortable[] result = new CrossCorrelationResult3D[numBestHits * 8];
        int count = 0;
        int w = invPCM.width;
        int h = invPCM.height;
        int d = invPCM.depth;
        Point3D[] points = new Point3D[8];
        int hit = 0;
        while (count < numBestHits * 8) {
            points[0] = peaks.get(hit);
            points[1] = points[0].x < 0 ? new Point3D(points[0].x + w, points[0].y, points[0].z) : new Point3D(points[0].x - w, points[0].y, points[0].z);
            points[2] = points[0].y < 0 ? new Point3D(points[0].x, points[0].y + h, points[0].z) : new Point3D(points[0].x, points[0].y - h, points[0].z);
            points[3] = points[0].z < 0 ? new Point3D(points[0].x, points[0].y, points[0].z + d) : new Point3D(points[0].x, points[0].y, points[0].z - d);
            points[4] = new Point3D(points[1].x, points[2].y, points[0].z);
            points[5] = new Point3D(points[0].x, points[2].y, points[3].z);
            points[6] = new Point3D(points[1].x, points[0].y, points[3].z);
            points[7] = new Point3D(points[1].x, points[2].y, points[3].z);
            final AtomicInteger entry = new AtomicInteger(count);
            final AtomicInteger shift = new AtomicInteger(0);
            Runnable task = new Runnable((CrossCorrelationResult3D[])result, points, img1, img2){
                final /* synthetic */ CrossCorrelationResult3D[] val$result;
                final /* synthetic */ Point3D[] val$points;
                final /* synthetic */ FloatArray3D val$img1;
                final /* synthetic */ FloatArray3D val$img2;
                {
                    this.val$result = crossCorrelationResult3DArray;
                    this.val$points = point3DArray;
                    this.val$img1 = floatArray3D;
                    this.val$img2 = floatArray3D2;
                }

                @Override
                public void run() {
                    try {
                        int myEntry = entry.getAndIncrement();
                        int myShift = shift.getAndIncrement();
                        this.val$result[myEntry] = Stitching_3D.testCrossCorrelation(this.val$points[myShift], this.val$img1, this.val$img2, Stitching_3D.this.minOverlap);
                    }
                    catch (Exception e) {
                        Log.error(e);
                    }
                }
            };
            CommonFunctions.startTask(task, 8);
            count += 8;
            ++hit;
        }
        CommonFunctions.quicksort(result, 0, result.length - 1);
        if (this.doLogging) {
            for (int i = 0; i < result.length; ++i) {
                Log.info("x:" + ((CrossCorrelationResult3D)result[i]).shift.x + " y:" + ((CrossCorrelationResult3D)result[i]).shift.y + " z:" + ((CrossCorrelationResult3D)result[i]).shift.z + " overlap:" + ((CrossCorrelationResult3D)result[i]).overlappingPixels + " R:" + ((CrossCorrelationResult3D)result[i]).R + " Peak:" + ((CrossCorrelationResult3D)result[i]).PCMValue);
            }
        }
        return result;
    }

    private static CrossCorrelationResult3D testCrossCorrelation(Point3D shift, FloatArray3D img1, FloatArray3D img2, double minOverlap) {
        float pixel2;
        float pixel1;
        int oldY2;
        int oldY1;
        int oldZ2;
        int oldZ1;
        CrossCorrelationResult3D result = new CrossCorrelationResult3D();
        result.PCMValue = shift.value;
        result.shift = shift;
        int w1 = img1.width;
        int h1 = img1.height;
        int d1 = img1.depth;
        int w2 = img2.width;
        int h2 = img2.height;
        int d2 = img2.depth;
        int sx = shift.x;
        int sy = shift.y;
        int sz = shift.z;
        int offsetImg1X = Math.max(0, -sx);
        int offsetImg1Y = Math.max(0, -sy);
        int offsetImg1Z = Math.max(0, -sz);
        int offsetImg2X = Math.max(0, sx);
        int offsetImg2Y = Math.max(0, sy);
        int offsetImg2Z = Math.max(0, sz);
        int count = 0;
        double avg1 = 0.0;
        double avg2 = 0.0;
        int startX = Math.max(offsetImg1X, offsetImg2X);
        int startY = Math.max(offsetImg1Y, offsetImg2Y);
        int startZ = Math.max(offsetImg1Z, offsetImg2Z);
        int endX = Math.min(offsetImg1X + w1, offsetImg2X + w2);
        int endY = Math.min(offsetImg1Y + h1, offsetImg2Y + h2);
        int endZ = Math.min(offsetImg1Z + d1, offsetImg2Z + d2);
        int arrayOffsetY1 = img1.getPos(0, 1, 0);
        int arrayOffsetY2 = img2.getPos(0, 1, 0);
        int arrayOffsetZ1 = img1.getPos(0, 0, 1);
        int arrayOffsetZ2 = img2.getPos(0, 0, 1);
        int off1 = img1.getPos(startX - offsetImg1X, startY - offsetImg1Y, startZ - offsetImg1Z);
        int off2 = img2.getPos(startX - offsetImg2X, startY - offsetImg2Y, startZ - offsetImg2Z);
        for (int z = startZ; z < endZ; ++z) {
            oldZ1 = off1;
            oldZ2 = off2;
            for (int y = startY; y < endY; ++y) {
                oldY1 = off1;
                oldY2 = off2;
                for (int x = startX; x < endX; ++x) {
                    pixel1 = img1.data[off1++];
                    pixel2 = img2.data[off2++];
                    avg1 += (double)pixel1;
                    avg2 += (double)pixel2;
                    ++count;
                }
                off1 = oldY1 + arrayOffsetY1;
                off2 = oldY2 + arrayOffsetY2;
            }
            off1 = oldZ1 + arrayOffsetZ1;
            off2 = oldZ2 + arrayOffsetZ2;
        }
        if ((double)count <= (double)Math.min(w1 * h1 * d1, w2 * h2 * d2) * minOverlap) {
            result.R = 0.0;
            result.SSQ = 3.4028234663852886E38;
            result.overlappingPixels = count;
            return result;
        }
        avg1 /= (double)count;
        avg2 /= (double)count;
        double var1 = 0.0;
        double var2 = 0.0;
        double coVar = 0.0;
        double SSQ = 0.0;
        count = 0;
        off1 = img1.getPos(startX - offsetImg1X, startY - offsetImg1Y, startZ - offsetImg1Z);
        off2 = img2.getPos(startX - offsetImg2X, startY - offsetImg2Y, startZ - offsetImg2Z);
        for (int z = startZ; z < endZ; ++z) {
            oldZ1 = off1;
            oldZ2 = off2;
            for (int y = startY; y < endY; ++y) {
                oldY1 = off1;
                oldY2 = off2;
                for (int x = startX; x < endX; ++x) {
                    pixel1 = img1.data[off1++];
                    pixel2 = img2.data[off2++];
                    double pixelSSQ = Math.pow(pixel1 - pixel2, 2.0);
                    SSQ += pixelSSQ;
                    ++count;
                    double dist1 = (double)pixel1 - avg1;
                    double dist2 = (double)pixel2 - avg2;
                    coVar += dist1 * dist2;
                    var1 += dist1 * dist1;
                    var2 += dist2 * dist2;
                }
                off1 = oldY1 + arrayOffsetY1;
                off2 = oldY2 + arrayOffsetY2;
            }
            off1 = oldZ1 + arrayOffsetZ1;
            off2 = oldZ2 + arrayOffsetZ2;
        }
        SSQ /= (double)count;
        coVar /= (double)count;
        double stDev1 = Math.sqrt(var1 /= (double)count);
        double stDev2 = Math.sqrt(var2 /= (double)count);
        if (stDev1 == 0.0 || stDev2 == 0.0) {
            result.R = 0.0;
            result.SSQ = 3.4028234663852886E38;
            result.overlappingPixels = count;
            return result;
        }
        result.R = coVar / (stDev1 * stDev2);
        result.SSQ = SSQ;
        result.overlappingPixels = count;
        result.shift = shift;
        return result;
    }

    public static ArrayList<Point3D> findPeaks(FloatArray3D invPCM, Point3D img1, Point3D img2, Point3D ext1, Point3D ext2, int checkPeaks) {
        int w = invPCM.width;
        int h = invPCM.height;
        int d = invPCM.depth;
        ArrayList<Point3D> peaks = new ArrayList<Point3D>();
        for (int j = 0; j < checkPeaks; ++j) {
            peaks.add(new Point3D(0, 0, 0, Float.MIN_VALUE));
        }
        for (int z = 0; z < d; ++z) {
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    if (!Stitching_3D.isLocalMaxima(invPCM, x, y, z)) continue;
                    float value = invPCM.get(x, y, z);
                    Point3D insert = null;
                    int insertPos = -1;
                    Iterator<Point3D> i = peaks.iterator();
                    boolean wasBigger = true;
                    while (i.hasNext() && wasBigger) {
                        if (value > i.next().value) {
                            if (insert == null) {
                                insert = new Point3D(0, 0, 0, value);
                            }
                            ++insertPos;
                            continue;
                        }
                        wasBigger = false;
                    }
                    if (insertPos >= 0) {
                        peaks.add(insertPos + 1, insert);
                    }
                    if (peaks.size() > checkPeaks) {
                        peaks.remove(0);
                    }
                    if (insert == null) continue;
                    int xt = x + (img1.x - img2.x) / 2 - (ext1.x - ext2.x) / 2;
                    int xs = xt >= w / 2 ? xt - w : xt;
                    int yt = y + (img1.y - img2.y) / 2 - (ext1.y - ext2.y) / 2;
                    int ys = yt >= h / 2 ? yt - h : yt;
                    int zt = z + (img1.z - img2.z) / 2 - (ext1.z - ext2.z) / 2;
                    int zs = zt >= d / 2 ? zt - d : zt;
                    insert.x = xs;
                    insert.y = ys;
                    insert.z = zs;
                }
            }
        }
        return peaks;
    }

    private static boolean isLocalMaxima(FloatArray3D invPCM, int x, int y, int z) {
        int width = invPCM.width;
        int height = invPCM.height;
        int depth = invPCM.depth;
        boolean isMax = true;
        float value = invPCM.get(x, y, z);
        if (x > 0 && y > 0 && z > 0 && x < width - 1 && y < height - 1 && z < depth - 1) {
            for (int xs = x - 1; xs <= x + 1 && isMax; ++xs) {
                for (int ys = y - 1; ys <= y + 1 && isMax; ++ys) {
                    for (int zs = z - 1; zs <= z + 1 && isMax; ++zs) {
                        if (x == xs && y == ys && z == zs || !(invPCM.get(xs, ys, zs) > value)) continue;
                        isMax = false;
                    }
                }
            }
        } else {
            for (int xs = x - 1; xs <= x + 1 && isMax; ++xs) {
                for (int ys = y - 1; ys <= y + 1 && isMax; ++ys) {
                    for (int zs = z - 1; zs <= z + 1 && isMax; ++zs) {
                        if (x == xs && y == ys && z == zs) continue;
                        int xt = xs;
                        int yt = ys;
                        int zt = zs;
                        if (xt == -1) {
                            xt = width - 1;
                        }
                        if (yt == -1) {
                            yt = height - 1;
                        }
                        if (zt == -1) {
                            zt = depth - 1;
                        }
                        if (xt == width) {
                            xt = 0;
                        }
                        if (yt == height) {
                            yt = 0;
                        }
                        if (zt == depth) {
                            zt = 0;
                        }
                        if (!(invPCM.get(xt, yt, zt) > value)) continue;
                        isMax = false;
                    }
                }
            }
        }
        return isMax;
    }

    private FloatArray3D applyROI(ImagePlus imp, Point3D imgDim, Point3D extDim, String handleRGB, boolean windowing) {
        FloatArray3D stack;
        if (imp.getRoi() == null) {
            stack = this.StackToFloatArray(imp.getStack(), handleRGB);
        } else {
            Roi r = imp.getRoi();
            int x = r.getBoundingRect().x;
            int y = r.getBoundingRect().y;
            int w = r.getBoundingRect().width;
            int h = r.getBoundingRect().height;
            stack = this.StackToFloatArray(imp.getStack(), handleRGB, x, y, w, h);
        }
        imgDim.x = stack.width;
        imgDim.y = stack.height;
        imgDim.z = stack.depth;
        extDim.z = 0;
        extDim.y = 0;
        extDim.x = 0;
        if (windowing) {
            int imgW = stack.width;
            int imgH = stack.height;
            int imgD = stack.depth;
            int extW = imgW / 4;
            int extH = imgH / 4;
            int extD = imgD / 4;
            if (extW % 2 != 0) {
                ++extW;
            }
            if (extH % 2 != 0) {
                ++extH;
            }
            if (extD % 2 != 0) {
                ++extD;
            }
            extDim.x = extW;
            extDim.y = extH;
            extDim.z = extD;
            imgDim.x += extDim.x;
            imgDim.y += extDim.y;
            imgDim.z += extDim.z;
            stack = this.extendImageMirror(stack, imgW + extW, imgH + extH, imgD + extD);
        }
        return stack;
    }

    private boolean checkRoi(ImagePlus imp1, ImagePlus imp2) {
        boolean img1HasROI = imp1.getRoi() != null;
        boolean img2HasROI = imp2.getRoi() != null;
        if (img1HasROI && !img2HasROI || img2HasROI && !img1HasROI) {
            IJ.error((String)"Either both images should have a ROI or none of them.");
            return false;
        }
        if (img1HasROI) {
            int type1 = imp1.getRoi().getType();
            int type2 = imp2.getRoi().getType();
            if (type1 != 0) {
                IJ.error((String)(imp1.getTitle() + " has a ROI which is no rectangle."));
            }
            if (type2 != 0) {
                IJ.error((String)(imp2.getTitle() + " has a ROI which is no rectangle."));
            }
        }
        return true;
    }

    private void exponentialWindow(FloatArray3D img) {
        int z;
        double relPos;
        double a = 1000.0;
        double[] weightsX = new double[img.width];
        double[] weightsY = new double[img.height];
        double[] weightsZ = new double[img.depth];
        for (int x = 0; x < img.width; ++x) {
            relPos = (double)x / (double)(img.width - 1);
            weightsX[x] = relPos <= 0.5 ? 1.0 - 1.0 / Math.pow(a, relPos * 2.0) : 1.0 - 1.0 / Math.pow(a, (1.0 - relPos) * 2.0);
        }
        for (int y = 0; y < img.height; ++y) {
            relPos = (double)y / (double)(img.height - 1);
            weightsY[y] = relPos <= 0.5 ? 1.0 - 1.0 / Math.pow(a, relPos * 2.0) : 1.0 - 1.0 / Math.pow(a, (1.0 - relPos) * 2.0);
        }
        for (z = 0; z < img.depth; ++z) {
            relPos = (double)z / (double)(img.depth - 1);
            weightsZ[z] = relPos <= 0.5 ? 1.0 - 1.0 / Math.pow(a, relPos * 2.0) : 1.0 - 1.0 / Math.pow(a, (1.0 - relPos) * 2.0);
        }
        for (z = 0; z < img.depth; ++z) {
            for (int y = 0; y < img.height; ++y) {
                for (int x = 0; x < img.width; ++x) {
                    img.set((float)((double)img.get(x, y, z) * weightsX[x] * weightsY[y] * weightsZ[z]), x, y, z);
                }
            }
        }
    }

    private FloatArray3D extendImageMirror(FloatArray3D ip, int width, int height, int depth) {
        FloatArray3D image = new FloatArray3D(width, height, depth);
        int offsetX = (width - ip.width) / 2;
        int offsetY = (height - ip.height) / 2;
        int offsetZ = (depth - ip.depth) / 2;
        if (offsetX < 0) {
            IJ.error((String)("Stitching_3D.extendImageMirror(): Extended size in X smaller than image! " + width + " < " + ip.width));
            return null;
        }
        if (offsetY < 0) {
            IJ.error((String)("Stitching_3D.extendImageMirror(): Extended size in Y smaller than image! " + height + " < " + ip.height));
            return null;
        }
        if (offsetZ < 0) {
            IJ.error((String)("Stitching_3D.extendImageMirror(): Extended size in Z smaller than image! " + depth + " < " + ip.depth));
            return null;
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < depth; ++z) {
                    image.set(ip.getMirror(x - offsetX, y - offsetY, z - offsetZ), x, y, z);
                }
            }
        }
        return image;
    }

    private FloatArray3D StackToFloatArray(ImageStack stack, String handleRGB) {
        Object[] imageStack = stack.getImageArray();
        int width = stack.getWidth();
        int height = stack.getHeight();
        int nstacks = stack.getSize();
        int rgbType = -1;
        if (imageStack == null || imageStack.length == 0) {
            Log.error("Image Stack is empty.");
            return null;
        }
        if (imageStack[0] instanceof int[]) {
            if (handleRGB == null || handleRGB.trim().length() == 0) {
                handleRGB = CommonFunctions.colorList[CommonFunctions.colorList.length - 1];
            }
            for (int i = 0; i < CommonFunctions.colorList.length; ++i) {
                if (!handleRGB.toLowerCase().trim().equals(CommonFunctions.colorList[i].toLowerCase())) continue;
                rgbType = i;
            }
            if (rgbType == -1) {
                Log.warn("Unrecognized command to handle RGB: " + handleRGB + ". Assuming Average of Red, Green and Blue.");
                rgbType = CommonFunctions.colorList.length - 1;
            }
        }
        FloatArray3D pixels = new FloatArray3D(width, height, nstacks);
        if (imageStack[0] instanceof byte[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                byte[] pixelTmp = (byte[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice)] = pixelTmp[count++] & 0xFF;
                    }
                }
            }
        } else if (imageStack[0] instanceof short[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                short[] pixelTmp = (short[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice)] = pixelTmp[count++] & 0xFFFF;
                    }
                }
            }
        } else if (imageStack[0] instanceof float[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                float[] pixelTmp = (float[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice)] = pixelTmp[count++];
                    }
                }
            }
        } else if (imageStack[0] instanceof int[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                int[] pixelTmp = (int[])imageStack[countSlice];
                int count = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        pixels.data[pixels.getPos((int)x, (int)y, (int)countSlice)] = CommonFunctions.getPixelValueRGB(pixelTmp[count++], rgbType);
                    }
                }
            }
        } else {
            IJ.error((String)"StackToFloatArray: Unknown image type.");
            return null;
        }
        return pixels;
    }

    private FloatArray3D StackToFloatArray(ImageStack stack, String handleRGB, int xCrop, int yCrop, int wCrop, int hCrop) {
        Object[] imageStack = stack.getImageArray();
        int width = stack.getWidth();
        int nstacks = stack.getSize();
        int rgbType = -1;
        if (imageStack == null || imageStack.length == 0) {
            Log.error("Image Stack is empty.");
            return null;
        }
        if (imageStack[0] instanceof int[]) {
            if (handleRGB == null || handleRGB.trim().length() == 0) {
                handleRGB = CommonFunctions.colorList[CommonFunctions.colorList.length - 1];
            }
            for (int i = 0; i < CommonFunctions.colorList.length; ++i) {
                if (!handleRGB.toLowerCase().trim().equals(CommonFunctions.colorList[i].toLowerCase())) continue;
                rgbType = i;
            }
            if (rgbType == -1) {
                Log.warn("Unrecognized command to handle RGB: " + handleRGB + ". Assuming Average of Red, Green and Blue.");
                rgbType = CommonFunctions.colorList.length - 1;
            }
        }
        FloatArray3D pixels = new FloatArray3D(wCrop, hCrop, nstacks);
        if (imageStack[0] instanceof byte[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                byte[] pixelTmp = (byte[])imageStack[countSlice];
                for (int y = yCrop; y < yCrop + hCrop; ++y) {
                    for (int x = xCrop; x < xCrop + wCrop; ++x) {
                        pixels.data[pixels.getPos((int)(x - xCrop), (int)(y - yCrop), (int)countSlice)] = pixelTmp[x + y * width] & 0xFF;
                    }
                }
            }
        } else if (imageStack[0] instanceof short[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                short[] pixelTmp = (short[])imageStack[countSlice];
                for (int y = yCrop; y < yCrop + hCrop; ++y) {
                    for (int x = xCrop; x < xCrop + wCrop; ++x) {
                        pixels.data[pixels.getPos((int)(x - xCrop), (int)(y - yCrop), (int)countSlice)] = pixelTmp[x + y * width] & 0xFFFF;
                    }
                }
            }
        } else if (imageStack[0] instanceof float[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                float[] pixelTmp = (float[])imageStack[countSlice];
                for (int y = yCrop; y < yCrop + hCrop; ++y) {
                    for (int x = xCrop; x < xCrop + wCrop; ++x) {
                        pixels.data[pixels.getPos((int)(x - xCrop), (int)(y - yCrop), (int)countSlice)] = pixelTmp[x + y * width];
                    }
                }
            }
        } else if (imageStack[0] instanceof int[]) {
            for (int countSlice = 0; countSlice < nstacks; ++countSlice) {
                int[] pixelTmp = (int[])imageStack[countSlice];
                for (int y = yCrop; y < yCrop + hCrop; ++y) {
                    for (int x = xCrop; x < xCrop + wCrop; ++x) {
                        pixels.data[pixels.getPos((int)(x - xCrop), (int)(y - yCrop), (int)countSlice)] = CommonFunctions.getPixelValueRGB(pixelTmp[x + y * width], rgbType);
                    }
                }
            }
        } else {
            IJ.error((String)"StackToFloatArray(Crop): Unknown image type.");
            return null;
        }
        return pixels;
    }

    private ImagePlus FloatArrayToStack(FloatArray3D image, String name, float min, float max) {
        int width = image.width;
        int height = image.height;
        int nstacks = image.depth;
        ImageStack stack = new ImageStack(width, height);
        for (int slice = 0; slice < nstacks; ++slice) {
            ImagePlus impResult = IJ.createImage((String)"Result", (String)"32-Bit Black", (int)width, (int)height, (int)1);
            ImageProcessor ipResult = impResult.getProcessor();
            float[] sliceImg = new float[width * height];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    sliceImg[y * width + x] = image.get(x, y, slice);
                }
            }
            ipResult.setPixels((Object)sliceImg);
            if (min == max) {
                ipResult.resetMinAndMax();
            } else {
                ipResult.setMinAndMax((double)min, (double)max);
            }
            stack.addSlice("Slice " + slice, ipResult);
        }
        return new ImagePlus(name, stack);
    }
}

