/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.fusion.entropy;

import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.Array3D;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.spim.fusion.entropy.EntropyFloatArray3D;
import mpicbg.spim.io.IOFunctions;

public class Entropy {
    public final float[] preComputed;
    public final int[] absFreq;
    public boolean outOfImageX;
    public boolean outOfImageY;
    public boolean outOfImageZ;
    public final Image<FloatType> img;
    public final int histogramBins;
    public final int windowSizeX;
    public final int windowSizeY;
    public final int windowSizeZ;
    public final float size;
    public final int windowSizeXHalf;
    public final int windowSizeYHalf;
    public final int windowSizeZHalf;
    private float entropy;
    final LocalizableByDimCursor<FloatType> cursor;
    private int x;
    private int y;
    private int z;

    public final float getEntropy() {
        return this.entropy;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    public Entropy(float stepSize, Image<FloatType> img, LocalizableByDimCursor<FloatType> cursor, int histogramBins, int windowSizeX, int windowSizeY, int windowSizeZ, int x, int y, int z) {
        this.absFreq = new int[histogramBins];
        this.img = img;
        this.histogramBins = histogramBins;
        this.windowSizeX = windowSizeX % 2 == 0 ? windowSizeX + 1 : windowSizeX;
        this.windowSizeY = windowSizeY % 2 == 0 ? windowSizeY + 1 : windowSizeY;
        this.windowSizeZ = windowSizeZ % 2 == 0 ? windowSizeZ + 1 : windowSizeZ;
        this.size = this.windowSizeX * this.windowSizeY * this.windowSizeZ;
        this.windowSizeXHalf = this.windowSizeX / 2;
        this.windowSizeYHalf = this.windowSizeY / 2;
        this.windowSizeZHalf = this.windowSizeZ / 2;
        this.outOfImageZ = z - this.windowSizeZHalf < 0 || z + this.windowSizeZHalf >= img.getDimension(2);
        this.outOfImageY = y - this.windowSizeYHalf < 0 || y + this.windowSizeYHalf >= img.getDimension(1);
        this.outOfImageX = x - this.windowSizeXHalf < 0 || x + this.windowSizeXHalf >= img.getDimension(0);
        this.preComputed = this.preComputeProbabilities(stepSize);
        this.x = x;
        this.y = y;
        this.z = z;
        this.cursor = cursor;
        cursor.setPosition(new int[]{x, y, z});
    }

    public void close() {
        this.cursor.close();
    }

    public static Image<FloatType> computeEntropy(Image<FloatType> img, ContainerFactory entropyType, int histogramBins, int windowSizeX, int windowSizeY, int windowSizeZ) {
        if (Array3D.class.isInstance(img.getContainer())) {
            IOFunctions.println("Input is instance of Image<Float> using an Array3D, fast forward algorithm --- Fast Forward Algorithm available.");
            return EntropyFloatArray3D.computeEntropy(img, entropyType, histogramBins, windowSizeX, windowSizeY, windowSizeZ);
        }
        float maxEntropy = Entropy.getMaxEntropy(histogramBins);
        ImageFactory factory = new ImageFactory((Type)new FloatType(), entropyType);
        Image entropy = factory.createImage(img.getDimensions(), "Entropy of " + img.getName());
        LocalizableByDimCursor entropyIterator = entropy.createLocalizableByDimCursor((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyMirrorFactory());
        Entropy ei = Entropy.initEntropy(img, histogramBins, windowSizeX, windowSizeY, windowSizeZ, 0, 0, 0);
        boolean directionZ = true;
        int directionY = 1;
        int directionX = 1;
        int width = img.getDimension(0);
        int height = img.getDimension(1);
        int depth = img.getDimension(2);
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (x != 0) {
                        ei.updateEntropyX(directionX);
                    }
                    entropyIterator.move(ei.getX() - entropyIterator.getPosition(0), 0);
                    entropyIterator.move(ei.getY() - entropyIterator.getPosition(1), 1);
                    entropyIterator.move(ei.getZ() - entropyIterator.getPosition(2), 2);
                    ((FloatType)entropyIterator.getType()).set(ei.getEntropy() / maxEntropy);
                }
                directionX *= -1;
                if (y == height - 1) continue;
                ei.updateEntropyY(directionY);
            }
            directionY *= -1;
            if (z == depth - 1) continue;
            ei.updateEntropyZ(1);
        }
        entropyIterator.close();
        ei.close();
        return entropy;
    }

    public static Entropy initEntropy(Image<FloatType> img, int histogramBins, int windowSizeX, int windowSizeY, int windowSizeZ, int x, int y, int z) {
        LocalizableByDimCursor cursor = img.createLocalizableByDimCursor((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyMirrorFactory());
        Entropy ei = new Entropy(0.001f, img, (LocalizableByDimCursor<FloatType>)cursor, histogramBins, windowSizeX, windowSizeY, windowSizeZ, x, y, z);
        for (int zs = z - ei.windowSizeZHalf; zs <= z + ei.windowSizeZHalf; ++zs) {
            for (int ys = y - ei.windowSizeYHalf; ys <= y + ei.windowSizeYHalf; ++ys) {
                for (int xs = x - ei.windowSizeXHalf; xs <= x + ei.windowSizeXHalf; ++xs) {
                    cursor.move(xs - cursor.getPosition(0), 0);
                    cursor.move(ys - cursor.getPosition(1), 1);
                    cursor.move(zs - cursor.getPosition(2), 2);
                    int bin = (int)(((FloatType)cursor.getType()).get() * (float)histogramBins);
                    if (bin >= histogramBins) {
                        bin = histogramBins - 1;
                    }
                    if (bin < 0) {
                        bin = 0;
                    }
                    int n = bin;
                    ei.absFreq[n] = ei.absFreq[n] + 1;
                }
            }
        }
        ei.entropy = 0.0f;
        for (int bin = 0; bin < histogramBins; ++bin) {
            if (ei.absFreq[bin] <= 0) continue;
            float prob = (float)ei.absFreq[bin] / ei.size;
            ei.entropy = (float)((double)ei.entropy - (double)prob * (Math.log(prob) / Math.log(2.0)));
        }
        IOFunctions.println(Float.valueOf(ei.entropy));
        return ei;
    }

    public static float getMaxEntropy(int bins) {
        return (float)(Math.log(bins) / Math.log(2.0));
    }

    private final float getEntropyValue(float probability, float[] preComputed) {
        int index = (int)(probability * (float)(preComputed.length - 2)) + 1;
        return preComputed[index];
    }

    private final float[] preComputeProbabilities(float stepSize) {
        float[] tmp = new float[Math.round(1.0f / stepSize) + 2];
        for (int i = 0; i < tmp.length - 2; ++i) {
            double prob = ((float)i * stepSize + (float)(i + 1) * stepSize) / 2.0f;
            tmp[i + 1] = (float)(prob * (Math.log(prob) / Math.log(2.0)));
        }
        tmp[0] = tmp[1];
        tmp[tmp.length - 1] = tmp[tmp.length - 2];
        return tmp;
    }

    private final void updateEntropyValue() {
        this.entropy = 0.0f;
        for (int bin : this.absFreq) {
            if (bin <= 0) continue;
            this.entropy -= this.getEntropyValue((float)bin / this.size, this.preComputed);
        }
    }

    private static final void updateBinNegative(int[] absFreq, int histogramBins, int x, int y, int z, LocalizableByDimCursor<FloatType> cursor) {
        int mx = x - cursor.getPosition(0);
        int my = y - cursor.getPosition(1);
        int mz = z - cursor.getPosition(2);
        cursor.move(mx, 0);
        cursor.move(my, 1);
        cursor.move(mz, 2);
        int bin = (int)(((FloatType)cursor.getType()).get() * (float)histogramBins);
        cursor.move(-mx, 0);
        cursor.move(-my, 1);
        cursor.move(-mz, 2);
        if (bin >= histogramBins) {
            bin = histogramBins - 1;
        }
        if (bin < 0) {
            bin = 0;
        }
        int n = bin;
        absFreq[n] = absFreq[n] - 1;
    }

    private static final void updateBinPositive(int[] absFreq, int histogramBins, int x, int y, int z, LocalizableByDimCursor<FloatType> cursor) {
        int mx = x - cursor.getPosition(0);
        int my = y - cursor.getPosition(1);
        int mz = z - cursor.getPosition(2);
        cursor.move(mx, 0);
        cursor.move(my, 1);
        cursor.move(mz, 2);
        int bin = (int)(((FloatType)cursor.getType()).get() * (float)histogramBins);
        cursor.move(-mx, 0);
        cursor.move(-my, 1);
        cursor.move(-mz, 2);
        if (bin >= histogramBins) {
            bin = histogramBins - 1;
        }
        if (bin < 0) {
            bin = 0;
        }
        int n = bin;
        absFreq[n] = absFreq[n] + 1;
    }

    public void updateEntropyX(int direction) {
        int xs1 = this.x - direction * this.windowSizeXHalf;
        this.x += direction;
        int xs2 = this.x + direction * this.windowSizeXHalf;
        if (direction > 0) {
            this.cursor.move(1, 0);
        } else {
            this.cursor.move(-1, 0);
        }
        for (int zs = this.z - this.windowSizeZHalf; zs <= this.z + this.windowSizeZHalf; ++zs) {
            for (int ys = this.y - this.windowSizeYHalf; ys <= this.y + this.windowSizeYHalf; ++ys) {
                Entropy.updateBinNegative(this.absFreq, this.histogramBins, xs1, ys, zs, this.cursor);
                Entropy.updateBinPositive(this.absFreq, this.histogramBins, xs2, ys, zs, this.cursor);
            }
        }
        this.updateEntropyValue();
    }

    public void updateEntropyY(int direction) {
        int ys1 = this.y - direction * this.windowSizeYHalf;
        this.y += direction;
        int ys2 = this.y + direction * this.windowSizeYHalf;
        if (direction > 0) {
            this.cursor.move(1, 1);
        } else {
            this.cursor.move(-1, 1);
        }
        for (int zs = this.z - this.windowSizeZHalf; zs <= this.z + this.windowSizeZHalf; ++zs) {
            for (int xs = this.x - this.windowSizeXHalf; xs <= this.x + this.windowSizeXHalf; ++xs) {
                Entropy.updateBinNegative(this.absFreq, this.histogramBins, xs, ys1, zs, this.cursor);
                Entropy.updateBinPositive(this.absFreq, this.histogramBins, xs, ys2, zs, this.cursor);
            }
        }
        this.updateEntropyValue();
    }

    public void updateEntropyZ(int direction) {
        int zs1 = this.z - direction * this.windowSizeZHalf;
        this.z += direction;
        int zs2 = this.z + direction * this.windowSizeZHalf;
        if (direction > 0) {
            this.cursor.move(1, 2);
        } else {
            this.cursor.move(-1, 2);
        }
        for (int ys = this.y - this.windowSizeYHalf; ys <= this.y + this.windowSizeYHalf; ++ys) {
            for (int xs = this.x - this.windowSizeXHalf; xs <= this.x + this.windowSizeXHalf; ++xs) {
                Entropy.updateBinNegative(this.absFreq, this.histogramBins, xs, ys, zs1, this.cursor);
                Entropy.updateBinPositive(this.absFreq, this.histogramBins, xs, ys, zs2, this.cursor);
            }
        }
        this.updateEntropyValue();
    }
}

