/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.container.cell.CellContainerFactory;
import mpicbg.imglib.interpolation.linear.LinearInterpolatorFactory;
import mpicbg.imglib.interpolation.nearestneighbor.NearestNeighborInterpolatorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.spim.io.ConfigurationParserException;
import mpicbg.spim.io.ConfigurationParserObject;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.io.TextFileAccess;
import spim.Threads;

public class ConfigurationParserSPIM {
    public static SPIMConfiguration parseFile(String confFileName) throws ConfigurationParserException {
        String[] words;
        String line;
        BufferedReader confFile;
        String confFilePath;
        SPIMConfiguration conf = new SPIMConfiguration();
        String[] knownDatatypes = new String[]{"int", "double", "String", "boolean", "float", "float[]", "ContainerFactory", "InterpolatorFactory", "OutsideStrategyFactory"};
        confFileName = confFileName.replace('\\', '/');
        confFileName = confFileName.replaceAll("//", "/");
        try {
            confFilePath = confFileName.indexOf("/") != -1 ? confFileName.substring(0, confFileName.lastIndexOf("/") + 1) : "";
        }
        catch (Exception e) {
            throw new ConfigurationParserException("Error parsing confFileName-String: '" + e.getMessage() + "'");
        }
        BufferedReader assignFile = null;
        try {
            confFile = TextFileAccess.openFileReadEx(confFileName);
        }
        catch (IOException e) {
            throw new ConfigurationParserException("Configuration file not found: '" + confFileName + "'");
        }
        try {
            while (confFile.ready() && assignFile == null) {
                String line2 = confFile.readLine().trim();
                if (!line2.startsWith("<") || !line2.endsWith(">") || (assignFile = TextFileAccess.openFileRead(confFilePath + line2.substring(1, line2.length() - 1))) != null) continue;
                throw new ConfigurationParserException("Variables Assignment file not found: '" + confFilePath + line2.substring(1, line2.length() - 1) + "'");
            }
        }
        catch (Exception e) {
            throw new ConfigurationParserException("Error finding assignment file entry: '" + e.getMessage() + "'");
        }
        ArrayList<ConfigurationParserObject> assignments = new ArrayList<ConfigurationParserObject>();
        Field[] fields = conf.getClass().getDeclaredFields();
        int lineCount = 0;
        try {
            while (assignFile.ready()) {
                int i;
                ++lineCount;
                line = assignFile.readLine().trim();
                if (line.startsWith("#") || line.length() <= 0) continue;
                words = line.split("=");
                if (words.length != 2) {
                    throw new ConfigurationParserException("Wrong format in assignment file, should be 'entry = datatype name'");
                }
                ConfigurationParserObject cpo = new ConfigurationParserObject();
                cpo.setEntry(words[0].trim());
                words = words[1].trim().split(" ");
                if (words.length != 2) {
                    throw new ConfigurationParserException("Wrong format in assignment file, datatype and name on right side MUST have no spaces");
                }
                words[0] = words[0].trim();
                words[1] = words[1].trim();
                boolean positiveMatch = false;
                for (int i2 = 0; i2 < knownDatatypes.length; ++i2) {
                    if (words[0].compareTo(knownDatatypes[i2]) != 0) continue;
                    positiveMatch = true;
                }
                if (!positiveMatch) {
                    String datatypes = "";
                    for (i = 0; i < knownDatatypes.length; ++i) {
                        datatypes = datatypes + knownDatatypes[i] + " ";
                    }
                    throw new ConfigurationParserException("Unknown datatype '" + words[0] + "', available datatypes are: " + datatypes);
                }
                cpo.setDataType(words[0]);
                int variablesPosition = -1;
                for (i = 0; i < fields.length; ++i) {
                    if (words[1].compareTo(fields[i].getName()) != 0) continue;
                    variablesPosition = i;
                }
                if (variablesPosition == -1) {
                    String variables = "";
                    for (int i3 = 0; i3 < fields.length; ++i3) {
                        variables = variables + fields[i3].getName() + "\n";
                    }
                    throw new ConfigurationParserException("Unknown variable '" + words[1] + "', available variables are:\n" + variables);
                }
                cpo.setVariableName(words[1]);
                cpo.setVariableFieldPosition(variablesPosition);
                assignments.add(cpo);
            }
        }
        catch (Exception e) {
            throw new ConfigurationParserException("Error reading/parsing assignment file at line " + lineCount + ":\n" + e.getMessage());
        }
        lineCount = 0;
        try {
            while (confFile.ready()) {
                ArrayContainerFactory factory;
                ++lineCount;
                line = confFile.readLine().trim();
                if (line.startsWith("#") || line.length() <= 0) continue;
                words = line.split("=");
                if (words.length != 2) {
                    throw new ConfigurationParserException("Wrong format in configuration file, should be 'entry = value'");
                }
                words[0] = words[0].trim();
                words[1] = words[1].trim();
                int entryPos = ConfigurationParserSPIM.findEntry(assignments, words[0]);
                if (entryPos == -1) {
                    throw new ConfigurationParserException("Entry '" + words[0] + "' does not exist!\nFollowing entries are available:\n" + ConfigurationParserSPIM.getAllEntries(assignments));
                }
                ConfigurationParserObject cpo = assignments.get(entryPos);
                int varFieldPos = cpo.getVariableFieldPosition();
                if (cpo.getDataType().compareTo("byte") == 0) {
                    fields[varFieldPos].setByte(conf, Byte.parseByte(words[1]));
                    continue;
                }
                if (cpo.getDataType().compareTo("short") == 0) {
                    fields[varFieldPos].setShort(conf, Short.parseShort(words[1]));
                    continue;
                }
                if (cpo.getDataType().compareTo("int") == 0) {
                    fields[varFieldPos].setInt(conf, Integer.parseInt(words[1]));
                    continue;
                }
                if (cpo.getDataType().compareTo("long") == 0) {
                    fields[varFieldPos].setLong(conf, Long.parseLong(words[1]));
                    continue;
                }
                if (cpo.getDataType().compareTo("boolean") == 0) {
                    fields[varFieldPos].setBoolean(conf, Boolean.parseBoolean(words[1]));
                    continue;
                }
                if (cpo.getDataType().compareTo("float[]") == 0) {
                    String[] entries = words[1].split(",");
                    if (entries.length < 1) {
                        throw new ConfigurationParserException("Cannot parse array, should be 3, 4.3, 2, ... - but is '" + words[1] + "'");
                    }
                    float[] values = new float[entries.length];
                    for (int i = 0; i < entries.length; ++i) {
                        values[i] = Float.parseFloat(entries[i]);
                    }
                    fields[varFieldPos].set(conf, values);
                    continue;
                }
                if (cpo.getDataType().compareTo("float") == 0) {
                    if (words[1].toLowerCase().compareTo("nan") == 0) {
                        fields[varFieldPos].setFloat(conf, Float.NaN);
                        continue;
                    }
                    fields[varFieldPos].setFloat(conf, Float.parseFloat(words[1]));
                    continue;
                }
                if (cpo.getDataType().compareTo("double") == 0) {
                    if (words[1].toLowerCase().compareTo("nan") == 0) {
                        fields[varFieldPos].setDouble(conf, Double.NaN);
                        continue;
                    }
                    fields[varFieldPos].setDouble(conf, Double.parseDouble(words[1]));
                    continue;
                }
                if (cpo.getDataType().compareTo("String") == 0) {
                    if (words[1].equals("null")) {
                        fields[varFieldPos].set(conf, null);
                        continue;
                    }
                    if (words[1].startsWith("\"") && words[1].endsWith("\"")) {
                        fields[varFieldPos].set(conf, words[1].substring(1, words[1].length() - 1));
                        continue;
                    }
                    throw new ConfigurationParserException("Strings have to be surrounded by  \"\" or be null");
                }
                if (cpo.getDataType().compareTo("ContainerFactory") == 0) {
                    if (words[1].startsWith("ArrayContainerFactory")) {
                        factory = new ArrayContainerFactory();
                        factory.setParameters(words[1].substring(words[1].indexOf("("), words[1].length()));
                        fields[varFieldPos].set(conf, factory);
                        continue;
                    }
                    if (words[1].startsWith("CellContainerFactory")) {
                        factory = new CellContainerFactory();
                        factory.setParameters(words[1].substring(words[1].indexOf("("), words[1].length()));
                        fields[varFieldPos].set(conf, factory);
                        continue;
                    }
                    throw new ConfigurationParserException("Unknown implementation of ContainerFactory '" + words[1] + "'");
                }
                if (cpo.getDataType().compareTo("InterpolatorFactory") == 0) {
                    if (words[1].startsWith("LinearInterpolatorFactory")) {
                        factory = new LinearInterpolatorFactory(null);
                        factory.setParameters(words[1].substring(words[1].indexOf("("), words[1].length()));
                        fields[varFieldPos].set(conf, factory);
                        continue;
                    }
                    if (words[1].startsWith("NearestNeighborInterpolatorFactory")) {
                        factory = new NearestNeighborInterpolatorFactory(null);
                        factory.setParameters(words[1].substring(words[1].indexOf("("), words[1].length()));
                        fields[varFieldPos].set(conf, factory);
                        continue;
                    }
                    throw new ConfigurationParserException("Unknown implementation of FloatInterpolatorFactory '" + words[1] + "'");
                }
                if (cpo.getDataType().compareTo("OutsideStrategyFactory") == 0) {
                    if (words[1].startsWith("OutsideStrategyMirrorFactory")) {
                        factory = new OutOfBoundsStrategyMirrorFactory();
                        factory.setParameters(words[1].substring(words[1].indexOf("("), words[1].length()));
                        fields[varFieldPos].set(conf, factory);
                        continue;
                    }
                    if (words[1].startsWith("OutsideStrategyValueFactory")) {
                        factory = new OutOfBoundsStrategyValueFactory();
                        factory.setParameters(words[1].substring(words[1].indexOf("("), words[1].length()));
                        fields[varFieldPos].set(conf, factory);
                        continue;
                    }
                    throw new ConfigurationParserException("Unknown implementation of OutsideStrategyFactory '" + words[1] + "'");
                }
                throw new ConfigurationParserException("Unknown datatype '" + cpo.getDataType() + "'");
            }
        }
        catch (Exception e) {
            throw new ConfigurationParserException("Error reading/parsing configuration file at line " + lineCount + ":\n" + e.getMessage());
        }
        if (conf.numberOfThreads < 1) {
            conf.numberOfThreads = Threads.numThreads();
        }
        if (conf.scaleSpaceNumberOfThreads < 1) {
            conf.scaleSpaceNumberOfThreads = Threads.numThreads();
        }
        conf.inputdirectory = conf.inputdirectory.replace('\\', '/');
        conf.inputdirectory = conf.inputdirectory.trim();
        if (conf.inputdirectory.length() > 0 && !conf.inputdirectory.endsWith("/")) {
            conf.inputdirectory = conf.inputdirectory + "/";
        }
        if (conf.outputdirectory == null || conf.outputdirectory.length() == 0) {
            conf.outputdirectory = conf.inputdirectory;
        } else {
            conf.outputdirectory = conf.outputdirectory.replace('\\', '/');
            conf.outputdirectory = conf.outputdirectory.trim();
            if (conf.outputdirectory.length() > 0 && !conf.outputdirectory.endsWith("/")) {
                conf.outputdirectory = conf.outputdirectory + "/";
            }
        }
        if (conf.registrationFiledirectory == null || conf.registrationFiledirectory.length() == 0) {
            conf.registrationFiledirectory = conf.inputdirectory;
        } else {
            conf.registrationFiledirectory = conf.registrationFiledirectory.replace('\\', '/');
            conf.registrationFiledirectory = conf.registrationFiledirectory.trim();
            if (conf.registrationFiledirectory.length() > 0 && !conf.registrationFiledirectory.endsWith("/")) {
                conf.registrationFiledirectory = conf.registrationFiledirectory + "/";
            }
        }
        ConfigurationParserSPIM.testDirectories(conf);
        int countTrue = 0;
        if (conf.paralellFusion) {
            ++countTrue;
        }
        if (conf.sequentialFusion) {
            ++countTrue;
        }
        if (conf.multipleImageFusion) {
            ++countTrue;
        }
        if (countTrue != 1) {
            throw new ConfigurationParserException("Error reading/parsing configuration file: Only one fusion method must be true!");
        }
        if (conf.debugLevel.toUpperCase().equals("DEBUG_ERRORONLY")) {
            conf.debugLevelInt = 2;
        }
        if (conf.debugLevel.toUpperCase().equals("DEBUG_MAIN")) {
            conf.debugLevelInt = 1;
        }
        if (conf.debugLevel.toUpperCase().equals("DEBUG_ALL")) {
            conf.debugLevelInt = 0;
        }
        conf.getFileNames();
        conf.interpolatorFactorOutput.setOutOfBoundsStrategyFactory(conf.strategyFactoryOutput);
        try {
            assignFile.close();
            confFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return conf;
    }

    public static void testDirectories(SPIMConfiguration conf) throws ConfigurationParserException {
        boolean success;
        File dir = new File(conf.outputdirectory, "");
        if (!dir.exists()) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Creating directory '" + conf.outputdirectory + "'.");
            success = dir.mkdirs();
            if (!success && !dir.exists()) {
                throw new ConfigurationParserException("(" + new Date(System.currentTimeMillis()) + "): Cannot create directory '" + conf.outputdirectory + "', quitting.");
            }
        }
        if (!(dir = new File(conf.registrationFiledirectory, "")).exists()) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Creating directory '" + conf.registrationFiledirectory + "'.");
            success = dir.mkdirs();
            if (!success && !dir.exists()) {
                throw new ConfigurationParserException("(" + new Date(System.currentTimeMillis()) + "): Cannot create directory '" + conf.registrationFiledirectory + "', quitting.");
            }
        }
    }

    private static int findEntry(ArrayList<ConfigurationParserObject> list, String entry) {
        int pos = -1;
        for (int i = 0; i < list.size() && pos == -1; ++i) {
            ConfigurationParserObject cpo = list.get(i);
            if (cpo.getEntry().toLowerCase().compareTo(entry.toLowerCase()) != 0) continue;
            pos = i;
        }
        return pos;
    }

    private static String getAllEntries(ArrayList<ConfigurationParserObject> list) {
        String entries = "";
        for (ConfigurationParserObject cpo : list) {
            entries = entries + cpo.getEntry() + "\n";
        }
        return entries;
    }
}

