/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.util;

import ij.ImagePlus;
import ij.io.Opener;
import ij.process.ImageProcessor;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.numeric.real.FloatType;

public class OpenImg {
    public static Img<FloatType> open(String name, ImgFactory<FloatType> factory) {
        Opener io = new Opener();
        ImagePlus imp = io.openImage(name);
        if (imp.getStack().getSize() > 1) {
            int depth = imp.getStack().getSize();
            Img img = factory.create(new long[]{imp.getWidth(), imp.getHeight(), depth}, (Object)new FloatType());
            int w = imp.getWidth();
            int h = imp.getHeight();
            RandomAccess r = img.randomAccess();
            int[] l = new int[3];
            for (int i = 0; i < depth; ++i) {
                ImageProcessor ip = imp.getStack().getProcessor(i + 1);
                l[2] = i;
                for (int y = 0; y < h; ++y) {
                    l[0] = 0;
                    l[1] = y;
                    r.setPosition(l);
                    for (int x = 0; x < w; ++x) {
                        ((FloatType)r.get()).set(ip.getPixelValue(x, y));
                        if (x >= w - 1) continue;
                        r.fwd(0);
                    }
                }
            }
            return img;
        }
        Img img = factory.create(new long[]{imp.getWidth(), imp.getHeight()}, (Object)new FloatType());
        ImageProcessor ip = imp.getProcessor();
        Cursor cursorOut = img.localizingCursor();
        while (cursorOut.hasNext()) {
            cursorOut.fwd();
            ((FloatType)cursorOut.get()).set(ip.getPixelValue(cursorOut.getIntPosition(0), cursorOut.getIntPosition(1)));
        }
        return img;
    }
}

