/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.reconstructreader.reconstruct;

import edu.utexas.clm.reconstructreader.Utils;
import edu.utexas.clm.reconstructreader.reconstruct.ContourSet;
import edu.utexas.clm.reconstructreader.reconstruct.ReconstructSection;
import edu.utexas.clm.reconstructreader.reconstruct.ReconstructTranslator;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class ReconstructAreaList
implements ContourSet {
    private final String name;
    private final int oid;
    private final int recContourID;
    private final int areaListID;
    private final ArrayList<Element> contourList;
    private final ArrayList<Integer> indexList;
    private final ReconstructTranslator translator;

    public ReconstructAreaList(Element e, ReconstructTranslator t, ReconstructSection rs) {
        this.translator = t;
        this.name = e.getAttribute("name");
        this.oid = this.translator.nextOID();
        this.recContourID = this.translator.nextOID();
        this.areaListID = this.translator.nextOID();
        this.contourList = new ArrayList();
        this.indexList = new ArrayList();
        this.contourList.add(e);
        this.indexList.add(rs.getIndex());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o instanceof ReconstructAreaList) {
            ReconstructAreaList ral = (ReconstructAreaList)o;
            return this.name.equals(ral.name);
        }
        if (o instanceof Element) {
            Element e = (Element)o;
            return this.name.equals(e.getAttribute("name"));
        }
        return false;
    }

    @Override
    public void addContour(Element e, ReconstructSection sec) {
        this.contourList.add(e);
        this.indexList.add(sec.getIndex());
    }

    public void appendProjectXML(StringBuilder sb) {
        sb.append("<reconstruct_contour id=\"").append(this.recContourID).append("\" title=\"").append(this.name).append("\" expanded=\"true\">\n<area_list id=\"").append(this.areaListID).append("\" oid=\"").append(this.oid).append("\"/>\n</reconstruct_contour>\n");
    }

    public void appendLayerSetXML(StringBuilder sb, List<ReconstructSection> sectionList) {
        ArrayList<Element> selectionList = new ArrayList<Element>();
        String fillColorHex = Utils.hexColor(this.contourList.get(0).getAttribute("fill"));
        String strokeColorHex = Utils.hexColor(this.contourList.get(0).getAttribute("border"));
        boolean visible = this.contourList.get(0).getAttribute("hidden").equals("false");
        sb.append("<t2_area_list\noid=\"").append(this.oid).append("\"\nwidth=\"").append(this.translator.getStackWidth()).append("\"\nheight=\"").append(this.translator.getStackHeight()).append("\"\ntransform=\"matrix(1.0,0.0,0.0,1.0,0,0)\"\nvisible=\"").append(visible).append("\"\ntitle=\"area_list\"\nlinks=\"\"\nlayer_set_id=\"0\"\nfill_paint=\"true\"\nstyle=\"stroke:#").append(strokeColorHex).append(";fill-opacity:0.4;fill:#").append(fillColorHex).append(";\"\n>\n");
        for (ReconstructSection sec : sectionList) {
            int index = sec.getIndex();
            int layerOID = sec.getOID();
            double h = sec.getHeight();
            Utils.selectElementsByIndex(this.contourList, this.indexList, selectionList, index);
            sb.append("<t2_area layer_id=\"").append(layerOID).append("\">\n");
            for (Element contour : selectionList) {
                double[] pts = Utils.getTransformedPoints(contour, h, sec.getMag());
                sb.append("<t2_path d=\"");
                Utils.appendClosedPathXML(sb, pts);
                sb.append("\" />\n");
            }
            sb.append("</t2_area>\n");
            selectionList.clear();
        }
        sb.append("</t2_area_list>\n");
    }
}

