/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.reconstructreader.reconstruct;

import edu.utexas.clm.reconstructreader.Utils;
import edu.utexas.clm.reconstructreader.reconstruct.ReconstructAreaList;
import edu.utexas.clm.reconstructreader.reconstruct.ReconstructProfileList;
import edu.utexas.clm.reconstructreader.reconstruct.ReconstructSection;
import edu.utexas.clm.reconstructreader.reconstruct.ReconstructZTrace;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ReconstructTranslator {
    private static final int STRING_CHUNK_SIZE = 8192;
    private StringBuilder xmlBuilder;
    private Document serDoc;
    private final ArrayList<Document> sectionDocuments;
    private final ArrayList<ReconstructSection> sections;
    private final ArrayList<ReconstructAreaList> closedContours;
    private final ArrayList<ReconstructProfileList> openContours;
    private final ArrayList<ReconstructZTrace> zTraces;
    private final String projectName;
    private final String unuid;
    private final String nuid;
    private final File inputFile;
    private String postTranslationMessage;
    private String errorMessage;
    private File lastFile;
    private int currentOID;
    private final int layerSetOID;
    private double[] preTransPatchSize;
    private double defaultMag;
    private boolean ready;
    private TranslationMessenger messenger;

    public static InputSource getISO8559Source(File f) throws FileNotFoundException, UnsupportedEncodingException {
        MalformedFileInputStream fileStream = new MalformedFileInputStream(f);
        InputStreamReader charStream = new InputStreamReader(fileStream);
        return new InputSource(charStream);
    }

    public static void addSection(List<Document> sectionDocuments, DocumentBuilder builder, File f) throws IOException, SAXException {
        MalformedFileInputStream fileStream = new MalformedFileInputStream(f);
        InputStreamReader charStream = new InputStreamReader(fileStream);
        Document d = builder.parse(new InputSource(charStream));
        sectionDocuments.add(d);
    }

    public ReconstructTranslator(String f) {
        this.inputFile = new File(f);
        String localFile = this.inputFile.getName();
        this.postTranslationMessage = "";
        this.errorMessage = "";
        this.lastFile = null;
        this.xmlBuilder = null;
        this.sectionDocuments = new ArrayList();
        this.sections = new ArrayList();
        this.zTraces = new ArrayList();
        this.closedContours = new ArrayList();
        this.openContours = new ArrayList();
        this.projectName = localFile.toLowerCase().endsWith(".ser") ? localFile.substring(0, localFile.length() - 4) : localFile;
        this.currentOID = -1;
        this.nuid = Integer.toString(this.projectName.hashCode());
        this.unuid = Long.toString(System.currentTimeMillis()) + "." + this.nuid;
        this.layerSetOID = this.nextOID();
        this.ready = true;
        this.messenger = new TranslationMessenger(){

            @Override
            public void sendMessage(String message) {
                System.err.println(message);
            }
        };
    }

    public int getLayerSetOID() {
        return this.layerSetOID;
    }

    public void setMessenger(TranslationMessenger inMessenger) {
        this.messenger = inMessenger;
    }

    public void log(String logString) {
        this.messenger.sendMessage(logString);
    }

    public boolean process() {
        if (this.ready) {
            this.xmlBuilder = new StringBuilder();
            this.sectionDocuments.clear();
            File[] sectionFiles = this.inputFile.getParentFile().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(ReconstructTranslator.this.projectName + ".[0-9]*$");
                }
            });
            try {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                builderFactory.setValidating(false);
                builderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                this.serDoc = builder.parse(this.inputFile);
                for (File f : sectionFiles) {
                    this.log("Opening file " + f.getAbsolutePath());
                    this.lastFile = f;
                    ReconstructTranslator.addSection(this.sectionDocuments, builder, f);
                }
                this.postTranslationMessage = this.fixXML(this.sectionDocuments);
                Collections.sort(this.sectionDocuments, new Utils.ReconstructSectionIndexComparator());
                this.preTransPatchSize = Utils.getReconstructStackSize(this.sectionDocuments);
                this.defaultMag = Utils.getMedianMag(this.sectionDocuments);
                this.collectContoursAndSections(this.sectionDocuments);
                this.collectZTraces(this.serDoc);
                this.xmlBuilder.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
                this.appendDTD(this.xmlBuilder);
                this.xmlBuilder.append("<trakem2>\n");
                this.appendProject(this.xmlBuilder);
                this.appendLayerSet(this.xmlBuilder);
                this.appendDisplay(this.xmlBuilder);
                this.xmlBuilder.append("</trakem2>\n");
                this.clearMemory();
                return true;
            }
            catch (SAXParseException spe) {
                String fid = this.lastFile == null ? "" : " in " + this.lastFile.getName();
                this.errorMessage = "Error while parsing XML" + fid + " at line " + spe.getLineNumber() + ", column " + spe.getColumnNumber() + "\n";
                this.errorMessage = this.errorMessage + Utils.stackTraceToString(spe);
                this.clearMemory();
                return false;
            }
            catch (Exception e) {
                this.clearMemory();
                e.printStackTrace();
                this.errorMessage = Utils.stackTraceToString(e);
                return false;
            }
        }
        return false;
    }

    public String getPostTranslationMessage() {
        return this.postTranslationMessage;
    }

    public String getLastErrorMessage() {
        return this.errorMessage;
    }

    protected void clearMemory() {
        this.sectionDocuments.clear();
        this.sections.clear();
        this.closedContours.clear();
        this.openContours.clear();
        this.zTraces.clear();
    }

    protected void collectZTraces(Document serFile) {
        NodeList zContours = serFile.getElementsByTagName("ZContour");
        for (int i = 0; i < zContours.getLength(); ++i) {
            Element e = (Element)zContours.item(i);
            ReconstructZTrace zTrace = Utils.findContourByName(this.zTraces, e.getAttribute("name"));
            if (zTrace == null) {
                this.zTraces.add(new ReconstructZTrace(e, this));
                continue;
            }
            zTrace.addContour(e, null);
        }
    }

    protected void collectContoursAndSections(List<Document> sectionDocs) {
        for (Document doc : sectionDocs) {
            int i;
            NodeList contours = doc.getElementsByTagName("Contour");
            ReconstructSection currSection = new ReconstructSection(this, doc);
            ArrayList<Element> domains = new ArrayList<Element>();
            NodeList images = doc.getElementsByTagName("Image");
            this.sections.add(currSection);
            for (i = 0; i < images.getLength(); ++i) {
                domains.add(Utils.getImageDomainContour(images.item(i)));
            }
            for (i = 0; i < contours.getLength(); ++i) {
                Element e = (Element)contours.item(i);
                if (e.getAttribute("closed").equals("true") && !domains.contains(e)) {
                    ReconstructAreaList areaList = Utils.findContourByName(this.closedContours, e.getAttribute("name"));
                    if (areaList == null) {
                        this.closedContours.add(new ReconstructAreaList(e, this, currSection));
                        continue;
                    }
                    areaList.addContour(e, currSection);
                    continue;
                }
                if (domains.contains(e)) continue;
                ReconstructProfileList profileList = Utils.findContourByName(this.openContours, e.getAttribute("name"));
                if (profileList == null) {
                    this.openContours.add(new ReconstructProfileList(e, this, currSection));
                    continue;
                }
                profileList.addContour(e, currSection);
            }
        }
        this.fixupSections();
    }

    private void fixupSections() {
        int i;
        double[] sectionThickness = new double[this.sections.size()];
        Vector<Integer> zeroIndices = new Vector<Integer>();
        for (i = 0; i < this.sections.size(); ++i) {
            sectionThickness[i] = this.sections.get(i).getThickness();
            if (!(sectionThickness[i] <= 0.0)) continue;
            zeroIndices.add(i);
        }
        if (zeroIndices.size() > 0) {
            ArrayList<Double> nbd = new ArrayList<Double>(5);
            Iterator iterator = zeroIndices.iterator();
            while (iterator.hasNext()) {
                int i2 = (Integer)iterator.next();
                int offset = 1;
                int condition = 0;
                nbd.clear();
                while (condition < 2 && nbd.size() < 5) {
                    int checkIndex = i2 + offset;
                    if (checkIndex < 0) {
                        ++condition;
                    } else if (checkIndex >= sectionThickness.length) {
                        ++condition;
                    } else if (sectionThickness[checkIndex] > 0.0) {
                        nbd.add(sectionThickness[checkIndex]);
                    }
                    offset = offset > 0 ? -offset : -offset + 1;
                }
                Collections.sort(nbd);
                this.sections.get(i2).setThickness((Double)nbd.get(nbd.size() / 2));
            }
            this.log("There are " + zeroIndices.size() + " sections out of " + this.sections.size() + " with zero section thickness.\nThey will be given a best-guess thickness for use with TrakEM2.");
        }
        this.sections.get(0).setZ((double)this.sections.get(0).getIndex() * this.sections.get(0).getThickness());
        for (i = 1; i < this.sections.size(); ++i) {
            this.sections.get(i).setZFromPrevious(this.sections.get(i - 1));
        }
    }

    protected String getUNUID() {
        return this.unuid;
    }

    protected String getMipMapFolder() {
        return "trakem2." + this.nuid + "/trakem2.mipmaps";
    }

    protected void appendDTD(StringBuilder sb) {
        sb.append("<!DOCTYPE trakem2_reconstruct [\n\t<!ELEMENT trakem2 (project,t2_layer_set,t2_display)>\n\t<!ELEMENT project (reconstruct)>\n\t<!ATTLIST project id NMTOKEN #REQUIRED>\n\t<!ATTLIST project unuid NMTOKEN #REQUIRED>\n\t<!ATTLIST project title NMTOKEN #REQUIRED>\n\t<!ATTLIST project preprocessor NMTOKEN #REQUIRED>\n\t<!ATTLIST project mipmaps_folder NMTOKEN #REQUIRED>\n\t<!ATTLIST project storage_folder NMTOKEN #REQUIRED>\n\t<!ELEMENT reconstruct (reconstruct_contour, reconstruct_ztrace, reconstruct_open_trace)>\n\t<!ATTLIST reconstruct id NMTOKEN #REQUIRED>\n\t<!ATTLIST reconstruct expanded NMTOKEN #REQUIRED>\n\t<!ELEMENT reconstruct_contour (area_list)>\n\t<!ATTLIST reconstruct_contour id NMTOKEN #REQUIRED>\n\t<!ATTLIST reconstruct_contour expanded NMTOKEN #REQUIRED>\n\t<!ELEMENT area_list EMPTY>\n\t<!ATTLIST area_list id NMTOKEN #REQUIRED>\n\t<!ATTLIST area_list oid NMTOKEN #REQUIRED>\n\t<!ATTLIST area_list expanded NMTOKEN #REQUIRED>\n\t<!ELEMENT reconstruct_ztrace (polyline)>\n\t<!ATTLIST reconstruct_ztrace id NMTOKEN #REQUIRED>\n\t<!ATTLIST reconstruct_ztrace expanded NMTOKEN #REQUIRED>\n\t<!ELEMENT polyline EMPTY>\n\t<!ATTLIST polyline id NMTOKEN #REQUIRED>\n\t<!ATTLIST polyline oid NMTOKEN #REQUIRED>\n\t<!ATTLIST polyline expanded NMTOKEN #REQUIRED>\n\t<!ELEMENT reconstruct_open_trace (profile_list)>\n\t<!ATTLIST reconstruct_open_trace id NMTOKEN #REQUIRED>\n\t<!ATTLIST reconstruct_open_trace expanded NMTOKEN #REQUIRED>\n\t<!ELEMENT profile_list (profile)>\n\t<!ATTLIST profile_list id NMTOKEN #REQUIRED>\n\t<!ATTLIST profile_list oid NMTOKEN #REQUIRED>\n\t<!ATTLIST profile_list expanded NMTOKEN #REQUIRED>\n\t<!ELEMENT profile EMPTY>\n\t<!ATTLIST profile id NMTOKEN #REQUIRED>\n\t<!ATTLIST profile oid NMTOKEN #REQUIRED>\n\t<!ATTLIST profile expanded NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_layer (t2_patch,t2_label,t2_layer_set,t2_profile)>\n\t<!ATTLIST t2_layer oid NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer thickness NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer z NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_layer_set (t2_prop,t2_linked_prop,t2_annot,t2_layer,t2_pipe,t2_ball,t2_area_list,t2_calibration,t2_stack,t2_treeline)>\n\t<!ATTLIST t2_layer_set oid NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set layer_id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set transform NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set style NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set locked NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set visible NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set title NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set links NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set composite NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set layer_width NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set layer_height NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set rot_x NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set rot_y NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set rot_z NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set snapshots_quality NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set color_cues NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set area_color_cues NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set avoid_color_cue_colors NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set n_layers_color_cue NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set paint_arrows NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_layer_set paint_edge_confidence_boxes NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_calibration EMPTY>\n\t<!ATTLIST t2_calibration pixelWidth NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_calibration pixelHeight NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_calibration pixelDepth NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_calibration xOrigin NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_calibration yOrigin NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_calibration zOrigin NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_calibration info NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_calibration valueUnit NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_calibration timeUnit NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_calibration unit NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_ball (t2_prop,t2_linked_prop,t2_annot,t2_ball_ob)>\n\t<!ATTLIST t2_ball oid NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_ball layer_id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_ball transform NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_ball style NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_ball locked NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_ball visible NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_ball title NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_ball links NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_ball composite NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_ball fill NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_ball_ob EMPTY>\n\t<!ATTLIST t2_ball_ob x NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_ball_ob y NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_ball_ob r NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_ball_ob layer_id NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_label (t2_prop,t2_linked_prop,t2_annot)>\n\t<!ATTLIST t2_label oid NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_label layer_id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_label transform NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_label style NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_label locked NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_label visible NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_label title NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_label links NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_label composite NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_patch (t2_prop,t2_linked_prop,t2_annot,ict_transform,ict_transform_list)>\n\t<!ATTLIST t2_patch oid NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_patch layer_id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_patch transform NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_patch style NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_patch locked NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_patch visible NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_patch title NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_patch links NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_patch composite NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_patch file_path NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_patch original_path NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_patch type NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_patch ct NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_patch o_width NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_patch o_height NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_patch pps NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_pipe (t2_prop,t2_linked_prop,t2_annot)>\n\t<!ATTLIST t2_pipe oid NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_pipe layer_id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_pipe transform NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_pipe style NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_pipe locked NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_pipe visible NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_pipe title NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_pipe links NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_pipe composite NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_pipe d NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_pipe p_width NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_pipe layer_ids NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_polyline (t2_prop,t2_linked_prop,t2_annot)>\n\t<!ATTLIST t2_polyline oid NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_polyline layer_id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_polyline transform NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_polyline style NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_polyline locked NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_polyline visible NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_polyline title NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_polyline links NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_polyline composite NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_polyline d NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_profile (t2_prop,t2_linked_prop,t2_annot)>\n\t<!ATTLIST t2_profile oid NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_profile layer_id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_profile transform NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_profile style NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_profile locked NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_profile visible NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_profile title NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_profile links NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_profile composite NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_profile d NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_area_list (t2_prop,t2_linked_prop,t2_annot,t2_area)>\n\t<!ATTLIST t2_area_list oid NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_area_list layer_id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_area_list transform NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_area_list style NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_area_list locked NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_area_list visible NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_area_list title NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_area_list links NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_area_list composite NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_area_list fill_paint NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_area (t2_path)>\n\t<!ATTLIST t2_area layer_id NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_path EMPTY>\n\t<!ATTLIST t2_path d NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_dissector (t2_prop,t2_linked_prop,t2_annot,t2_dd_item)>\n\t<!ATTLIST t2_dissector oid NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_dissector layer_id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_dissector transform NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_dissector style NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_dissector locked NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_dissector visible NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_dissector title NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_dissector links NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_dissector composite NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_dd_item EMPTY>\n\t<!ATTLIST t2_dd_item radius NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_dd_item tag NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_dd_item points NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_stack (t2_prop,t2_linked_prop,t2_annot,(iict_transform|iict_transform_list)?)>\n\t<!ATTLIST t2_stack oid NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_stack layer_id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_stack transform NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_stack style NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_stack locked NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_stack visible NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_stack title NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_stack links NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_stack composite NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_stack file_path CDATA #REQUIRED>\n\t<!ATTLIST t2_stack depth CDATA #REQUIRED>\n\t<!ELEMENT t2_tag EMPTY>\n\t<!ATTLIST t2_tag name NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_tag key NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_node (t2_area*,t2_tag*)>\n\t<!ATTLIST t2_node x NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_node y NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_node lid NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_node c NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_node r NMTOKEN #IMPLIED>\n\t<!ELEMENT t2_treeline (t2_node*,t2_prop,t2_linked_prop,t2_annot)>\n\t<!ATTLIST t2_treeline oid NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_treeline layer_id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_treeline transform NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_treeline style NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_treeline locked NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_treeline visible NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_treeline title NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_treeline links NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_treeline composite NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_areatree (t2_node*,t2_prop,t2_linked_prop,t2_annot)>\n\t<!ATTLIST t2_areatree oid NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_areatree layer_id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_areatree transform NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_areatree style NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_areatree locked NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_areatree visible NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_areatree title NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_areatree links NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_areatree composite NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_connector (t2_node*,t2_prop,t2_linked_prop,t2_annot)>\n\t<!ATTLIST t2_connector oid NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_connector layer_id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_connector transform NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_connector style NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_connector locked NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_connector visible NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_connector title NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_connector links NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_connector composite NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_prop EMPTY>\n\t<!ATTLIST t2_prop key NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_prop value NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_linked_prop EMPTY>\n\t<!ATTLIST t2_linked_prop target_id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_linked_prop key NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_linked_prop value NMTOKEN #REQUIRED>\n\t<!ELEMENT t2_annot EMPTY>\n\t<!ELEMENT t2_display EMPTY>\n\t<!ATTLIST t2_display id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display layer_id NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display x NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display y NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display magnification NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display srcrect_x NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display srcrect_y NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display srcrect_width NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display srcrect_height NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display scroll_step NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display c_alphas NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display c_alphas_state NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display filter_enabled NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display filter_min_max_enabled NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display filter_min NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display filter_max NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display filter_invert NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display filter_clahe_enabled NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display filter_clahe_block_size NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display filter_clahe_histogram_bins NMTOKEN #REQUIRED>\n\t<!ATTLIST t2_display filter_clahe_max_slope NMTOKEN #REQUIRED>\n\t<!ELEMENT ict_transform EMPTY>\n\t<!ATTLIST ict_transform class CDATA #REQUIRED>\n\t<!ATTLIST ict_transform data CDATA #REQUIRED>\n\t<!ELEMENT iict_transform EMPTY>\n\t<!ATTLIST iict_transform class CDATA #REQUIRED>\n\t<!ATTLIST iict_transform data CDATA #REQUIRED>\n\t<!ELEMENT ict_transform_list (ict_transform|iict_transform)*>\n\t<!ELEMENT iict_transform_list (iict_transform*)>\n] >\n");
    }

    protected void appendProject(StringBuilder sb) {
        sb.append("<project\n");
        sb.append("id=\"0\"\n");
        sb.append("title=\"").append(this.projectName).append("\"\n");
        sb.append("unuid=\"").append(this.getUNUID()).append("\"\n");
        sb.append("mipmaps_folder=\"").append(this.getMipMapFolder()).append("\"\n");
        sb.append("storage_folder=\"\"\n");
        sb.append("mipmaps_format=\"0\"\n");
        sb.append(">\n");
        sb.append("<reconstruct id=\"").append(this.nextOID()).append("\" expanded=\"true\">\n");
        for (ReconstructProfileList rpl : this.openContours) {
            rpl.appendProjectXML(sb);
        }
        for (ReconstructAreaList ral : this.closedContours) {
            ral.appendProjectXML(sb);
        }
        for (ReconstructZTrace rzt : this.zTraces) {
            rzt.appendProjectXML(sb);
        }
        sb.append("</reconstruct>\n");
        sb.append("</project>\n");
    }

    protected void appendLayerSet(StringBuilder sb) {
        Node image = this.sectionDocuments.get(0).getElementsByTagName("Image").item(0);
        sb.append("<t2_layer_set\n");
        sb.append("oid=\"").append(this.layerSetOID).append("\"\n");
        sb.append("width=\"20.0\"\n");
        sb.append("height=\"20.0\"\n");
        sb.append("transform=\"matrix(1.0,0.0,0.0,1.0,0.0,0.0)\"\n");
        sb.append("title=\"Top Level\"\n");
        sb.append("links=\"\"\n");
        sb.append("layer_width=\"").append(this.getStackWidth()).append("\"\n");
        sb.append("layer_height=\"").append(this.getStackHeight()).append("\"\n");
        sb.append("rot_x=\"0.0\"\n");
        sb.append("rot_y=\"0.0\"\n");
        sb.append("rot_z=\"0.0\"\n");
        sb.append("snapshots_quality=\"true\"\n");
        sb.append("snapshots_mode=\"Full\"\n");
        sb.append("color_cues=\"false\"\n");
        sb.append("area_color_cues=\"false\"\n");
        sb.append("avoid_color_cue_colors=\"false\"\n");
        sb.append("n_layers_color_cue=\"-1\"\n");
        sb.append("paint_arrows=\"true\"\n");
        sb.append("paint_edge_confidence_boxes=\"true\"\n");
        sb.append("prepaint=\"true\"\n");
        sb.append(">\n");
        this.appendCalibration(sb);
        for (ReconstructAreaList ral : this.closedContours) {
            ral.appendLayerSetXML(sb, this.sections);
        }
        for (ReconstructZTrace rzt : this.zTraces) {
            rzt.appendXML(sb);
        }
        for (ReconstructSection rs : this.sections) {
            rs.appendXML(sb);
        }
        sb.append("</t2_layer_set>\n");
    }

    protected void appendCalibration(StringBuilder sb) {
        Element image = (Element)this.sectionDocuments.get(0).getElementsByTagName("Image").item(0);
        String mag = image.hasAttribute("t2mag") ? image.getAttribute("t2mag") : image.getAttribute("mag");
        String thickness = this.sectionDocuments.get(0).getDocumentElement().getAttribute("thickness");
        sb.append("<t2_calibration\npixelWidth=\"").append(mag).append("\"\npixelHeight=\"").append(mag).append("\"\npixelDepth=\"").append(thickness).append("\"\nxOrigin=\"0.0\"\nyOrigin=\"0.0\"\ntzOrigin=\"0.0\"\ninfo=\"null\"\nvalueUnit=\"Gray Value\"\ntimeUnit=\"sec\"\nunit=\"pixel\"\n/>\n");
    }

    protected void appendDisplay(StringBuilder sb) {
        sb.append("<t2_display id=\"7\"\nlayer_id=\"").append(this.sections.get(0).getOID()).append("\"\nc_alphas=\"-1\"\nc_alphas_state=\"-1\"\nx=\"1276\"\ny=\"-3\"\nmagnification=\"0.39615630662788986\"\nsrcrect_x=\"0\"\nsrcrect_y=\"0\"\nsrcrect_width=\"4096\"\nsrcrect_height=\"2974\"\nscroll_step=\"1\"\n/>\n");
    }

    public int nextOID() {
        return ++this.currentOID;
    }

    public int layerIndexToOID(int index) {
        for (ReconstructSection sec : this.sections) {
            if (sec.getIndex() != index) continue;
            return sec.getOID();
        }
        return -1;
    }

    public double getStackHeight() {
        return this.preTransPatchSize[1];
    }

    public double getStackWidth() {
        return this.preTransPatchSize[0];
    }

    public String writeTrakEM2() {
        String trakEMFile = this.inputFile.getParentFile().getAbsolutePath() + "/" + this.projectName + ".xml";
        this.xmlBuilder.append('\n');
        try {
            int i;
            FileWriter fw = new FileWriter(new File(trakEMFile));
            String xmlString = this.xmlBuilder.toString();
            int n = xmlString.length();
            int t = n - 8192;
            this.xmlBuilder = null;
            System.gc();
            for (i = 0; i < t; i += 8192) {
                fw.write(xmlString, i, 8192);
            }
            fw.write(xmlString, i, n - i - 1);
            fw.close();
            return trakEMFile;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public double getMag() {
        return this.defaultMag;
    }

    private String fixXML(Collection<Document> secDocs) {
        String message = this.fixNonlinearTransforms(secDocs);
        message = message + this.fixTransformScale(secDocs);
        return message;
    }

    private String fixTransformScale(Collection<Document> secDocs) {
        double minScale;
        double[] sectionScale = new double[secDocs.size()];
        double maxScale = minScale = this.calculateTransformScale(secDocs, sectionScale);
        if (minScale != 1.0 && !Double.isInfinite(minScale)) {
            Object object = secDocs.iterator();
            while (object.hasNext()) {
                Document d = (Document)object.next();
                if (this.nonlinearDocument(d)) continue;
                NodeList nl = d.getElementsByTagName("Transform");
                for (int i = 0; i < nl.getLength(); ++i) {
                    this.unscaleTransform((Element)nl.item(i), minScale);
                }
            }
        }
        for (double scale : sectionScale) {
            if (scale == 0.0 || Double.isInfinite(scale) || !(Math.abs((double)(scale - 1.0)) > Math.abs(maxScale - 1.0))) continue;
            maxScale = scale;
        }
        if (Double.isInfinite(minScale)) {
            this.messenger.sendMessage("Reconstruct project has no golden section. This may or may not be problematic");
            return "";
        }
        if (maxScale != minScale) {
            return "This Reconstruct project has been re-calibrated using the scale method.\nThe detected scale was " + minScale + ", but multiple valid scales were detected,\nthe extremum of which was " + maxScale + ".\nPlease verify that  the areas of your traces have not changed.";
        }
        if (minScale != 1.0) {
            return "This Reconstruct project has been re-calibrated using the scale method.\nThe detected scale was " + minScale + ".\nPlease verify that  the areas of your traces have not changed.";
        }
        return "";
    }

    private double calculateTransformScale(Collection<Document> secDocs, double[] sectionScale) {
        double scale = Double.POSITIVE_INFINITY;
        double scaleDistance = scale - 1.0;
        int sIndex = 0;
        for (Document doc : secDocs) {
            Element trans = Utils.getFirstImageTransformElement(doc);
            sectionScale[sIndex] = 0.0;
            if (trans != null && !this.nonlinearDocument(doc)) {
                double[] xcoefs = Utils.createNodeValueVector(trans.getAttribute("xcoef"));
                double[] ycoefs = Utils.createNodeValueVector(trans.getAttribute("ycoef"));
                Utils.nodeValueToVector(trans.getAttribute("xcoef"), xcoefs);
                Utils.nodeValueToVector(trans.getAttribute("ycoef"), ycoefs);
                boolean ok = true;
                for (int i : new int[]{2, 3, 4, 5}) {
                    ok &= xcoefs[i] == 0.0;
                }
                for (int i : new int[]{1, 3, 4, 5}) {
                    ok &= ycoefs[i] == 0.0;
                }
                if (ok &= xcoefs[1] == ycoefs[2]) {
                    double transScale = xcoefs[1];
                    double transScaleDistance = Math.abs(transScale - 1.0);
                    sectionScale[sIndex] = scale;
                    if (transScaleDistance < scaleDistance) {
                        scale = transScale;
                        scaleDistance = transScaleDistance;
                    }
                }
            }
            ++sIndex;
        }
        return scale;
    }

    private void unscaleTransform(Element trans, double scale) {
        int dim = Integer.valueOf(trans.getAttribute("dim"));
        double unscale = 1.0 / scale;
        double[] xcoefs = Utils.createNodeValueVector(trans.getAttribute("xcoef"));
        double[] ycoefs = Utils.createNodeValueVector(trans.getAttribute("ycoef"));
        NodeList nl = trans.getChildNodes();
        Utils.nodeValueToVector(trans.getAttribute("xcoef"), xcoefs);
        Utils.nodeValueToVector(trans.getAttribute("ycoef"), ycoefs);
        switch (dim) {
            case 0: {
                trans.setAttribute("dim", "2");
                trans.setAttribute("xcoef", "0 " + unscale + " 0 0 0 0");
                trans.setAttribute("ycoef", "0 " + unscale + " 0 0 0 0");
                break;
            }
            case 1: {
                trans.setAttribute("dim", "2");
                trans.setAttribute("xcoef", "" + xcoefs[0] + " " + unscale + " 0 0 0 0");
                trans.setAttribute("ycoef", "" + ycoefs[0] + " " + unscale + " 0 0 0 0");
                break;
            }
            case 2: {
                trans.setAttribute("xcoef", "" + xcoefs[0] + " " + unscale * xcoefs[1] + " 0 0 0 0");
                trans.setAttribute("ycoef", "" + ycoefs[0] + " " + unscale * ycoefs[1] + " 0 0 0 0");
                break;
            }
            default: {
                trans.setAttribute("xcoef", "" + xcoefs[0] + " " + unscale * xcoefs[1] + " " + unscale * xcoefs[2] + " 0 0 0");
                trans.setAttribute("ycoef", "" + ycoefs[0] + " " + unscale * ycoefs[1] + " " + unscale * ycoefs[2] + " 0 0 0");
            }
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals("Image")) continue;
            Element im = (Element)nl.item(i);
            double mag = Double.parseDouble(im.getAttribute("mag"));
            this.messenger.sendMessage("Image mag changed from " + mag + " to " + mag * unscale);
            im.setAttribute("t2mag", "" + mag * unscale);
        }
    }

    private String fixNonlinearTransforms(Collection<Document> secDocs) {
        String message = "";
        String unalignedMessage = "Nonlinear Reconstruct alignments are incompatible with TrakEM2.\nAt least one was found in your project.\nEach such section has been reset to an unaligned section.\n\n";
        for (Document secDoc : secDocs) {
            Element transform = Utils.getFirstImageTransformElement(secDoc);
            if (this.isNonLinear(transform)) {
                message = unalignedMessage;
                this.fixImageTransform(secDoc, this.imageElement(transform));
                continue;
            }
            NodeList transforms = secDoc.getElementsByTagName("Transform");
            for (int i = 0; i < transforms.getLength(); ++i) {
                transform = (Element)transforms.item(i);
                if (this.imageElement(transform) != null) continue;
                this.fixContourTransforms(transform);
            }
        }
        return message;
    }

    private boolean isNonLinear(Element transform) {
        if (transform == null) {
            return false;
        }
        int dim = Integer.parseInt(transform.getAttribute("dim"));
        if (dim > 3) {
            double[] xcoef = new double[6];
            double[] ycoef = new double[6];
            boolean test = false;
            Utils.nodeValueToVector(transform.getAttribute("xcoef"), xcoef);
            Utils.nodeValueToVector(transform.getAttribute("ycoef"), ycoef);
            for (int j = 3; j < 6 && !test; ++j) {
                if (xcoef[j] == 0.0 && ycoef[j] == 0.0) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private Element imageElement(Element transform) {
        NodeList children = transform.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!children.item(i).getNodeName().equals("Image")) continue;
            return (Element)children.item(i);
        }
        return null;
    }

    private boolean nonlinearDocument(Document doc) {
        return doc.getDocumentElement().hasAttribute("nonlinear");
    }

    private void fixImageTransform(Document secDoc, Element image) {
        Element imageTransform = (Element)image.getParentNode();
        double[] xcoef = new double[6];
        double[] ycoef = new double[6];
        Utils.nodeValueToVector(imageTransform.getAttribute("xcoef"), xcoef);
        Utils.nodeValueToVector(imageTransform.getAttribute("ycoef"), ycoef);
        NodeList transforms = secDoc.getElementsByTagName("Transform");
        for (int i = 0; i < transforms.getLength(); ++i) {
            Element transform = (Element)transforms.item(i);
            if (transform == imageTransform) continue;
            NodeList contours = this.fixContourTransforms(transform);
            for (int j = 0; j < contours.getLength(); ++j) {
                this.applyTransform(contours.item(j), xcoef, ycoef, 6, true);
            }
        }
        imageTransform.setAttribute("xcoef", "0 1 0 0 0 0");
        imageTransform.setAttribute("ycoef", "0 0 1 0 0 0");
        imageTransform.setAttribute("dim", "0");
        secDoc.getDocumentElement().setAttribute("nonlinear", "true");
    }

    private NodeList fixContourTransforms(Element transform) {
        int dim = Integer.parseInt(transform.getAttribute("dim"));
        double[] xcoef = new double[6];
        double[] ycoef = new double[6];
        NodeList contours = transform.getElementsByTagName("Contour");
        Utils.nodeValueToVector(transform.getAttribute("xcoef"), xcoef);
        Utils.nodeValueToVector(transform.getAttribute("ycoef"), ycoef);
        for (int j = 0; j < contours.getLength(); ++j) {
            this.applyTransform(contours.item(j), xcoef, ycoef, dim, false);
        }
        transform.setAttribute("xcoef", "0 1 0 0 0 0");
        transform.setAttribute("ycoef", "0 0 1 0 0 0");
        transform.setAttribute("dim", "0");
        return contours;
    }

    private void applyTransform(Node node, double[] xcoef, double[] ycoef, int dim, boolean fwd) {
        Element contour = (Element)node;
        String strPoints = contour.getAttribute("points");
        double[] pts = Utils.createNodeValueVector(strPoints);
        StringBuilder sbTransPts = new StringBuilder();
        Utils.nodeValueToVector(strPoints, pts);
        if (fwd) {
            this.fwdTrans(xcoef, ycoef, pts, dim);
        } else {
            this.revTrans(xcoef, ycoef, pts, dim);
        }
        for (int i = 0; i < pts.length; i += 2) {
            sbTransPts.append(pts[i]).append(" ").append(pts[i + 1]).append(",\n");
        }
        contour.setAttribute("points", sbTransPts.toString());
    }

    private void fwdTrans(double[] a, double[] b, double[] pts, int dim) {
        if (dim <= 3) {
            double[] matrix = new double[6];
            switch (dim) {
                case 0: {
                    matrix[0] = 1.0;
                    matrix[3] = 1.0;
                }
                case 1: {
                    matrix[0] = 1.0;
                    matrix[3] = 1.0;
                    matrix[4] = a[0];
                    matrix[5] = b[0];
                    break;
                }
                case 2: {
                    matrix[0] = a[1];
                    matrix[3] = b[1];
                    matrix[4] = a[0];
                    matrix[5] = a[0];
                    break;
                }
                case 3: {
                    matrix[0] = a[1];
                    matrix[1] = b[1];
                    matrix[2] = a[2];
                    matrix[3] = b[2];
                    matrix[4] = a[0];
                    matrix[5] = b[0];
                }
            }
            AffineTransform at = new AffineTransform(matrix);
            at.transform(pts, 0, pts, 0, pts.length / 2);
        } else {
            for (int i = 0; i < pts.length; i += 2) {
                double x = pts[i];
                double y = pts[i + 1];
                pts[i] = a[0] + (a[1] + a[3] * y + a[4] * x) * x + (a[2] + a[5] * y) * y;
                pts[i + 1] = b[0] + (b[1] + b[3] * y + b[4] * x) * x + (b[2] + b[5] * y) * y;
            }
        }
    }

    private void revTrans(double[] a, double[] b, double[] pts, int dim) {
        if (dim <= 3) {
            double[] matrix = new double[6];
            switch (dim) {
                case 0: {
                    matrix[0] = 1.0;
                    matrix[3] = 1.0;
                }
                case 1: {
                    matrix[0] = 1.0;
                    matrix[3] = 1.0;
                    matrix[4] = a[0];
                    matrix[5] = b[0];
                    break;
                }
                case 2: {
                    matrix[0] = a[1];
                    matrix[3] = b[1];
                    matrix[4] = a[0];
                    matrix[5] = a[0];
                    break;
                }
                case 3: {
                    matrix[0] = a[1];
                    matrix[1] = b[1];
                    matrix[2] = a[2];
                    matrix[3] = b[2];
                    matrix[4] = a[0];
                    matrix[5] = b[0];
                }
            }
            AffineTransform at = new AffineTransform(matrix);
            try {
                at.inverseTransform(pts, 0, pts, 0, pts.length / 2);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {}
        } else {
            double epsilon = 5.0E-10;
            for (int j = 0; j < pts.length; j += 2) {
                double x = pts[j];
                double y = pts[j + 1];
                double[] uv0 = new double[]{0.0, 0.0};
                double u = x;
                double v = y;
                double x0 = 0.0;
                double y0 = 0.0;
                this.fwdTrans(a, b, uv0, dim);
                int i = 0;
                double e = 1.0;
                while (e > epsilon && i < 10) {
                    ++i;
                    double l = a[1] + a[3] * y0 + 2.0 * a[4] * x0;
                    double o = b[2] + b[3] * x0 + 2.0 * b[5] * y0;
                    double m = a[2] + a[3] * x0 + 2.0 * a[5] * y0;
                    double n = b[1] + b[3] * y0 + 2.0 * b[4] * x0;
                    double p = l * o - m * n;
                    if (Math.abs(p) > epsilon) {
                        x0 += (o * (u - uv0[0]) - m * (v - uv0[1])) / p;
                        y0 += (l * (v - uv0[1]) - n * (u - uv0[0])) / p;
                    } else {
                        x0 += l * (u - uv0[0]) + n * (v - uv0[1]);
                        y0 += m * (u - uv0[0]) + o * (v - uv0[1]);
                    }
                    uv0 = new double[]{x0, y0};
                    this.fwdTrans(a, b, uv0, dim);
                    e = Math.abs(u - uv0[0]) + Math.abs(v - uv0[1]);
                }
                pts[j] = x0;
                pts[j + 1] = y0;
            }
        }
    }

    private static class MalformedFileInputStream
    extends FilterInputStream {
        int fixCnt = 0;
        int[] callCnt = new int[3];
        byte[] lastByte;

        public MalformedFileInputStream(File f) throws FileNotFoundException {
            super(new FileInputStream(f));
            Arrays.fill(this.callCnt, 0);
            this.lastByte = new byte[0];
        }

        private byte fixByte(byte b) {
            if (b < 32 && b != 9 && b != 10 || b == 38) {
                ++this.fixCnt;
                b = (byte)32;
            }
            return b;
        }

        @Override
        public int read(byte[] bs, int off, int len) throws IOException {
            int ret = super.read(bs, off, len);
            this.callCnt[0] = this.callCnt[0] + 1;
            for (int i = 0; i < bs.length; ++i) {
                bs[i] = this.fixByte(bs[i]);
            }
            this.lastByte = (byte[])bs.clone();
            return ret;
        }

        @Override
        public int read(byte[] bs) throws IOException {
            int ret = super.read(bs);
            this.callCnt[1] = this.callCnt[1] + 1;
            for (int i = 0; i < bs.length; ++i) {
                bs[i] = this.fixByte(bs[i]);
            }
            this.lastByte = (byte[])bs.clone();
            return ret;
        }

        @Override
        public int read() throws IOException {
            int read = super.read();
            this.callCnt[2] = this.callCnt[2] + 1;
            if (read != -1) {
                read = this.fixByte((byte)read);
            }
            return read;
        }

        public String toString() {
            String s = "Called " + this.callCnt[0] + " " + this.callCnt[1] + " " + this.callCnt[2] + ", and fixed " + this.fixCnt + '\n';
            s = s + "[";
            for (byte b : this.lastByte) {
                s = s + b + " ";
            }
            s = s + "];";
            return s;
        }
    }

    public static interface TranslationMessenger {
        public void sendMessage(String var1);
    }
}

