/*
 * Decompiled with CFR 0.152.
 */
package io.scif.codec;

import io.scif.FormatException;
import io.scif.codec.AbstractCodec;
import io.scif.codec.Codec;
import io.scif.codec.CodecOptions;
import io.scif.codec.JPEG2000CodecOptions;
import io.scif.gui.AWTImageTools;
import io.scif.gui.UnsignedIntBuffer;
import io.scif.services.JAIIIOService;
import io.scif.services.ServiceException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=Codec.class)
public class JPEG2000Codec
extends AbstractCodec {
    @Parameter
    private JAIIIOService jaiIIOService;

    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        Object s;
        if (data == null || data.length == 0) {
            return data;
        }
        JPEG2000CodecOptions j2kOptions = options instanceof JPEG2000CodecOptions ? (JPEG2000CodecOptions)options : JPEG2000CodecOptions.getDefaultOptions(options);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedImage img = null;
        int next = 0;
        int plane = j2kOptions.width * j2kOptions.height;
        if (j2kOptions.bitsPerSample == 8) {
            byte[][] b = new byte[j2kOptions.channels][plane];
            if (j2kOptions.interleaved) {
                for (int q = 0; q < plane; ++q) {
                    for (int c = 0; c < j2kOptions.channels; ++c) {
                        b[c][q] = data[next++];
                    }
                }
            } else {
                for (int c = 0; c < j2kOptions.channels; ++c) {
                    System.arraycopy(data, c * plane, b[c], 0, plane);
                }
            }
            DataBufferByte buffer = new DataBufferByte(b, plane);
            img = AWTImageTools.constructImage(b.length, 0, j2kOptions.width, j2kOptions.height, false, true, buffer, j2kOptions.colorModel);
        } else if (j2kOptions.bitsPerSample == 16) {
            s = new short[j2kOptions.channels][plane];
            if (j2kOptions.interleaved) {
                for (int q = 0; q < plane; ++q) {
                    for (int c = 0; c < j2kOptions.channels; ++c) {
                        s[c][q] = Bytes.toShort((byte[])data, (int)next, (int)2, (boolean)j2kOptions.littleEndian);
                        next += 2;
                    }
                }
            } else {
                for (int c = 0; c < j2kOptions.channels; ++c) {
                    for (int q = 0; q < plane; ++q) {
                        s[c][q] = Bytes.toShort((byte[])data, (int)next, (int)2, (boolean)j2kOptions.littleEndian);
                        next += 2;
                    }
                }
            }
            DataBufferUShort buffer = new DataBufferUShort((short[][])s, plane);
            img = AWTImageTools.constructImage(((short[][])s).length, 1, j2kOptions.width, j2kOptions.height, false, true, buffer, j2kOptions.colorModel);
        } else if (j2kOptions.bitsPerSample == 32) {
            s = new int[j2kOptions.channels][plane];
            if (j2kOptions.interleaved) {
                for (int q = 0; q < plane; ++q) {
                    for (int c = 0; c < j2kOptions.channels; ++c) {
                        s[c][q] = Bytes.toInt((byte[])data, (int)next, (int)4, (boolean)j2kOptions.littleEndian);
                        next += 4;
                    }
                }
            } else {
                for (int c = 0; c < j2kOptions.channels; ++c) {
                    for (int q = 0; q < plane; ++q) {
                        s[c][q] = Bytes.toInt((byte[])data, (int)next, (int)4, (boolean)j2kOptions.littleEndian);
                        next += 4;
                    }
                }
            }
            UnsignedIntBuffer buffer = new UnsignedIntBuffer((int[][])s, plane);
            img = AWTImageTools.constructImage(((short[][])s).length, 3, j2kOptions.width, j2kOptions.height, false, true, buffer, j2kOptions.colorModel);
        }
        try {
            this.jaiIIOService.writeImage(out, img, j2kOptions);
        }
        catch (IOException e) {
            throw new FormatException("Could not compress JPEG-2000 data.", e);
        }
        catch (ServiceException e) {
            throw new FormatException("Could not compress JPEG-2000 data.", e);
        }
        return out.toByteArray();
    }

    @Override
    public byte[] decompress(DataHandle<Location> in, CodecOptions options) throws FormatException, IOException {
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        if (options == null || !(options instanceof JPEG2000CodecOptions)) {
            options = JPEG2000CodecOptions.getDefaultOptions(options);
        }
        byte[] buf = null;
        long fp = in.offset();
        buf = options.maxBytes == 0 ? new byte[(int)(in.length() - fp)] : new byte[(int)((long)options.maxBytes - fp)];
        in.read(buf);
        return this.decompress(buf, options);
    }

    @Override
    public byte[] decompress(byte[] buf, CodecOptions options) throws FormatException {
        options = options == null || !(options instanceof JPEG2000CodecOptions) ? JPEG2000CodecOptions.getDefaultOptions(options) : new JPEG2000CodecOptions(options);
        byte[][] single = null;
        WritableRaster b = null;
        int bpp = options.bitsPerSample / 8;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
            b = (WritableRaster)this.jaiIIOService.readRaster(bis, (JPEG2000CodecOptions)options);
            single = AWTImageTools.getPixelBytes(b, options.littleEndian);
            bpp = single[0].length / (b.getWidth() * b.getHeight());
            bis.close();
            b = null;
        }
        catch (IOException e) {
            throw new FormatException("Could not decompress JPEG2000 image. Please make sure that jai_imageio.jar is installed.", e);
        }
        catch (ServiceException e) {
            throw new FormatException("Could not decompress JPEG2000 image. Please make sure that jai_imageio.jar is installed.", e);
        }
        if (single.length == 1) {
            return single[0];
        }
        byte[] rtn = new byte[single.length * single[0].length];
        if (options.interleaved) {
            int next = 0;
            for (int i = 0; i < single[0].length / bpp; ++i) {
                for (int j = 0; j < single.length; ++j) {
                    for (int bb = 0; bb < bpp; ++bb) {
                        rtn[next++] = single[j][i * bpp + bb];
                    }
                }
            }
        } else {
            for (int i = 0; i < single.length; ++i) {
                System.arraycopy(single[i], 0, rtn, i * single[0].length, single[i].length);
            }
        }
        single = null;
        return rtn;
    }
}

