/*
 * Decompiled with CFR 0.152.
 */
package io.scif.commands;

import io.scif.services.DatasetIOService;
import java.io.File;
import java.io.IOException;
import net.imagej.Dataset;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.log.LogService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;

@Plugin(type=Command.class, menu={@Menu(label="File", weight=0.0, mnemonic=102), @Menu(label="Save As...", weight=21.0, accelerator="shift ^S")}, attrs={@Attr(name="no-legacy")})
public class SaveAsImage
extends ContextCommand {
    @Parameter
    private LogService log;
    @Parameter
    private DatasetIOService datasetIOService;
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private UIService uiService;
    @Parameter(label="File to save", style="save", initializer="initOutputFile", persist=false)
    private File outputFile;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;

    public void run() {
        Dataset dataset = this.dataset();
        try {
            this.datasetIOService.save(dataset, (Location)new FileLocation(this.outputFile.getAbsolutePath()));
        }
        catch (IOException exc) {
            this.log.error((Throwable)exc);
            this.uiService.showDialog(exc.getMessage(), "Error Saving Image", DialogPrompt.MessageType.ERROR_MESSAGE);
            return;
        }
        this.display.setName(dataset.getName());
    }

    protected void initOutputFile() {
        Dataset dataset = this.dataset();
        if (dataset == null) {
            return;
        }
        this.outputFile = new File(dataset.getSource());
    }

    private Dataset dataset() {
        return this.imageDisplayService.getActiveDataset(this.display);
    }
}

