/*
 * Decompiled with CFR 0.152.
 */
package io.scif.filters;

import io.scif.ByteArrayPlane;
import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.AbstractReaderFilter;
import io.scif.filters.Filter;
import io.scif.filters.MetadataWrapper;
import io.scif.filters.PlaneSeparatorMetadata;
import io.scif.util.FormatTools;
import io.scif.util.ImageTools;
import io.scif.util.MemoryTools;
import java.io.IOException;
import java.util.Arrays;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.util.Intervals;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;
import org.scijava.plugin.Plugin;
import org.scijava.util.ArrayUtils;

@Plugin(type=Filter.class)
public class PlaneSeparator
extends AbstractReaderFilter {
    private Plane lastPlane = null;
    private long lastPlaneIndex = -1L;
    private int lastImageIndex = -1;
    private long[] lastPlaneMin = null;
    private long[] lastPlaneMax = null;

    public PlaneSeparator() {
        super((Class<? extends MetadataWrapper>)PlaneSeparatorMetadata.class);
    }

    public void separate(AxisType ... types) {
        if (this.metaCheck()) {
            ((PlaneSeparatorMetadata)this.getMetadata()).separate(types);
        }
    }

    public long getOriginalIndex(int imageIndex, long planeIndex) {
        long originalCount;
        long planeCount = this.getPlaneCount(imageIndex);
        if (planeCount == (originalCount = ((Reader)this.getParent()).getPlaneCount(imageIndex))) {
            return planeIndex;
        }
        long[] coords = FormatTools.rasterToPosition(imageIndex, planeIndex, this);
        int offset = 0;
        if (PlaneSeparatorMetadata.class.isAssignableFrom(this.getMetadata().getClass())) {
            offset = ((PlaneSeparatorMetadata)this.getMetadata()).offset();
        }
        long[] originalCoords = new long[coords.length - offset];
        long[] lengths = new long[coords.length - offset];
        for (int i = 0; i < originalCoords.length; ++i) {
            originalCoords[i] = coords[i + offset];
            lengths[i] = this.getMetadata().get(imageIndex).getAxesLengthsNonPlanar()[i + offset];
        }
        return FormatTools.positionToRaster(lengths, originalCoords);
    }

    @Override
    public void setSource(Location source) throws IOException {
        this.cleanUp();
        super.setSource(source);
    }

    @Override
    public void setSource(DataHandle<Location> source) throws IOException {
        this.cleanUp();
        super.setSource(source);
    }

    @Override
    public long getPlaneCount(int imageIndex) {
        return this.getMetadata().get(imageIndex).getPlaneCount();
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Interval bounds) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, bounds, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, Interval bounds) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, bounds, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, SCIFIOConfig config) throws FormatException, IOException {
        Interval bounds = this.planarBounds(imageIndex);
        return this.openPlane(imageIndex, planeIndex, bounds, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, SCIFIOConfig config) throws FormatException, IOException {
        Interval bounds = this.planarBounds(imageIndex);
        return this.openPlane(imageIndex, planeIndex, plane, bounds, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
        Plane plane = this.createPlane(this.getMetadata().get(imageIndex), bounds);
        return this.openPlane(imageIndex, planeIndex, plane, bounds, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
        FormatTools.checkPlaneNumber(this.getMetadata(), imageIndex, planeIndex);
        Metadata meta = this.getMetadata();
        Metadata parentMeta = this.getParentMeta();
        long source = this.getOriginalIndex(imageIndex, planeIndex);
        int splitOffset = this.metaCheck() ? ((PlaneSeparatorMetadata)meta).offset() : 0;
        boolean interleaved = parentMeta.get(imageIndex).getInterleavedAxisCount() > 0;
        PlaneSeparator planeSeparator = this;
        synchronized (planeSeparator) {
            if (!parentMeta.get(imageIndex).isIndexed()) {
                long[] completePosition = FormatTools.rasterToPosition(imageIndex, planeIndex, meta);
                long[] separatedPosition = Arrays.copyOf(completePosition, splitOffset);
                long[] separatedLengths = Arrays.copyOf(meta.get(imageIndex).getAxesLengthsNonPlanar(), splitOffset);
                int bpp = FormatTools.getBytesPerPixel(meta.get(imageIndex).getPixelType());
                if (!ByteArrayPlane.class.isAssignableFrom(plane.getClass())) {
                    plane = new ByteArrayPlane(meta.get(imageIndex), bounds);
                }
                if (!this.haveCached(source, imageIndex, bounds)) {
                    int strips = 1;
                    long availableMemory = MemoryTools.totalAvailableMemory() / 16L;
                    long planeSize = meta.get(imageIndex).getPlaneSize();
                    long h = bounds.dimension(meta.get(imageIndex).getAxisIndex(Axes.Y));
                    if (availableMemory < planeSize || planeSize > Integer.MAX_VALUE) {
                        strips = (int)Math.sqrt(h);
                    }
                    long[] dims = Intervals.dimensionsAsLongArray((Dimensions)bounds);
                    long stripHeight = h / (long)strips;
                    long lastStripHeight = stripHeight + (h - stripHeight * (long)strips);
                    byte[] strip = strips == 1 ? plane.getBytes() : new byte[(int)(stripHeight * (long)ArrayUtils.safeMultiply32((long[])Arrays.copyOf(dims, dims.length - 1)) * (long)bpp)];
                    this.updateLastPlaneInfo(source, imageIndex, splitOffset, bounds);
                    int parentYIndex = parentMeta.get(imageIndex).getAxisIndex(Axes.Y);
                    int yIndex = meta.get(imageIndex).getAxisIndex(Axes.Y);
                    for (int i = 0; i < strips; ++i) {
                        this.lastPlaneMin[parentYIndex] = bounds.min(yIndex) + (long)i * stripHeight;
                        this.lastPlaneMax[parentYIndex] = this.lastPlaneMin[parentYIndex] + (i == strips - 1 ? lastStripHeight : stripHeight) - 1L;
                        this.lastPlane = ((Reader)this.getParent()).openPlane(imageIndex, (long)((int)source), (Interval)new FinalInterval(this.lastPlaneMin, this.lastPlaneMax), config);
                        plane.setColorTable(this.lastPlane.getColorTable());
                        if (strips != 1 && lastStripHeight != stripHeight && i == strips - 1) {
                            strip = new byte[(int)(lastStripHeight * (long)ArrayUtils.safeMultiply32((long[])Arrays.copyOf(dims, dims.length - 1)) * (long)bpp)];
                        }
                        ImageTools.splitChannels(this.lastPlane.getBytes(), strip, separatedPosition, separatedLengths, bpp, false, interleaved, strips == 1 ? (long)(bpp * ArrayUtils.safeMultiply32((long[])dims)) : (long)strip.length);
                        if (strips == 1) continue;
                        System.arraycopy(strip, 0, plane.getBytes(), (int)((long)i * stripHeight * (long)ArrayUtils.safeMultiply32((long[])Arrays.copyOf(dims, dims.length - 1))) * bpp, strip.length);
                    }
                } else {
                    ImageTools.splitChannels(this.lastPlane.getBytes(), plane.getBytes(), separatedPosition, separatedLengths, bpp, false, interleaved, bpp * ArrayUtils.safeMultiply32((long[])new long[]{Intervals.numElements((Dimensions)bounds)}));
                }
                return plane;
            }
            if (!this.haveCached(source, imageIndex, bounds)) {
                this.updateLastPlaneInfo(source, imageIndex, splitOffset, bounds);
                this.lastPlane = ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, plane, (Interval)new FinalInterval(this.lastPlaneMin, this.lastPlaneMax), config);
            }
        }
        return this.lastPlane;
    }

    public double getPriority() {
        return 2.0;
    }

    private void updateLastPlaneInfo(long source, int imageIndex, int splitOffset, Interval bounds) {
        Metadata meta = this.getMetadata();
        Metadata parentMeta = this.getParentMeta();
        this.lastPlaneIndex = source;
        this.lastImageIndex = imageIndex;
        this.lastPlaneMin = new long[bounds.numDimensions() + splitOffset];
        this.lastPlaneMax = new long[bounds.numDimensions() + splitOffset];
        for (CalibratedAxis axis : parentMeta.get(imageIndex).getAxesPlanar()) {
            int parentIndex = parentMeta.get(imageIndex).getAxisIndex(axis.type());
            int currentIndex = meta.get(imageIndex).getAxisIndex(axis.type());
            if (currentIndex >= 0 && currentIndex < meta.get(imageIndex).getPlanarAxisCount()) {
                this.lastPlaneMin[parentIndex] = bounds.min(currentIndex);
                this.lastPlaneMax[parentIndex] = bounds.max(currentIndex);
                continue;
            }
            if (parentMeta.get(imageIndex).getAxisIndex(axis.type()) >= parentMeta.get(imageIndex).getPlanarAxisCount()) continue;
            this.lastPlaneMin[parentIndex] = 0L;
            this.lastPlaneMax[parentIndex] = parentMeta.get(imageIndex).getAxisLength(axis.type()) - 1L;
        }
    }

    private boolean haveCached(long source, int imageIndex, Interval bounds) {
        if (source != this.lastPlaneIndex || imageIndex != this.lastImageIndex || this.lastPlane == null || this.lastPlaneMin == null || this.lastPlaneMax == null) {
            return false;
        }
        for (int d = 0; d < bounds.numDimensions(); ++d) {
            if (bounds.min(d) != this.lastPlaneMin[d]) {
                return false;
            }
            if (bounds.max(d) == this.lastPlaneMax[d]) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void cleanUp() throws IOException {
        super.cleanUp();
        this.lastPlane = null;
        this.lastPlaneIndex = -1L;
        this.lastImageIndex = -1;
        this.lastPlaneMin = null;
        this.lastPlaneMax = null;
    }
}

