/*
 * Decompiled with CFR 0.152.
 */
package io.scif.gui;

import io.scif.Format;
import io.scif.FormatException;
import io.scif.config.SCIFIOConfig;
import java.io.File;
import java.io.FileFilter;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;

public class FormatFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter,
Comparable<javax.swing.filechooser.FileFilter> {
    private final Format format;
    private final String desc;

    public FormatFileFilter(Format format) {
        this.format = format;
        StringBuilder sb = new StringBuilder(format.getFormatName());
        boolean first = true;
        for (String suffix : format.getSuffixes()) {
            if (suffix == null || suffix.equals("")) continue;
            if (first) {
                sb.append(" (");
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("*.");
            sb.append(suffix);
        }
        sb.append(")");
        this.desc = sb.toString();
    }

    public Format getFormat() {
        return this.format;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        try {
            return this.format.createChecker().isFormat((Location)new FileLocation(f), new SCIFIOConfig().checkerSetOpen(false));
        }
        catch (FormatException e) {
            return false;
        }
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public String toString() {
        return "FormatFileFilter: " + this.desc;
    }

    @Override
    public int compareTo(javax.swing.filechooser.FileFilter o) {
        return this.desc.compareTo(o.getDescription());
    }
}

