/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.bdv;

import bdv.util.Bdv;
import bdv.util.BdvHandle;
import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.ViewerStateChange;
import java.util.function.Consumer;
import net.imglib2.Interval;
import sc.fiji.labkit.ui.bdv.BdvLayer;
import sc.fiji.labkit.ui.bdv.BdvShowable;
import sc.fiji.labkit.ui.models.Holder;
import sc.fiji.labkit.ui.utils.Notifier;

public class BdvLayerLink
implements Holder<BdvStackSource<?>> {
    private final BdvHandle handle;
    private final SynchronizedViewerState viewerState;
    private final BdvLayer layer;
    private final Notifier notifier = new Notifier();
    private final Runnable onImageChanged = this::onImageChanged;
    private final Runnable onVisibilityChanged = this::updateBdv;
    private final Consumer<Interval> onRequestRepaint = this::onRequestRepaint;
    private BdvStackSource<?> bdvSource;

    public BdvLayerLink(BdvLayer layer, BdvHandle handle) {
        this.handle = handle;
        this.viewerState = handle.getViewerPanel().state();
        this.layer = layer;
        BdvOptions options = BdvOptions.options().addTo((Bdv)handle);
        Holder<BdvShowable> image = layer.image();
        BdvShowable showable1 = image.get();
        this.bdvSource = showable1 != null ? showable1.show(layer.title(), options) : null;
        image.notifier().addWeakListener(this.onImageChanged);
        layer.listeners().addWeakListener(this.onRequestRepaint);
        layer.visibility().notifier().addWeakListener(this.onVisibilityChanged);
        this.viewerState.changeListeners().add(this::onViewerStateChanged);
    }

    private void onImageChanged() {
        BdvShowable showable;
        BdvStackSource<?> source1 = this.bdvSource;
        this.bdvSource = null;
        if (source1 != null) {
            source1.removeFromBdv();
        }
        if ((showable = this.layer.image().get()) != null) {
            this.bdvSource = showable.show(this.layer.title(), BdvOptions.options().addTo((Bdv)this.handle));
            this.bdvSource.setActive(this.layer.visibility().get().booleanValue());
        }
        this.updateBdv();
        this.notifier.notifyListeners();
    }

    private void onRequestRepaint(Interval interval) {
        if (interval == null) {
            this.handle.getViewerPanel().requestRepaint();
        } else {
            this.handle.getViewerPanel().requestRepaint(interval);
        }
    }

    private void updateBdv() {
        if (this.bdvSource != null) {
            try {
                this.bdvSource.setActive(this.layer.visibility().get().booleanValue());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void onViewerStateChanged(ViewerStateChange change) {
        BdvStackSource<?> source1 = this.bdvSource;
        if (source1 != null && change == ViewerStateChange.VISIBILITY_CHANGED) {
            boolean visible = this.viewerState.isSourceActive((SourceAndConverter)source1.getSources().get(0));
            this.layer.visibility().set(visible);
        }
    }

    @Override
    public void set(BdvStackSource<?> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BdvStackSource<?> get() {
        return this.bdvSource;
    }

    @Override
    public Notifier notifier() {
        return this.notifier;
    }
}

